/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.Collection;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.AccountFeeLog;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountFeeLogServiceLocal;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.accountfees.AccountFeeExecutionSearchData;
import org.cyclos.model.banking.accountfees.AccountFeeExecutionVO;
import org.cyclos.model.banking.accountfees.AccountFeeLogData;
import org.cyclos.model.banking.accountfees.AccountFeeLogQuery;
import org.cyclos.model.banking.accountfees.AccountFeeLogVO;
import org.cyclos.model.banking.accountfees.AccountFeeLogsSearchData;
import org.cyclos.model.banking.accountfees.AccountFeeQuery;
import org.cyclos.model.banking.accountfees.AccountFeeVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.banking.AccountFeeLogService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AccountFeeLogServiceSecurity
extends BaseServiceSecurity
implements AccountFeeLogService {
    @Autowired
    private AccountFeeLogServiceLocal accountFeeLogService;

    public void checkVisible(AccountFee accountFee) {
        PermissionHelper.checkContains((Collection)this.getProducts().userManagement().getUserAccountsAccess(), (Object)accountFee.getAccountType());
    }

    public AccountFeeLog checkVisible(Long l) {
        this.checkPermission(Permission.ACCOUNT_FEE_LOGS_VIEW);
        AccountFeeLog accountFeeLog = this.find(AccountFeeLog.class, l);
        this.checkVisible(accountFeeLog.getAccountFee());
        return accountFeeLog;
    }

    public AccountFeeLogData getData(Long l) throws FrameworkException {
        this.checkVisible(l);
        AccountFeeLogData accountFeeLogData = this.accountFeeLogService.getData(l);
        accountFeeLogData.setCanRechargeFailed(accountFeeLogData.isCanRechargeFailed() && this.hasPermission(Permission.ACCOUNT_FEE_LOGS_MANAGE));
        return accountFeeLogData;
    }

    public AccountFeeExecutionSearchData getFeeExecutionsSearchData() throws FrameworkException {
        this.checkPermission(Permission.ACCOUNT_FEE_LOGS_VIEW);
        return this.accountFeeLogService.getFeeExecutionsSearchData();
    }

    public AccountFeeLogsSearchData getSearchData(AccountFeeVO accountFeeVO) throws FrameworkException {
        AccountFee accountFee = (AccountFee)this.conversionHandler.convert(AccountFee.class, (Object)accountFeeVO);
        this.checkVisible(accountFee);
        AccountFeeLogsSearchData accountFeeLogsSearchData = this.accountFeeLogService.getSearchData(accountFeeVO);
        if (accountFeeLogsSearchData.isAllowManualCharge()) {
            accountFeeLogsSearchData.setAllowManualCharge(this.hasPermission(Permission.ACCOUNT_FEE_LOGS_MANAGE));
        }
        return accountFeeLogsSearchData;
    }

    public boolean isVisible(AccountFeeLog accountFeeLog) {
        return this.hasPermission(Permission.ACCOUNT_FEE_LOGS_VIEW);
    }

    public void rechargeFailed(Long l) throws FrameworkException {
        AccountFeeLog accountFeeLog = this.find(AccountFeeLog.class, l);
        this.checkVisible(accountFeeLog.getAccountFee());
        this.checkPermission(Permission.ACCOUNT_FEE_LOGS_MANAGE);
        this.accountFeeLogService.rechargeFailed(l);
    }

    public Long runNow(AccountFeeVO accountFeeVO) throws FrameworkException {
        AccountFee accountFee = (AccountFee)this.conversionHandler.convert(AccountFee.class, (Object)accountFeeVO);
        this.checkVisible(accountFee);
        this.checkPermission(Permission.ACCOUNT_FEE_LOGS_MANAGE);
        return this.accountFeeLogService.runNow(accountFeeVO);
    }

    public Page<AccountFeeLogVO> search(AccountFeeLogQuery accountFeeLogQuery) throws FrameworkException {
        this.checkPermission(Permission.ACCOUNT_FEE_LOGS_VIEW);
        AccountFee accountFee = (AccountFee)this.conversionHandler.convert(AccountFee.class, (Object)accountFeeLogQuery.getAccountFee());
        this.checkVisible(accountFee);
        return this.accountFeeLogService.search(accountFeeLogQuery);
    }

    public Page<AccountFeeExecutionVO> searchFeeExecutions(AccountFeeQuery accountFeeQuery) throws FrameworkException {
        this.checkPermission(Permission.ACCOUNT_FEE_LOGS_VIEW);
        return this.accountFeeLogService.searchFeeExecutions(accountFeeQuery);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<AccountFeeLog>(AccountFeeLog.class){

            public boolean isVisible(SessionData sessionData, AccountFeeLog accountFeeLog) {
                return AccountFeeLogServiceSecurity.this.isVisible(accountFeeLog);
            }
        };
    }
}

