/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.transactions.PaymentData;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentVO;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.TransferFeesPreviewVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.security.banking.TransferServiceSecurity;
import org.cyclos.services.banking.PaymentService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class PaymentServiceSecurity
extends BaseServiceSecurity
implements PaymentService {
    @Autowired
    private PaymentServiceLocal paymentService;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;
    @Autowired
    private TransferServiceSecurity transferServiceSecurity;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;

    public PaymentData getData(Long l) throws FrameworkException {
        Payment payment = this.find(Payment.class, l);
        PaymentData paymentData = this.paymentService.getData(l);
        return this.postProcess(payment, paymentData);
    }

    public PaymentVO perform(PerformPaymentDTO performPaymentDTO) throws FrameworkException, TransferException {
        PaymentTransferType paymentTransferType = this.transactionServiceSecurity.checkPerform((PerformInternalTransactionDTO)performPaymentDTO);
        performPaymentDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        return this.paymentService.perform(performPaymentDTO);
    }

    public PaymentData postProcess(Payment payment, PaymentData paymentData) {
        TransferFeesPreviewVO transferFeesPreviewVO = paymentData.getFeesOnAuthorization();
        if (transferFeesPreviewVO != null) {
            if (paymentData.isCanAuthorize()) {
                transferFeesPreviewVO.getFees().removeIf(transferFeePreviewVO -> !this.accountServiceSecurity.hasAccess(transferFeePreviewVO.getFrom()) && !this.accountServiceSecurity.hasAccess(transferFeePreviewVO.getTo()));
                if (transferFeesPreviewVO.getFees().isEmpty()) {
                    paymentData.setFeesOnAuthorization(null);
                }
            } else {
                paymentData.setFeesOnAuthorization(null);
            }
        }
        if (paymentData.getTransferData() != null) {
            this.transferServiceSecurity.processTransferData((Transfer)payment.getTransfer(), paymentData.getTransferData());
        }
        return this.transactionServiceSecurity.postProcessTransactionData((Transaction)payment, paymentData);
    }

    public PaymentPreviewVO preview(PerformPaymentDTO performPaymentDTO) throws FrameworkException {
        PaymentTransferType paymentTransferType = this.transactionServiceSecurity.checkPerform((PerformInternalTransactionDTO)performPaymentDTO);
        performPaymentDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        return this.paymentService.preview(performPaymentDTO);
    }

    public PaymentPreviewVO previewReceive(PerformPaymentDTO performPaymentDTO) throws FrameworkException, TransferException {
        this.transactionServiceSecurity.checkReceive((PerformInternalTransactionDTO)performPaymentDTO);
        return this.paymentService.previewReceive(performPaymentDTO);
    }

    public PaymentVO receive(PerformPaymentDTO performPaymentDTO) throws FrameworkException, TransferException {
        this.transactionServiceSecurity.checkReceive((PerformInternalTransactionDTO)performPaymentDTO);
        return this.paymentService.receive(performPaymentDTO);
    }

    public void validate(PerformPaymentDTO performPaymentDTO) throws FrameworkException {
        PaymentTransferType paymentTransferType = this.transactionServiceSecurity.checkPerform((PerformInternalTransactionDTO)performPaymentDTO);
        performPaymentDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        this.paymentService.validate(performPaymentDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

