/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.List;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.ScheduledPaymentInstallment;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionWithInstallments;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.ScheduledPaymentServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.transactions.CalculateInstallmentsDTO;
import org.cyclos.model.banking.transactions.InstallmentActionDTO;
import org.cyclos.model.banking.transactions.InstallmentDTO;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformScheduledPaymentDTO;
import org.cyclos.model.banking.transactions.ScheduledPaymentActionDTO;
import org.cyclos.model.banking.transactions.ScheduledPaymentData;
import org.cyclos.model.banking.transactions.ScheduledPaymentPreviewVO;
import org.cyclos.model.banking.transactions.ScheduledPaymentVO;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.services.banking.ScheduledPaymentService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ScheduledPaymentServiceSecurity
extends BaseServiceSecurity
implements ScheduledPaymentService {
    @Autowired
    private ScheduledPaymentServiceLocal scheduledPaymentService;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;

    public void block(ScheduledPaymentActionDTO scheduledPaymentActionDTO) throws FrameworkException {
        ScheduledPayment scheduledPayment = this.checkAccess(scheduledPaymentActionDTO);
        if (!this.canBlock((TransactionWithInstallments<?>)scheduledPayment)) {
            throw new PermissionDeniedException();
        }
        this.scheduledPaymentService.block(scheduledPaymentActionDTO);
    }

    public List<InstallmentDTO> calculateInstallments(CalculateInstallmentsDTO calculateInstallmentsDTO) throws FrameworkException {
        PaymentTransferType paymentTransferType = this.transactionServiceSecurity.checkPerform(calculateInstallmentsDTO);
        calculateInstallmentsDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        return this.scheduledPaymentService.calculateInstallments(calculateInstallmentsDTO);
    }

    public List<InstallmentDTO> calculateInstallmentsReceive(CalculateInstallmentsDTO calculateInstallmentsDTO) throws FrameworkException {
        PaymentTransferType paymentTransferType = this.transactionServiceSecurity.checkReceive(calculateInstallmentsDTO);
        calculateInstallmentsDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        return this.scheduledPaymentService.calculateInstallmentsReceive(calculateInstallmentsDTO);
    }

    public boolean canBlock(TransactionWithInstallments<?> transactionWithInstallments) {
        if (transactionWithInstallments.isFromSystem()) {
            return this.permission(Permission.SYSTEM_SCHEDULED_PAYMENTS_BLOCK).granted() && this.accountServiceSecurity.hasAccess((InternalAccountOwner)SystemAccountOwner.instance(), transactionWithInstallments.getType().getFrom());
        }
        User user = transactionWithInstallments.getFromUser();
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_SCHEDULED_PAYMENTS_BLOCK}).user(new Permission[]{Permission.USER_SCHEDULED_PAYMENTS_BLOCK}).granted();
    }

    public boolean canCancel(TransactionWithInstallments<?> transactionWithInstallments) {
        if (transactionWithInstallments.isFromSystem()) {
            return this.permission(Permission.SYSTEM_SCHEDULED_PAYMENTS_CANCEL).granted() && this.accountServiceSecurity.hasAccess((InternalAccountOwner)SystemAccountOwner.instance(), transactionWithInstallments.getType().getFrom());
        }
        User user = transactionWithInstallments.getFromUser();
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_SCHEDULED_PAYMENTS_CANCEL}).user(new Permission[]{Permission.USER_SCHEDULED_PAYMENTS_CANCEL}).granted();
    }

    public void cancel(ScheduledPaymentActionDTO scheduledPaymentActionDTO) throws FrameworkException {
        ScheduledPayment scheduledPayment = this.checkAccess(scheduledPaymentActionDTO);
        if (!this.canCancel((TransactionWithInstallments<?>)scheduledPayment)) {
            throw new PermissionDeniedException();
        }
        this.scheduledPaymentService.cancel(scheduledPaymentActionDTO);
    }

    public boolean canModify(TransactionWithInstallments<?> transactionWithInstallments) {
        if (transactionWithInstallments.isFromSystem()) {
            return this.permission(Permission.SYSTEM_SCHEDULED_PAYMENTS_MODIFY).granted() && this.accountServiceSecurity.hasAccess((InternalAccountOwner)SystemAccountOwner.instance(), transactionWithInstallments.getType().getFrom());
        }
        User user = transactionWithInstallments.getFromUser();
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_SCHEDULED_PAYMENTS_MODIFY}).user(new Permission[]{Permission.USER_SCHEDULED_PAYMENTS_MODIFY}).granted();
    }

    public boolean canProcessInstallments(TransactionWithInstallments<?> transactionWithInstallments) {
        if (transactionWithInstallments.isFromSystem()) {
            return this.permission(Permission.SYSTEM_SCHEDULED_PAYMENTS_PROCESS_INSTALLMENT).granted();
        }
        User user = transactionWithInstallments.getFromUser();
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_SCHEDULED_PAYMENTS_PROCESS_INSTALLMENT}).user(new Permission[]{Permission.USER_SCHEDULED_PAYMENTS_PROCESS_INSTALLMENT}).granted();
    }

    public boolean canSettleInstallments(TransactionWithInstallments<?> transactionWithInstallments) {
        if (transactionWithInstallments.isToSystem()) {
            return this.permission(Permission.SYSTEM_SCHEDULED_PAYMENTS_SETTLE_INSTALLMENT).granted() && this.accountServiceSecurity.hasAccess((InternalAccountOwner)SystemAccountOwner.instance(), transactionWithInstallments.getType().getTo());
        }
        User user = transactionWithInstallments.getToUser();
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_SCHEDULED_PAYMENTS_SETTLE_INSTALLMENT}).user(new Permission[]{Permission.USER_SCHEDULED_PAYMENTS_SETTLE_INSTALLMENT}).granted();
    }

    public boolean canUnblock(TransactionWithInstallments<?> transactionWithInstallments) {
        if (transactionWithInstallments.isFromSystem()) {
            return this.permission(Permission.SYSTEM_SCHEDULED_PAYMENTS_UNBLOCK).granted() && this.accountServiceSecurity.hasAccess((InternalAccountOwner)SystemAccountOwner.instance(), transactionWithInstallments.getType().getFrom());
        }
        User user = transactionWithInstallments.getFromUser();
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_SCHEDULED_PAYMENTS_UNBLOCK}).user(new Permission[]{Permission.USER_SCHEDULED_PAYMENTS_UNBLOCK}).granted();
    }

    public ScheduledPaymentData getData(Long l) throws FrameworkException {
        ScheduledPayment scheduledPayment = this.find(l);
        ScheduledPaymentData scheduledPaymentData = this.scheduledPaymentService.getData(l);
        return this.postProcess(scheduledPayment, scheduledPaymentData);
    }

    public boolean isAccessible(ScheduledPayment scheduledPayment) {
        SessionData sessionData = this.getSessionData();
        boolean bl = false;
        bl = sessionData.isMember() && sessionData.getLoggedUser().equals((Object)scheduledPayment.getToOwner()) ? scheduledPayment.isReceived() || scheduledPayment.isShowToReceiver() : this.transactionServiceSecurity.isAccessible(scheduledPayment.getFromOwner(), TransactionNature.SCHEDULED_PAYMENT) || this.transactionServiceSecurity.isAccessible(scheduledPayment.getToOwner(), TransactionNature.SCHEDULED_PAYMENT);
        return bl && (this.accountServiceSecurity.hasAccess(scheduledPayment.getFrom()) || this.accountServiceSecurity.hasAccess(scheduledPayment.getTo()));
    }

    public ScheduledPaymentVO perform(PerformScheduledPaymentDTO performScheduledPaymentDTO) throws FrameworkException {
        PaymentTransferType paymentTransferType = this.transactionServiceSecurity.checkPerform((PerformInternalTransactionDTO)performScheduledPaymentDTO);
        performScheduledPaymentDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        return this.scheduledPaymentService.perform(performScheduledPaymentDTO);
    }

    public ScheduledPaymentData postProcess(ScheduledPayment scheduledPayment, ScheduledPaymentData scheduledPaymentData) {
        int n;
        scheduledPaymentData.setCanBlock(scheduledPaymentData.isCanBlock() && this.canBlock((TransactionWithInstallments<?>)scheduledPayment));
        scheduledPaymentData.setCanUnblock(scheduledPaymentData.isCanUnblock() && this.canUnblock((TransactionWithInstallments<?>)scheduledPayment));
        scheduledPaymentData.setCanCancel(scheduledPaymentData.isCanCancel() && this.canCancel((TransactionWithInstallments<?>)scheduledPayment));
        boolean bl = this.canProcessInstallments((TransactionWithInstallments<?>)scheduledPayment);
        if (bl) {
            try {
                this.transactionServiceSecurity.check(this.accountHandler.locateOrCurrent((AccountOwner)scheduledPayment.getFromOwner(), true), this.transactionService.locateForPayment(scheduledPayment.getToOwner()), scheduledPayment.getType());
            }
            catch (ValidationException | PermissionDeniedException throwable) {
                bl = false;
            }
        }
        List list = scheduledPaymentData.getCanProcessInstallment();
        for (n = 0; n < list.size(); ++n) {
            list.set(n, (Boolean)list.get(n) != false && bl);
        }
        n = this.canSettleInstallments((TransactionWithInstallments<?>)scheduledPayment) ? 1 : 0;
        List list2 = scheduledPaymentData.getCanSettleInstallment();
        for (int i = 0; i < list2.size(); ++i) {
            boolean bl2 = (Boolean)list2.get(i) != false && n != 0;
            list2.set(i, bl2);
            if (!bl2) continue;
            scheduledPaymentData.setCanSettle(true);
        }
        return this.transactionServiceSecurity.postProcessTransactionData((Transaction)scheduledPayment, scheduledPaymentData);
    }

    public ScheduledPaymentPreviewVO preview(PerformScheduledPaymentDTO performScheduledPaymentDTO) throws FrameworkException {
        PaymentTransferType paymentTransferType = this.transactionServiceSecurity.checkPerform((PerformInternalTransactionDTO)performScheduledPaymentDTO);
        performScheduledPaymentDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        return this.scheduledPaymentService.preview(performScheduledPaymentDTO);
    }

    public ScheduledPaymentPreviewVO previewReceive(PerformScheduledPaymentDTO performScheduledPaymentDTO) throws FrameworkException, TransferException {
        this.transactionServiceSecurity.checkReceive((PerformInternalTransactionDTO)performScheduledPaymentDTO);
        return this.scheduledPaymentService.previewReceive(performScheduledPaymentDTO);
    }

    public TransferVO processInstallment(InstallmentActionDTO installmentActionDTO) throws FrameworkException, TransferException {
        ScheduledPaymentInstallment scheduledPaymentInstallment = (ScheduledPaymentInstallment)this.conversionHandler.convert(ScheduledPaymentInstallment.class, (Object)installmentActionDTO.getInstallment());
        ScheduledPayment scheduledPayment = scheduledPaymentInstallment.getScheduledPayment();
        if (!this.canProcessInstallments((TransactionWithInstallments<?>)scheduledPayment)) {
            throw new PermissionDeniedException();
        }
        this.transactionServiceSecurity.check(this.accountHandler.locateOrCurrent((AccountOwner)scheduledPayment.getFromOwner()), this.transactionService.locateForPayment(scheduledPayment.getToOwner()), scheduledPayment.getType());
        return this.scheduledPaymentService.processInstallment(installmentActionDTO);
    }

    public ScheduledPaymentVO receive(PerformScheduledPaymentDTO performScheduledPaymentDTO) throws FrameworkException, TransferException {
        this.transactionServiceSecurity.checkReceive((PerformInternalTransactionDTO)performScheduledPaymentDTO);
        return this.scheduledPaymentService.receive(performScheduledPaymentDTO);
    }

    public void settleInstallment(InstallmentActionDTO installmentActionDTO) throws FrameworkException, TransferException {
        ScheduledPaymentInstallment scheduledPaymentInstallment = (ScheduledPaymentInstallment)this.conversionHandler.convert(ScheduledPaymentInstallment.class, (Object)installmentActionDTO.getInstallment());
        ScheduledPayment scheduledPayment = scheduledPaymentInstallment.getScheduledPayment();
        if (!this.canSettleInstallments((TransactionWithInstallments<?>)scheduledPayment)) {
            throw new PermissionDeniedException();
        }
        this.scheduledPaymentService.settleInstallment(installmentActionDTO);
    }

    public void settleRemaining(ScheduledPaymentActionDTO scheduledPaymentActionDTO) throws FrameworkException, TransferException {
        ScheduledPayment scheduledPayment = this.checkAccess(scheduledPaymentActionDTO);
        if (!this.canSettleInstallments((TransactionWithInstallments<?>)scheduledPayment)) {
            throw new PermissionDeniedException();
        }
        this.scheduledPaymentService.settleRemaining(scheduledPaymentActionDTO);
    }

    public void unblock(ScheduledPaymentActionDTO scheduledPaymentActionDTO) throws FrameworkException {
        ScheduledPayment scheduledPayment = this.checkAccess(scheduledPaymentActionDTO);
        if (!this.canUnblock((TransactionWithInstallments<?>)scheduledPayment)) {
            throw new PermissionDeniedException();
        }
        this.scheduledPaymentService.unblock(scheduledPaymentActionDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private ScheduledPayment checkAccess(ScheduledPaymentActionDTO scheduledPaymentActionDTO) {
        return (ScheduledPayment)this.conversionHandler.convert(ScheduledPayment.class, (Object)scheduledPaymentActionDTO.getScheduledPayment());
    }

    private ScheduledPayment find(Long l) {
        return this.find(ScheduledPayment.class, l);
    }
}

