/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import com.querydsl.core.types.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionAuthorization;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.OperatorGroupPaymentType;
import org.cyclos.entities.users.QAdminProductAuthorizationRole;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.TransactionAuthorizationServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.users.OperatorGroupServiceLocal;
import org.cyclos.model.CyclosException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.authorizations.AuthorizationAction;
import org.cyclos.model.banking.authorizations.TransactionAuthorizationDTO;
import org.cyclos.model.banking.transactions.PaymentAuthorizationLevelData;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.services.banking.TransactionAuthorizationService;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TransactionAuthorizationServiceSecurity
extends BaseServiceSecurity
implements TransactionAuthorizationService {
    @Autowired
    private TransactionAuthorizationServiceLocal transactionAuthorizationService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private OperatorGroupServiceLocal operatorGroupService;

    public PaymentAuthorizationLevelData authorize(TransactionAuthorizationDTO transactionAuthorizationDTO) {
        this.checkAction(transactionAuthorizationDTO, AuthorizationAction.AUTHORIZED);
        return this.transactionAuthorizationService.authorize(transactionAuthorizationDTO);
    }

    public void cancel(TransactionAuthorizationDTO transactionAuthorizationDTO) {
        this.checkAction(transactionAuthorizationDTO, AuthorizationAction.CANCELED);
        this.transactionAuthorizationService.cancel(transactionAuthorizationDTO);
    }

    public void deny(TransactionAuthorizationDTO transactionAuthorizationDTO) {
        this.checkAction(transactionAuthorizationDTO, AuthorizationAction.DENIED);
        this.transactionAuthorizationService.deny(transactionAuthorizationDTO);
    }

    public Set<AuthorizationAction> getPossibleActions(BasePayment basePayment) {
        Object object;
        User user;
        boolean bl = false;
        boolean bl2 = false;
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        User user2 = user = basicUser == null ? null : basicUser.getUser();
        if (basePayment.isPendingAuthorization()) {
            Object object2;
            object = this.accountService.load(basePayment.getFromOwner(), basePayment.getType().getFrom());
            boolean bl3 = sessionData.manages((BasicUser)basePayment.getFromUser());
            AuthorizationLevel authorizationLevel = basePayment.getNextAuthorizationLevel();
            boolean bl4 = false;
            if (sessionData.isAdmin()) {
                object2 = sessionData.getProducts().admin().getAuthorizationRoles().keysSet((Path)QAdminProductAuthorizationRole.adminProductAuthorizationRole.manage);
                bl4 = CollectionHelper.containsAny((Collection)object2, (Collection)authorizationLevel.getRoles());
            }
            if (basePayment.isFromSystem()) {
                if (basePayment.isToSystem()) {
                    if (this.accountServiceSecurity.hasAccess((Account)object)) {
                        bl = bl4 && sessionData.hasPermission(Permission.ADMIN_AUTHORIZATIONS_MANAGE);
                        bl2 = sessionData.hasPermission(Permission.SYSTEM_AUTHORIZED_PAYMENTS_CANCEL);
                    }
                } else {
                    bl = bl4 && sessionData.hasPermission(Permission.ADMIN_AUTHORIZATIONS_MANAGE) || authorizationLevel.isReceiver() && user.equals((Object)basePayment.getToUser()) && sessionData.hasPermission(Permission.MY_AUTHORIZED_PAYMENTS_AUTHORIZE);
                    bl2 = sessionData.hasPermission(Permission.SYSTEM_AUTHORIZED_PAYMENTS_CANCEL);
                }
            } else {
                object2 = basePayment.getFromUser();
                User user3 = basePayment.getToUser();
                switch (basePayment.getAuthorizationType()) {
                    case OPERATOR: {
                        if (user == null || !user.equals((Object)basePayment.getFromOwner())) break;
                        if (sessionData.isRestrictedOperator()) {
                            Operator operator = sessionData.getLoggedOperator();
                            OperatorGroupPaymentType operatorGroupPaymentType = operator.getGroup().getPaymentType((PaymentTransferType)basePayment.getType());
                            bl = !operator.equals((Object)basePayment.getBy()) && operatorGroupPaymentType != null && operatorGroupPaymentType.isAuthorize();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case LEVEL: {
                        boolean bl5;
                        boolean bl6 = bl5 = authorizationLevel.isBroker() && sessionData.isBrokerOf((BasicUser)object2);
                        if (bl4 && bl3) {
                            bl = this.accountServiceSecurity.hasAccess((Account)object);
                            break;
                        }
                        if (bl5 && sessionData.hasPermission(Permission.BROKER_AUTHORIZED_PAYMENTS_AUTHORIZE)) {
                            bl = true;
                            break;
                        }
                        if (user == null || !authorizationLevel.isPayer() && !authorizationLevel.isReceiver() || !sessionData.hasPermission(Permission.MY_AUTHORIZED_PAYMENTS_AUTHORIZE)) break;
                        bl = user.equals(object2) && authorizationLevel.isPayer() || user.equals((Object)user3) && authorizationLevel.isReceiver();
                        break;
                    }
                }
                bl2 = this.permission((BasicUser)object2).my(new Permission[]{Permission.MY_AUTHORIZED_PAYMENTS_CANCEL}).user(new Permission[]{Permission.USER_AUTHORIZED_PAYMENTS_CANCEL}).granted();
            }
        }
        if (bl && user != null && user.isAdmin()) {
            for (TransactionAuthorization transactionAuthorization : basePayment.getAuthorizations()) {
                if (!user.equals((Object)transactionAuthorization.getBy())) continue;
                bl = false;
                break;
            }
        }
        object = EnumSet.noneOf(AuthorizationAction.class);
        if (bl) {
            object.add(AuthorizationAction.AUTHORIZED);
            object.add(AuthorizationAction.DENIED);
        }
        if (bl2) {
            try {
                this.transactionServiceSecurity.checkIgnoringSessionData(this.accountHandler.locate((AccountOwner)basePayment.getFromOwner()), this.transactionService.locateForPayment(basePayment.getToOwner()), basePayment.getType());
                object.add(AuthorizationAction.CANCELED);
            }
            catch (CyclosException cyclosException) {
                // empty catch block
            }
        }
        return object;
    }

    public boolean hasViewPermission(InternalAccountOwner internalAccountOwner) {
        return this.locateForView(internalAccountOwner) != null;
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<TransactionAuthorization>(TransactionAuthorization.class){

            public boolean isVisible(SessionData sessionData, TransactionAuthorization transactionAuthorization) {
                return TransactionAuthorizationServiceSecurity.this.transactionServiceSecurity.isAccessible((Transaction)transactionAuthorization.getTransaction());
            }
        };
    }

    private void checkAction(TransactionAuthorizationDTO transactionAuthorizationDTO, AuthorizationAction authorizationAction) {
        BasePayment basePayment = this.getTransaction(transactionAuthorizationDTO);
        if (!this.getPossibleActions(basePayment).contains(authorizationAction)) {
            throw new PermissionDeniedException();
        }
    }

    private BasePayment getTransaction(TransactionAuthorizationDTO transactionAuthorizationDTO) {
        return (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionAuthorizationDTO.getTransaction());
    }

    private LocateAccountOwnerResult locateForView(InternalAccountOwner internalAccountOwner) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner);
        boolean bl = false;
        if (locateAccountOwnerResult.getInternalAccountOwner() == null) {
            bl = this.hasPermission(Permission.BROKER_AUTHORIZED_PAYMENTS_VIEW, Permission.ADMIN_AUTHORIZATIONS_VIEW);
        } else if (locateAccountOwnerResult.isSystem()) {
            bl = this.hasPermission(Permission.ADMIN_AUTHORIZATIONS_VIEW);
        } else if (locateAccountOwnerResult.isUser()) {
            User user;
            SessionData sessionData = this.getSessionData();
            if (sessionData.isAdminOf((BasicUser)(user = locateAccountOwnerResult.getUser()))) {
                bl = sessionData.hasPermission(Permission.ADMIN_AUTHORIZATIONS_VIEW);
            } else if (sessionData.isBrokerOf((BasicUser)user)) {
                bl = sessionData.hasPermission(Permission.BROKER_AUTHORIZED_PAYMENTS_VIEW);
            } else if (user.equals((Object)sessionData.getLoggedUser())) {
                OperatorGroup operatorGroup;
                bl = sessionData.isRestrictedOperator() ? this.operatorGroupService.anyRequiresAuthorization(operatorGroup = sessionData.getLoggedOperator().getGroup()) || this.operatorGroupService.canAuthorizeAnyPayment(operatorGroup) || sessionData.hasPermission(Permission.MY_AUTHORIZED_PAYMENTS_VIEW) : sessionData.hasPermission(Permission.MY_AUTHORIZED_PAYMENTS_VIEW) || sessionData.hasPermission(Permission.MY_OPERATORS_ENABLE) && this.operatorGroupService.anyRequiresAuthorization(sessionData.getLoggedUser());
            }
        }
        return bl ? locateAccountOwnerResult : null;
    }
}

