/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.List;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransactionCustomFieldPossibleValue;
import org.cyclos.entities.banking.TransactionCustomFieldPossibleValueCategory;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.transactionfields.TransactionCustomFieldDTO;
import org.cyclos.model.banking.transactionfields.TransactionCustomFieldData;
import org.cyclos.model.banking.transactionfields.TransactionCustomFieldDetailedVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.security.Security;
import org.cyclos.security.system.BaseSimpleCustomFieldServiceSecurity;
import org.cyclos.services.banking.TransactionCustomFieldService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TransactionCustomFieldServiceSecurity
extends BaseSimpleCustomFieldServiceSecurity<TransactionCustomFieldDTO, TransactionCustomField, TransactionCustomFieldPossibleValueCategory, TransactionCustomFieldPossibleValue, TransactionCustomFieldData, Void>
implements TransactionCustomFieldService {
    @Autowired
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;

    public TransactionCustomFieldServiceSecurity() {
        super(TransactionCustomField.class, Permission.ACCOUNT_CONFIGURATION_VIEW, Permission.ACCOUNT_CONFIGURATION_MANAGE);
    }

    public void addRelation(TransferTypeVO transferTypeVO, CustomFieldVO customFieldVO) throws EntityNotFoundException {
        this.checkManagePermission();
        this.transactionCustomFieldService.addRelation(transferTypeVO, customFieldVO);
    }

    public List<TransactionCustomFieldDetailedVO> list() {
        this.checkViewPermission();
        return this.transactionCustomFieldService.list();
    }

    public List<CustomFieldVO> listAllRelated(TransferTypeVO transferTypeVO) throws FrameworkException {
        this.checkViewPermission();
        return this.transactionCustomFieldService.listAllRelated(transferTypeVO);
    }

    public List<CustomFieldVO> listRelated(TransferTypeVO transferTypeVO) throws EntityNotFoundException {
        this.checkViewPermission();
        return this.transactionCustomFieldService.listRelated(transferTypeVO);
    }

    public void removeRelation(TransferTypeVO transferTypeVO, CustomFieldVO customFieldVO) throws EntityNotFoundException {
        this.checkManagePermission();
        this.transactionCustomFieldService.removeRelation(transferTypeVO, customFieldVO);
    }

    protected TransactionCustomFieldServiceLocal getImplementation() {
        return this.transactionCustomFieldService;
    }
}

