/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.Arrays;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.transfers.TransferActionDTO;
import org.cyclos.model.banking.transfers.TransferData;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.services.banking.TransferService;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TransferServiceSecurity
extends BaseServiceSecurity
implements TransferService {
    @Autowired
    private TransferServiceLocal transferService;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;
    @Autowired
    private OperatorServiceLocal operatorService;

    public Long chargeback(@NotNull TransferActionDTO transferActionDTO) throws FrameworkException, TransferException {
        Transfer transfer = (Transfer)this.conversionHandler.convert(Transfer.class, (Object)transferActionDTO.getTransfer());
        if (!this.canChargeback(transfer)) {
            throw new PermissionDeniedException();
        }
        return this.transferService.chargeback(transferActionDTO);
    }

    public FileInfo exportTransfer(ExportFormatVO exportFormatVO, TransferVO transferVO) {
        return this.transferService.exportTransfer(exportFormatVO, transferVO);
    }

    public TransferData getData(TransferVO transferVO) throws IllegalArgumentException {
        Transfer transfer = (Transfer)this.conversionHandler.convert(Transfer.class, (Object)transferVO);
        TransferData transferData = this.transferService.getData(transferVO);
        this.processTransferData(transfer, transferData);
        if (transferData.getTransactionData() != null) {
            this.transactionServiceSecurity.postProcess(transfer.getTransaction(), transferData.getTransactionData());
        }
        return transferData;
    }

    public boolean isVisible(Trans trans) throws FrameworkException {
        BasePayment basePayment;
        Transaction transaction;
        SessionData sessionData = this.getSessionData();
        Transaction transaction2 = transaction = trans instanceof Transfer ? ((Transfer)trans).getRoot().getTransaction() : (Transaction)ObjectHelper.ifType((Object)trans, Transaction.class);
        if (transaction != null && sessionData.isLoggedIn()) {
            Operator operator;
            basePayment = (BasePayment)ObjectHelper.ifType((Object)transaction, BasePayment.class);
            BasicUser basicUser = transaction.getBy();
            Operator operator2 = operator = basePayment == null ? null : basePayment.getReceivedBy();
            if ((Arrays.asList(trans.getToUser(), operator).contains(sessionData.getLoggedBasicUser()) || sessionData.getLoggedBasicUser().equals((Object)basicUser)) && (sessionData.manages((BasicUser)trans.getFromUser()) || sessionData.manages((BasicUser)trans.getToUser()))) {
                return true;
            }
        }
        if (this.accountServiceSecurity.hasAccess(trans.getFrom()) && ((basePayment = this.operatorService.accountAccess(trans.getFrom())) == null || basePayment.allowsOutgoing())) {
            return true;
        }
        return this.accountServiceSecurity.hasAccess(trans.getTo()) && ((basePayment = this.operatorService.accountAccess(trans.getTo())) == null || basePayment.allowsIncoming());
    }

    public TransferVO load(Long l) throws FrameworkException {
        return this.transferService.load(l);
    }

    public TransferVO loadByTransactionNumber(String string) throws FrameworkException {
        TransferVO transferVO = this.transferService.loadByTransactionNumber(string);
        this.checkVO(Transfer.class, (EntityVO)transferVO);
        return transferVO;
    }

    public void processTransferData(Transfer transfer, TransferData transferData) {
        transferData.setCanChargeback(transferData.isCanChargeback() && this.canChargeback(transfer));
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<Transfer>(Transfer.class){

            public boolean isVisible(SessionData sessionData, Transfer transfer) {
                return TransferServiceSecurity.this.isVisible((Trans)transfer);
            }
        };
    }

    private boolean canChargeback(Transfer transfer) {
        InternalAccountOwner internalAccountOwner = transfer.getToOwner();
        if (internalAccountOwner instanceof SystemAccountOwner) {
            return this.permission(Permission.SYSTEM_PAYMENTS_CHARGEBACK).value((Object)transfer.getType()).granted();
        }
        if (internalAccountOwner instanceof User) {
            return this.permission((BasicUser)((User)internalAccountOwner)).my(new Permission[]{Permission.MY_PAYMENTS_CHARGEBACK}).user(new Permission[]{Permission.USER_PAYMENTS_CHARGEBACK}).value((Object)transfer.getType()).granted();
        }
        throw new IllegalStateException("Unhandled account owner: " + String.valueOf(internalAccountOwner));
    }
}

