/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.contentmanagement;

import java.util.List;
import org.cyclos.entities.contentmanagement.Document;
import org.cyclos.entities.contentmanagement.DocumentCustomField;
import org.cyclos.entities.contentmanagement.DocumentCustomFieldPossibleValue;
import org.cyclos.entities.contentmanagement.DocumentCustomFieldPossibleValueCategory;
import org.cyclos.impl.contentmanagement.DocumentCustomFieldServiceLocal;
import org.cyclos.model.contentmanagement.documentfields.DocumentCustomFieldDTO;
import org.cyclos.model.contentmanagement.documentfields.DocumentCustomFieldData;
import org.cyclos.model.contentmanagement.documents.DocumentVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.security.Security;
import org.cyclos.security.contentmanagement.DocumentServiceSecurity;
import org.cyclos.security.system.BaseCustomFieldServiceSecurity;
import org.cyclos.services.contentmanagement.DocumentCustomFieldService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class DocumentCustomFieldServiceSecurity
extends BaseCustomFieldServiceSecurity<DocumentCustomFieldDTO, DocumentCustomField, DocumentCustomFieldPossibleValueCategory, DocumentCustomFieldPossibleValue, DocumentCustomFieldData, Long>
implements DocumentCustomFieldService {
    @Autowired
    private DocumentCustomFieldServiceLocal documentCustomFieldService;
    @Autowired
    private DocumentServiceSecurity documentServiceSecurity;

    public DocumentCustomFieldServiceSecurity() {
        super(DocumentCustomField.class);
    }

    @Override
    public boolean doHasManageAccess(DocumentCustomField documentCustomField) {
        return this.documentServiceSecurity.hasManageAccess(documentCustomField.getDocument());
    }

    @Override
    public boolean doHasViewAccess(DocumentCustomField documentCustomField) {
        return this.documentServiceSecurity.hasViewAccess(documentCustomField.getDocument());
    }

    public List<CustomFieldVO> list(DocumentVO documentVO) {
        Document document = (Document)this.conversionHandler.convert(Document.class, (Object)documentVO);
        this.documentServiceSecurity.checkViewAccess(document);
        return this.documentCustomFieldService.list(documentVO);
    }

    @Override
    protected void checkCreateNew(Long l) {
        Document document = this.find(Document.class, l);
        this.documentServiceSecurity.checkManageAccess(document);
    }

    protected DocumentCustomFieldServiceLocal getImplementation() {
        return this.documentCustomFieldService;
    }
}

