/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.contentmanagement;

import java.util.List;
import org.cyclos.entities.contentmanagement.MenuEntry;
import org.cyclos.entities.contentmanagement.MenuItem;
import org.cyclos.entities.system.Configuration;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.MenuEntryServiceLocal;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.contentmanagement.contentitems.ContentItemVisibility;
import org.cyclos.model.contentmanagement.contentitems.MenuEntriesListData;
import org.cyclos.model.contentmanagement.contentitems.MenuEntryDTO;
import org.cyclos.model.contentmanagement.contentitems.MenuEntryData;
import org.cyclos.model.contentmanagement.contentitems.MenuEntryDataParams;
import org.cyclos.model.contentmanagement.contentitems.MenuEntryVO;
import org.cyclos.model.contentmanagement.contentitems.MenuItemDetailedVO;
import org.cyclos.model.contentmanagement.contentitems.MenuItemVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.system.ConfigurationServiceSecurity;
import org.cyclos.services.contentmanagement.MenuEntryService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class MenuEntryServiceSecurity
extends CRUDServiceSecurity<MenuEntryDTO, MenuEntry, MenuEntryData, MenuEntryDataParams>
implements MenuEntryService {
    @Autowired
    private MenuEntryServiceLocal menuEntryService;
    @Autowired
    private ConfigurationServiceSecurity configurationServiceSecurity;

    public MenuEntryServiceSecurity() {
        super(MenuEntry.class);
    }

    @Override
    public boolean doHasManageAccess(MenuEntry menuEntry) {
        return this.configurationServiceSecurity.hasManageContent(menuEntry.getConfiguration());
    }

    @Override
    public boolean doHasViewAccess(MenuEntry menuEntry) {
        return this.configurationServiceSecurity.isVisibleForManageContent(menuEntry.getConfiguration());
    }

    public MenuEntriesListData getListData(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkViewAccess(configuration);
        MenuEntriesListData menuEntriesListData = this.menuEntryService.getListData(configurationVO);
        menuEntriesListData.setEditable(this.configurationServiceSecurity.hasManageContent(configuration));
        return menuEntriesListData;
    }

    public MenuItemDetailedVO getMenuItemDetails(MenuItemVO menuItemVO) throws FrameworkException {
        MenuItem menuItem = (MenuItem)this.conversionHandler.convert(MenuItem.class, (Object)menuItemVO);
        ContentItemVisibility contentItemVisibility = menuItem.getVisibility();
        if (!contentItemVisibility.isVisible(this.isLoggedIn())) {
            throw new PermissionDeniedException();
        }
        return this.menuEntryService.getMenuItemDetails(menuItemVO);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, MenuEntry menuEntry) {
        List list = this.configurationHandler.getAncestors(sessionData.getConfiguration().getConfiguration());
        if (list.contains(menuEntry.getConfiguration())) {
            return menuEntry.getVisibility().isVisible(this.isLoggedIn());
        }
        return false;
    }

    public List<MenuEntryVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkViewAccess(configuration);
        return this.menuEntryService.list(configurationVO);
    }

    public void move(Long l, boolean bl) throws EntityNotFoundException {
        MenuEntry menuEntry = (MenuEntry)this.find(l);
        this.checkManageAccess(menuEntry);
        this.menuEntryService.move(l, bl);
    }

    @Override
    protected void checkCreateNew(MenuEntryDataParams menuEntryDataParams) {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)menuEntryDataParams.getConfiguration());
        this.configurationServiceSecurity.checkManageContent(configuration);
    }

    protected MenuEntryServiceLocal getImplementation() {
        return this.menuEntryService;
    }
}

