/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.contentmanagement;

import java.util.List;
import org.cyclos.entities.contentmanagement.MobilePage;
import org.cyclos.entities.system.Configuration;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.MobilePageServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageDTO;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageData;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageVO;
import org.cyclos.model.contentmanagement.mobilepages.MobilePagesListData;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.system.ConfigurationServiceSecurity;
import org.cyclos.services.contentmanagement.MobilePageService;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class MobilePageServiceSecurity
extends CRUDServiceSecurity<MobilePageDTO, MobilePage, MobilePageData, ConfigurationVO>
implements MobilePageService {
    @Autowired
    private MobilePageServiceLocal mobilePageService;
    @Autowired
    private ConfigurationServiceSecurity configurationServiceSecurity;

    public MobilePageServiceSecurity() {
        super(MobilePage.class);
    }

    @Override
    public boolean doHasViewAccess(MobilePage mobilePage) {
        return this.configurationServiceSecurity.hasViewAccess(mobilePage.getConfiguration());
    }

    public String getContent(MobilePageVO mobilePageVO) throws FrameworkException {
        return this.mobilePageService.getContent(mobilePageVO);
    }

    public MobilePagesListData getListData(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkViewAccess(configuration);
        MobilePagesListData mobilePagesListData = this.mobilePageService.getListData(configurationVO);
        mobilePagesListData.setEditable(this.configurationServiceSecurity.hasManageContent(configuration));
        return mobilePagesListData;
    }

    @Override
    public boolean isAccessible(SessionData sessionData, MobilePage mobilePage) {
        return this.configurationServiceSecurity.isAccessible(sessionData, mobilePage.getConfiguration());
    }

    public List<MobilePageVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkViewAccess(configuration);
        return this.mobilePageService.list(configurationVO);
    }

    public void saveOrder(List<Long> list) throws FrameworkException {
        if (CollectionHelper.isEmpty(list)) {
            return;
        }
        Long l = null;
        for (Long l2 : list) {
            MobilePage mobilePage = (MobilePage)this.find(l2);
            if (l != null && !l.equals(mobilePage.getConfiguration().getId())) {
                throw new ValidationException();
            }
            if (l == null) {
                l = mobilePage.getConfiguration().getId();
            }
            this.checkManageAccess(mobilePage);
        }
        this.mobilePageService.saveOrder(list);
    }

    @Override
    protected void checkCreateNew(ConfigurationVO configurationVO) {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkManageContent(configuration);
    }

    @Override
    protected boolean doHasManageAccess(MobilePage mobilePage) {
        return this.configurationServiceSecurity.hasManageContent(mobilePage.getConfiguration());
    }

    protected MobilePageServiceLocal getImplementation() {
        return this.mobilePageService;
    }
}

