/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.contentmanagement;

import org.cyclos.entities.contentmanagement.MenuItem;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.contentmanagement.SitemapServiceLocal;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.contentmanagement.contentitems.MenuItemType;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.marketplace.AdServiceSecurity;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapData;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapIndexData;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapItemContentVO;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapItemType;
import org.cyclos.services.contentmanagement.SitemapService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class SitemapServiceSecurity
extends BaseServiceSecurity
implements SitemapService {
    @Autowired
    private SitemapServiceLocal sitemapService;
    @Autowired
    private AdServiceSecurity adServiceSecurity;

    public SitemapItemContentVO getContent(SitemapItemType sitemapItemType, Long l) throws FrameworkException {
        this.checkGuest();
        switch (sitemapItemType) {
            case MENU_ITEM: {
                MenuItem menuItem = this.find(MenuItem.class, l);
                if (menuItem.getVisibility().isVisible(false) && menuItem.getType() == MenuItemType.CONTENT) break;
                throw new EntityNotFoundException(MenuItem.class, l);
            }
            case AD: {
                BasicAd basicAd = this.find(BasicAd.class, l);
                if (this.adServiceSecurity.hasViewAccess(basicAd)) break;
                throw new EntityNotFoundException(BasicAd.class, l);
            }
        }
        return this.sitemapService.getContent(sitemapItemType, l);
    }

    public SitemapIndexData getIndexData() throws FrameworkException {
        this.checkGuest();
        return this.sitemapService.getIndexData();
    }

    public String getLastModifiedInMillis() {
        this.checkGuest();
        return this.sitemapService.getLastModifiedInMillis();
    }

    public SitemapData getSitemapData() {
        this.checkGuest();
        return this.sitemapService.getSitemapData();
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

