/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.contentmanagement;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.contentmanagement.BaseStaticContent;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.StaticContentServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Role;
import org.cyclos.model.contentmanagement.staticcontents.BaseStaticContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.PreviewParams;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentData;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentDataParams;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentListData;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.system.ConfigurationServiceSecurity;
import org.cyclos.services.contentmanagement.StaticContentService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class StaticContentServiceSecurity
extends CRUDServiceSecurity<BaseStaticContentDTO, BaseStaticContent, StaticContentData, StaticContentDataParams>
implements StaticContentService {
    @Autowired
    private StaticContentServiceLocal staticContentService;
    @Autowired
    private ConfigurationServiceSecurity configurationServiceSecurity;

    public StaticContentServiceSecurity() {
        super(BaseStaticContent.class);
    }

    @Override
    public boolean doHasViewAccess(BaseStaticContent baseStaticContent) {
        return this.configurationServiceSecurity.hasViewAccess(baseStaticContent.getConfiguration());
    }

    public String getHelpContent(Role role) {
        return this.staticContentService.getHelpContent(role);
    }

    public StaticContentListData getListData(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkViewAccess(configuration);
        return this.staticContentService.getListData(configurationVO);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, BaseStaticContent baseStaticContent) {
        return false;
    }

    public List<StaticContentVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkViewAccess(configuration);
        return this.staticContentService.list(configurationVO);
    }

    public String preview(@NotNull PreviewParams previewParams) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)previewParams.getConfiguration());
        this.configurationServiceSecurity.checkViewAccess(configuration);
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)previewParams.getUser());
        if (basicUser != null) {
            this.checkManagesUser(basicUser);
        }
        return this.staticContentService.preview(previewParams);
    }

    @Override
    protected void checkCreateNew(StaticContentDataParams staticContentDataParams) {
    }

    @Override
    protected void customizeData(StaticContentData staticContentData) {
        boolean bl = this.configurationServiceSecurity.hasManageContent(this.find(Configuration.class, ((BaseStaticContentDTO)staticContentData.getDto()).getConfiguration().getId()));
        staticContentData.setEditable(bl);
    }

    @Override
    protected boolean doHasManageAccess(BaseStaticContent baseStaticContent) {
        return this.configurationServiceSecurity.hasManageContent(baseStaticContent.getConfiguration());
    }

    protected StaticContentServiceLocal getImplementation() {
        return this.staticContentService;
    }
}

