/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.contentmanagement;

import javax.validation.constraints.NotNull;
import org.cyclos.entities.contentmanagement.SystemCustomImage;
import org.cyclos.entities.contentmanagement.SystemImageCategory;
import org.cyclos.impl.contentmanagement.SystemCustomImageServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.contentmanagement.imagecategories.SystemImageCategoryVO;
import org.cyclos.model.system.images.AccessibleSystemImageCategoriesData;
import org.cyclos.model.system.images.FullSystemImagesListData;
import org.cyclos.model.system.images.SystemCustomImageDTO;
import org.cyclos.model.system.images.SystemCustomImageQuery;
import org.cyclos.model.system.images.SystemCustomImageVO;
import org.cyclos.model.system.images.SystemCustomImagesSearchData;
import org.cyclos.security.Security;
import org.cyclos.security.system.BaseCustomImageServiceSecurity;
import org.cyclos.services.contentmanagement.SystemCustomImageService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class SystemCustomImageServiceSecurity
extends BaseCustomImageServiceSecurity<SystemCustomImage, SystemImageCategory, SystemImageCategoryVO>
implements SystemCustomImageService {
    @Autowired
    private SystemCustomImageServiceLocal systemCustomImageService;

    public SystemCustomImageServiceSecurity() {
        super(SystemCustomImage.class, SystemImageCategory.class);
    }

    public AccessibleSystemImageCategoriesData getAccessibleImageCategories() throws FrameworkException {
        this.checkPermission(Permission.SYSTEM_CUSTOM_IMAGES_VIEW);
        return this.systemCustomImageService.getAccessibleImageCategories();
    }

    public FullSystemImagesListData getFullListData() throws FrameworkException {
        if (!this.isAdmin()) {
            throw new PermissionDeniedException();
        }
        return this.systemCustomImageService.getFullListData();
    }

    public SystemCustomImageServiceLocal getImplementation() {
        return this.systemCustomImageService;
    }

    public SystemCustomImagesSearchData getSearchData() throws FrameworkException {
        this.checkPermission(Permission.SYSTEM_CUSTOM_IMAGES_VIEW);
        return this.systemCustomImageService.getSearchData();
    }

    public void saveCategory(@NotNull Long l, SystemImageCategoryVO systemImageCategoryVO) throws FrameworkException {
        SystemImageCategory systemImageCategory = (SystemImageCategory)this.toCategory(systemImageCategoryVO);
        this.checkManageImagesOf(systemImageCategory);
        this.systemCustomImageService.saveCategory(l, systemImageCategoryVO);
    }

    public Long saveDetails(@NotNull SystemCustomImageDTO systemCustomImageDTO) throws FrameworkException {
        SystemImageCategory systemImageCategory = (SystemImageCategory)this.toCategory(systemCustomImageDTO.getCategory());
        this.checkManageImagesOf(systemImageCategory);
        return this.systemCustomImageService.saveDetails(systemCustomImageDTO);
    }

    public Page<SystemCustomImageVO> search(SystemCustomImageQuery systemCustomImageQuery) throws FrameworkException {
        this.checkPermission(Permission.SYSTEM_CUSTOM_IMAGES_VIEW);
        return this.systemCustomImageService.search(systemCustomImageQuery);
    }

    @Override
    protected boolean canListImagesOf(SystemImageCategory systemImageCategory) {
        return this.getProducts().admin().getSystemImageCategoriesView().contains(systemImageCategory);
    }

    @Override
    protected boolean canManageImagesOf(SystemImageCategory systemImageCategory) {
        return this.getProducts().admin().getSystemImageCategoriesManage().contains(systemImageCategory);
    }
}

