/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.marketplace;

import java.util.List;
import org.cyclos.entities.marketplace.AdQuestion;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.marketplace.AdQuestionServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.marketplace.advertisements.AdQuestionQuery;
import org.cyclos.model.marketplace.advertisements.AdQuestionVO;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.marketplace.AdServiceSecurity;
import org.cyclos.services.marketplace.AdQuestionService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class AdQuestionServiceSecurity
extends BaseServiceSecurity
implements AdQuestionService {
    @Autowired
    private AdQuestionServiceLocal adQuestionService;
    @Autowired
    private AdServiceSecurity adServiceSecurity;

    public void answer(Long l, String string) throws FrameworkException, IllegalActionException {
        AdQuestion adQuestion = this.find(AdQuestion.class, l);
        BasicAd basicAd = adQuestion.getAd();
        this.checkAnswer(basicAd);
        if (!this.adServiceSecurity.hasManageAccess(basicAd.getType(), basicAd.getOwner())) {
            throw new PermissionDeniedException();
        }
        this.adQuestionService.answer(l, string);
    }

    public Long ask(BasicAdVO basicAdVO, String string) throws FrameworkException {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        this.checkAsk(basicAd);
        this.adServiceSecurity.checkViewAccess(basicAd);
        return this.adQuestionService.ask(basicAdVO, string);
    }

    public boolean canManageQuestionsAsBuyer(AdType adType) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isGuest() || sessionData.isRestrictedOperator()) {
            return false;
        }
        if (adType == AdType.WEB_SHOP) {
            return this.hasPermission(Permission.USER_WEB_SHOP_PURCHASE);
        }
        return true;
    }

    public List<AdQuestionVO> list(BasicAdVO basicAdVO) {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        this.checkQuestionsEnabled(basicAd.getType(), basicAd.getOwner());
        this.adServiceSecurity.checkViewAccess(basicAd);
        return this.adQuestionService.list(basicAdVO);
    }

    public AdQuestionVO load(Long l) throws FrameworkException {
        AdQuestion adQuestion = this.find(AdQuestion.class, l);
        BasicAd basicAd = adQuestion.getAd();
        this.checkQuestionsEnabled(basicAd.getType(), basicAd.getOwner());
        return this.adQuestionService.load(l);
    }

    public void remove(Long l) throws FrameworkException {
        AdQuestion adQuestion = this.find(AdQuestion.class, l);
        BasicAd basicAd = adQuestion.getAd();
        this.checkRemove(basicAd, adQuestion);
        this.adQuestionService.remove(l);
    }

    public Page<AdQuestionVO> search(AdQuestionQuery adQuestionQuery) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)adQuestionQuery.getSeller());
        if (user == null) {
            user = this.getLoggedUser();
            adQuestionQuery.setSeller(new UserVO(user.getId()));
        }
        if (adQuestionQuery.getType() == null) {
            if (this.adQuestionService.isQuestionsEnabled(AdType.ADVERTISEMENT, user)) {
                adQuestionQuery.setType(AdType.ADVERTISEMENT);
            } else if (this.adQuestionService.isQuestionsEnabled(AdType.WEB_SHOP, user)) {
                adQuestionQuery.setType(AdType.WEB_SHOP);
            } else {
                throw new ValidationException();
            }
        }
        this.checkQuestionsEnabled(adQuestionQuery.getType(), user);
        if (!this.adServiceSecurity.hasManageAccess(adQuestionQuery.getType(), user)) {
            throw new PermissionDeniedException();
        }
        return this.adQuestionService.search(adQuestionQuery);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<AdQuestion>(AdQuestion.class){

            public boolean isVisible(SessionData sessionData, AdQuestion adQuestion) {
                return AdQuestionServiceSecurity.this.adServiceSecurity.hasViewAccess(adQuestion.getAd());
            }
        };
    }

    private void checkAnswer(BasicAd basicAd) {
        this.doCheckAskAndAnswer(basicAd, false);
    }

    private void checkAsk(BasicAd basicAd) {
        if (!this.canManageQuestionsAsBuyer(basicAd.getType())) {
            throw new PermissionDeniedException();
        }
        this.doCheckAskAndAnswer(basicAd, true);
    }

    private void checkQuestionsEnabled(AdType adType, User user) {
        if (!this.adQuestionService.isQuestionsEnabled(adType, user)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkRemove(BasicAd basicAd, AdQuestion adQuestion) {
        this.checkQuestionsEnabled(basicAd.getType(), basicAd.getOwner());
        if (this.getLoggedUser().equals((Object)adQuestion.getOwner())) {
            if (!this.canManageQuestionsAsBuyer(basicAd.getType())) {
                throw new PermissionDeniedException();
            }
            this.adServiceSecurity.checkViewAccess(basicAd);
        } else {
            this.adServiceSecurity.hasManageAccess(basicAd.getType(), basicAd.getOwner());
        }
    }

    private void doCheckAskAndAnswer(BasicAd basicAd, boolean bl) {
        this.checkQuestionsEnabled(basicAd.getType(), basicAd.getOwner());
        if (basicAd.getOwner().equals((Object)this.getLoggedUser()) == bl) {
            throw new PermissionDeniedException();
        }
    }
}

