/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.marketplace;

import java.math.BigDecimal;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.marketplace.AdDeliveryMethod;
import org.cyclos.entities.marketplace.AdWebShop;
import org.cyclos.entities.marketplace.Order;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.marketplace.OrderServiceLocal;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.marketplace.OutOfStockException;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.marketplace.webshoporders.AcceptOrderParams;
import org.cyclos.model.marketplace.webshoporders.OrderDTO;
import org.cyclos.model.marketplace.webshoporders.OrderData;
import org.cyclos.model.marketplace.webshoporders.OrderDataParams;
import org.cyclos.model.marketplace.webshoporders.OrderQuery;
import org.cyclos.model.marketplace.webshoporders.OrderSearchData;
import org.cyclos.model.marketplace.webshoporders.OrderStatus;
import org.cyclos.model.marketplace.webshoporders.OrderVO;
import org.cyclos.model.marketplace.webshoporders.RejectOrderParams;
import org.cyclos.model.marketplace.webshoporders.SetDeliveryMethodParams;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutParams;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutResult;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartDTO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.marketplace.OrderService;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class OrderServiceSecurity
extends CRUDServiceSecurity<OrderDTO, Order, OrderData, OrderDataParams>
implements OrderService {
    @Autowired
    private OrderServiceLocal orderService;

    public OrderServiceSecurity() {
        super(Order.class);
    }

    public OrderStatus accept(AcceptOrderParams acceptOrderParams) throws FrameworkException, TransferException, PasswordException {
        Order order = (Order)this.conversionHandler.convert(Order.class, (Object)acceptOrderParams.getOrder());
        if (order.isPendingByAdmin()) {
            this.checkActionByAdmin(order);
        } else if (order.getStatus() == OrderStatus.PENDING_BUYER) {
            this.checkBuyerPermission(order, true);
        } else {
            this.checkSellerPermission(order, true);
        }
        return this.orderService.accept(acceptOrderParams);
    }

    public int addToCart(BasicAdVO basicAdVO, BigDecimal bigDecimal) throws FrameworkException, OutOfStockException {
        this.checkPermission(Permission.USER_WEB_SHOP_PURCHASE);
        this.conversionHandler.convert(AdWebShop.class, (Object)basicAdVO);
        return this.orderService.addToCart(basicAdVO, bigDecimal);
    }

    public ShoppingCartDTO adjustAndGetMyCart() throws FrameworkException {
        if (this.hasPermission(Permission.USER_WEB_SHOP_PURCHASE)) {
            return this.orderService.adjustAndGetMyCart();
        }
        return null;
    }

    public OrderData adjustShoppingCartAndGetData(OrderVO orderVO) throws FrameworkException {
        this.checkPermission(Permission.USER_WEB_SHOP_PURCHASE);
        return this.orderService.adjustShoppingCartAndGetData(orderVO);
    }

    public void checkCartStock(UserLocatorVO userLocatorVO, CurrencyVO currencyVO) throws FrameworkException, OutOfStockException {
        this.checkPermission(Permission.USER_WEB_SHOP_PURCHASE);
        this.checkVO(User.class, (EntityVO)userLocatorVO);
        this.checkVO(Currency.class, (EntityVO)currencyVO);
        this.orderService.checkCartStock(userLocatorVO, currencyVO);
    }

    public ShoppingCartCheckoutResult checkout(ShoppingCartCheckoutParams shoppingCartCheckoutParams) throws FrameworkException, EntityNotFoundException, OutOfStockException, TransferException, PasswordException {
        this.checkPermission(Permission.USER_WEB_SHOP_PURCHASE);
        this.conversionHandler.convert(Order.class, (Object)shoppingCartCheckoutParams.getOrder());
        this.checkVO(AdDeliveryMethod.class, (EntityVO)shoppingCartCheckoutParams.getDeliveryMethod());
        this.checkVO(PaymentTransferType.class, (EntityVO)shoppingCartCheckoutParams.getPaymentType());
        return this.orderService.checkout(shoppingCartCheckoutParams);
    }

    public int countCartItems() throws FrameworkException {
        if (this.hasPermission(Permission.USER_WEB_SHOP_PURCHASE)) {
            return this.orderService.countCartItems();
        }
        return 0;
    }

    @Override
    public boolean doHasManageAccess(Order order) {
        OrderStatus orderStatus = (OrderStatus)ObjectHelper.defaultValue((Object)order.getStatus(), (Object)OrderStatus.DRAFT);
        return (orderStatus == OrderStatus.DRAFT || orderStatus == OrderStatus.SHOPPING_CART) && this.hasViewAccess(order);
    }

    @Override
    public boolean doHasViewAccess(Order order) {
        boolean bl = this.hasBuyerPermission(order, false);
        boolean bl2 = this.hasSellerPermission(order, false);
        OrderStatus orderStatus = (OrderStatus)ObjectHelper.defaultValue((Object)order.getStatus(), (Object)OrderStatus.DRAFT);
        switch (orderStatus) {
            case DRAFT: {
                return bl2 && order.getSeller().equals((Object)this.getLoggedUser());
            }
            case SHOPPING_CART: {
                return bl && order.getBuyer().equals((Object)this.getLoggedUser());
            }
        }
        return bl || bl2;
    }

    public FileInfo exportOrder(ExportFormatVO exportFormatVO, OrderVO orderVO) throws FrameworkException {
        Order order = (Order)this.conversionHandler.convert(Order.class, (Object)orderVO);
        this.checkViewAccess(order);
        return this.orderService.exportOrder(exportFormatVO, orderVO);
    }

    public OrderData getCheckoutData(UserLocatorVO userLocatorVO, CurrencyVO currencyVO) {
        this.checkPermission(Permission.USER_WEB_SHOP_PURCHASE);
        this.checkVO(User.class, (EntityVO)userLocatorVO);
        this.checkVO(Currency.class, (EntityVO)currencyVO);
        return this.orderService.getCheckoutData(userLocatorVO, currencyVO);
    }

    public ShoppingCartDTO getMyCart() {
        if (this.hasPermission(Permission.USER_WEB_SHOP_PURCHASE)) {
            return this.orderService.getMyCart();
        }
        return null;
    }

    public OrderData getOrderData(OrderVO orderVO) throws FrameworkException {
        return (OrderData)this.getData(this.getOrderId(orderVO));
    }

    public long getOrderId(OrderVO orderVO) throws FrameworkException {
        return this.orderService.getOrderId(orderVO);
    }

    public OrderSearchData getSearchData(@NotNull UserLocatorVO userLocatorVO, boolean bl) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        this.checkAccess(bl ? null : user, (User)(bl ? user : null));
        return this.orderService.getSearchData(userLocatorVO, bl);
    }

    public boolean hasBuyerPermission(Order order, boolean bl) {
        return this.hasPermission(order.getBuyer(), true, bl);
    }

    public boolean hasSellerPermission(Order order, boolean bl) {
        return this.hasPermission(order.getSeller(), false, bl);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, Order order) {
        return false;
    }

    public int modifyQuantityOnCart(BasicAdVO basicAdVO, BigDecimal bigDecimal) throws FrameworkException, IllegalActionException, OutOfStockException {
        this.checkPermission(Permission.USER_WEB_SHOP_PURCHASE);
        this.conversionHandler.convert(AdWebShop.class, (Object)basicAdVO);
        return this.orderService.modifyQuantityOnCart(basicAdVO, bigDecimal);
    }

    public void reject(RejectOrderParams rejectOrderParams) throws FrameworkException {
        Order order = (Order)this.conversionHandler.convert(Order.class, (Object)rejectOrderParams.getOrder());
        if (order.isPendingByAdmin()) {
            this.checkActionByAdmin(order);
        } else {
            switch (order.getStatus()) {
                case PENDING_BUYER: {
                    if (this.hasSellerPermission(order, true) || this.hasBuyerPermission(order, true)) break;
                    throw new PermissionDeniedException();
                }
                case PENDING_SELLER: {
                    this.checkSellerPermission(order, true);
                    break;
                }
                default: {
                    throw new IllegalActionException();
                }
            }
        }
        this.orderService.reject(rejectOrderParams);
    }

    public int removeCart(UserLocatorVO userLocatorVO, CurrencyVO currencyVO) {
        this.checkPermission(Permission.USER_WEB_SHOP_PURCHASE);
        this.checkVO(User.class, (EntityVO)userLocatorVO);
        this.checkVO(Currency.class, (EntityVO)currencyVO);
        return this.orderService.removeCart(userLocatorVO, currencyVO);
    }

    public int removeCartById(Long l) throws FrameworkException {
        this.checkOperation((Order)this.find(l), CRUDOperation.DELETE);
        return this.orderService.removeCartById(l);
    }

    public int removeCartItem(BasicAdVO basicAdVO) throws FrameworkException {
        this.checkPermission(Permission.USER_WEB_SHOP_PURCHASE);
        return this.orderService.removeCartItem(basicAdVO);
    }

    public Page<OrderVO> search(OrderQuery orderQuery) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)orderQuery.getBuyer());
        User user2 = (User)this.conversionHandler.convert(User.class, (Object)orderQuery.getSeller());
        this.checkAccess(user, user2);
        return this.orderService.search(orderQuery);
    }

    public void setDeliveryMethod(SetDeliveryMethodParams setDeliveryMethodParams) throws FrameworkException {
        Order order = (Order)this.conversionHandler.convert(Order.class, (Object)setDeliveryMethodParams.getOrder());
        this.checkSellerPermission(order, true);
        this.orderService.setDeliveryMethod(setDeliveryMethodParams);
    }

    public Long submitToBuyer(OrderDTO orderDTO) throws FrameworkException, OutOfStockException {
        this.checkManage(orderDTO);
        return this.orderService.submitToBuyer(orderDTO);
    }

    @Override
    protected void checkCreateNew(OrderDataParams orderDataParams) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)orderDataParams.getBuyer());
        User user2 = (User)this.conversionHandler.convert(User.class, (Object)orderDataParams.getSeller());
        this.checkAccess(user, user2);
        this.checkVO(Currency.class, (EntityVO)orderDataParams.getCurrency());
    }

    @Override
    protected void customizeData(OrderData orderData) {
        OrderDTO orderDTO = (OrderDTO)orderData.getDto();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        OrderStatus orderStatus = orderDTO.getStatus();
        if (!this.isProcessFinished(orderStatus)) {
            User user = orderDTO.getBuyer().getId() == null ? null : this.find(User.class, orderDTO.getBuyer().getId());
            User user2 = orderDTO.getSeller().getId() == null ? null : this.find(User.class, orderDTO.getSeller().getId());
            OrderWrapper orderWrapper = new OrderWrapper(user, user2);
            if (user != null && user2 != null) {
                if (orderDTO.isPendingByAdmin()) {
                    SessionData sessionData = this.getSessionData();
                    bl2 = bl = orderDTO.isSale() && sessionData.isAdminOf((BasicUser)user2) || !orderDTO.isSale() && sessionData.isAdminOf((BasicUser)user);
                } else if (orderStatus == OrderStatus.SHOPPING_CART) {
                    boolean bl6;
                    bl3 = bl6 = this.hasBuyerPermission(orderWrapper, true);
                    bl4 = bl6;
                } else if (orderStatus == OrderStatus.PENDING_BUYER) {
                    boolean bl7;
                    bl = bl7 = this.hasBuyerPermission(orderWrapper, true);
                    bl2 = bl7 || this.hasSellerPermission(orderWrapper, true);
                } else if (Set.of(OrderStatus.PENDING_SELLER, OrderStatus.DRAFT).contains(orderStatus)) {
                    boolean bl8;
                    bl = bl8 = this.hasSellerPermission(orderWrapper, true);
                    bl2 = bl8;
                    bl3 = bl8;
                    bl4 = bl8;
                    bl5 = bl8;
                }
            }
        }
        orderData.setCanAccept(orderData.isCanAccept() && bl);
        orderData.setCanReject(orderData.isCanReject() && bl2);
        orderData.setCanSetDeliveryAddress(orderData.isCanSetDeliveryAddress() && bl3);
        orderData.setCanSetDeliveryMethod(orderData.isCanSetDeliveryMethod() && bl4);
        orderData.setCanSetDeliveryPrice(orderData.isCanSetDeliveryPrice() && bl5);
    }

    protected OrderServiceLocal getImplementation() {
        return this.orderService;
    }

    private void checkAccess(User user, User user2) {
        boolean bl = false;
        OrderWrapper orderWrapper = new OrderWrapper(user, user2);
        if (user != null) {
            bl = this.hasBuyerPermission(orderWrapper, false);
        }
        if (user2 != null && !bl) {
            bl = this.hasSellerPermission(orderWrapper, false);
        }
        if (!(bl || user == null && user2 == null)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkActionByAdmin(Order order) {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isAdminOf((BasicUser)(order.isSale() ? order.getSeller() : order.getBuyer()))) {
            throw new PermissionDeniedException();
        }
    }

    private void checkBuyerPermission(Order order, boolean bl) {
        this.checkPermission(order.getBuyer(), true, bl);
    }

    private void checkManage(OrderDTO orderDTO) {
        if (orderDTO.isTransient()) {
            User user = (User)this.conversionHandler.convert(User.class, (Object)orderDTO.getBuyer());
            User user2 = (User)this.conversionHandler.convert(User.class, (Object)orderDTO.getSeller());
            this.checkAccess(user, user2);
        } else {
            Order order = (Order)this.find(orderDTO.getId());
            this.checkManageAccess(order);
        }
    }

    private void checkPermission(User user, boolean bl, boolean bl2) {
        if (!this.hasPermission(user, bl, bl2)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkSellerPermission(Order order, boolean bl) {
        this.checkPermission(order.getSeller(), false, bl);
    }

    private boolean hasBuyerPermission(OrderWrapper orderWrapper, boolean bl) {
        return this.hasPermission(orderWrapper.getBuyer(), true, bl);
    }

    private boolean hasPermission(User user, boolean bl, boolean bl2) {
        if (bl) {
            return this.permission((BasicUser)user).my(new Permission[]{Permission.USER_WEB_SHOP_PURCHASE}).user(new Permission[]{bl2 ? Permission.USER_WEB_SHOP_PURCHASES_MANAGE : Permission.USER_WEB_SHOP_PURCHASES_VIEW}).granted();
        }
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_WEB_SHOP_ENABLE}).user(new Permission[]{bl2 ? Permission.USER_WEB_SHOP_SALES_MANAGE : Permission.USER_WEB_SHOP_SALES_VIEW}).granted();
    }

    private boolean hasSellerPermission(OrderWrapper orderWrapper, boolean bl) {
        return this.hasPermission(orderWrapper.getSeller(), false, bl);
    }

    private boolean isProcessFinished(OrderStatus orderStatus) {
        return orderStatus == OrderStatus.DISPOSED || orderStatus == OrderStatus.COMPLETED || orderStatus == OrderStatus.REJECTED_BY_BUYER || orderStatus == OrderStatus.REJECTED_BY_SELLER;
    }

    private class OrderWrapper {
        User seller;
        User buyer;

        public OrderWrapper(User user, User user2) {
            this.buyer = user;
            this.seller = user2;
        }

        User getBuyer() {
            return this.buyer;
        }

        User getSeller() {
            return this.seller;
        }
    }
}

