/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.messaging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.messaging.IncomingMessage;
import org.cyclos.entities.messaging.Message;
import org.cyclos.entities.messaging.MessageCategory;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.messaging.MessageServiceLocal;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.messaging.messagecategories.MessageCategoryVO;
import org.cyclos.model.messaging.messages.MessageData;
import org.cyclos.model.messaging.messages.MessageDestination;
import org.cyclos.model.messaging.messages.MessageOwner;
import org.cyclos.model.messaging.messages.MessageQuery;
import org.cyclos.model.messaging.messages.MessageSearchData;
import org.cyclos.model.messaging.messages.MessageVO;
import org.cyclos.model.messaging.messages.MessagesStatusVO;
import org.cyclos.model.messaging.messages.SendMessageDTO;
import org.cyclos.model.messaging.messages.SendMessageData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.messaging.MessageService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class MessageServiceSecurity
extends BaseServiceSecurity
implements MessageService {
    @Autowired
    private MessageServiceLocal messageService;

    public boolean canSendMessage(MessageDestination messageDestination) {
        if (this.isAdmin() && this.groupsHandler.accessibles().users().isEmpty()) {
            return false;
        }
        if (messageDestination == null) {
            return !this.getAllowedDestinations().isEmpty();
        }
        return this.getAllowedDestinations().contains(messageDestination);
    }

    public boolean canSendMessageToUser(User user) {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isLoggedIn()) {
            return false;
        }
        if (sessionData.isAdmin() && user.isAdmin()) {
            return false;
        }
        ProductAccessor productAccessor = this.productsHandler.getAccessor((BasicUser)user).product();
        return this.getAllowedDestinations().contains(MessageDestination.USER) && sessionData.relatesTo((BasicUser)user) && productAccessor.hasPermission(Permission.MY_MESSAGES_VIEW);
    }

    public boolean canViewMessages() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(new Permission[]{Permission.MY_MESSAGES_VIEW, Permission.SYSTEM_MESSAGES_VIEW});
    }

    public int countNewMessages() throws FrameworkException {
        this.checkCanViewMessages();
        return this.messageService.countNewMessages();
    }

    public int countUnreadMessages() {
        this.checkCanViewMessages();
        return this.messageService.countUnreadMessages();
    }

    public List<MessageDestination> getAllowedDestinations() {
        ArrayList<MessageDestination> arrayList = new ArrayList<MessageDestination>();
        ProductsAccessor productsAccessor = this.getSessionData().getProducts();
        if (!this.canViewMessages()) {
            return Collections.emptyList();
        }
        if (this.hasPermission(Permission.MY_MESSAGES_SEND_TO_USER) || this.hasPermission(Permission.SYSTEM_MESSAGES_SEND_TO_USER)) {
            arrayList.add(MessageDestination.USER);
        }
        if ((this.hasPermission(Permission.MY_MESSAGES_SEND_TO_SYSTEM) || this.hasPermission(Permission.SYSTEM_MESSAGES_SEND_TO_USER)) && CollectionHelper.isNotEmpty((Iterable)productsAccessor.member().getSendMessagesToAdmin())) {
            arrayList.add(MessageDestination.SYSTEM);
        }
        if (this.hasPermission(Permission.SYSTEM_MESSAGES_SEND_TO_GROUPS) && this.hasPermission(Permission.SYSTEM_MESSAGES_SEND_TO_USER)) {
            arrayList.add(MessageDestination.GROUP);
        }
        if (this.hasPermission(Permission.MY_MESSAGES_SEND_TO_BROKERED_USERS)) {
            arrayList.add(MessageDestination.BROKERED);
            if (!arrayList.contains(MessageDestination.USER)) {
                arrayList.add(MessageDestination.USER);
            }
        }
        return arrayList;
    }

    public MessageData getData(Long l) throws FrameworkException {
        this.checkAccess(false, l);
        MessageData messageData = this.messageService.getData(l);
        boolean bl = this.hasAccess(true, l);
        messageData.setCanMoveToTrash(messageData.isCanMoveToTrash() && bl);
        messageData.setCanRestore(messageData.isCanRestore() && bl);
        messageData.setCanRemove(messageData.isCanRemove() && bl);
        boolean bl2 = messageData.isCanReply();
        if (bl2 && messageData.getMessage().getCategory() != null) {
            bl2 = this.getSessionData().isAdmin() || this.canSendToSystem(messageData.getMessage().getCategory());
        }
        messageData.setCanReply(bl2);
        return messageData;
    }

    public MessagesStatusVO getMessagesStatus() throws FrameworkException {
        this.checkCanViewMessages();
        return this.messageService.getMessagesStatus();
    }

    public MessageSearchData getSearchData() {
        this.checkCanViewMessages();
        MessageSearchData messageSearchData = this.messageService.getSearchData();
        messageSearchData.getSendDestinations().removeIf(messageDestination -> !this.canSend((MessageDestination)messageDestination, messageSearchData.getVisibleSendCategories(), null));
        return messageSearchData;
    }

    public SendMessageData getSendData(Long l, UserLocatorVO userLocatorVO) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        if (l == null) {
            this.checkSend(user);
        }
        return this.messageService.getSendData(l, userLocatorVO);
    }

    public void markAsRead(Set<Long> set, boolean bl) {
        this.checkAccess(false, set);
        this.messageService.markAsRead(set, bl);
    }

    public void moveToTrash(Set<Long> set) {
        this.checkAccess(true, set);
        this.messageService.moveToTrash(set);
    }

    public void removeAll(Set<Long> set) {
        this.checkAccess(true, set);
        this.messageService.removeAll(set);
    }

    public void restoreAll(Set<Long> set) {
        this.checkAccess(true, set);
        this.messageService.restoreAll(set);
    }

    public Page<MessageVO> search(MessageQuery messageQuery) {
        this.checkCanViewMessages();
        this.checkVO(MessageCategory.class, (EntityVO)messageQuery.getCategory());
        this.checkVO(User.class, (EntityVO)messageQuery.getUser());
        return this.messageService.search(messageQuery);
    }

    public long send(SendMessageDTO sendMessageDTO) {
        MessageDestination messageDestination;
        MessageCategoryVO messageCategoryVO = sendMessageDTO.getCategory();
        if (sendMessageDTO.getReplyToId() != null) {
            messageDestination = this.find(IncomingMessage.class, sendMessageDTO.getReplyToId());
            sendMessageDTO.setDestination(messageDestination.getFromOwner() == MessageOwner.USER ? MessageDestination.USER : MessageDestination.SYSTEM);
            messageCategoryVO = (MessageCategoryVO)this.conversionHandler.convert(MessageCategoryVO.class, (Object)messageDestination.getCategory());
        }
        if ((messageDestination = sendMessageDTO.getDestination()) == null) {
            throw new ValidationException();
        }
        if (sendMessageDTO.getReplyToId() == null && !this.canSendMessage(messageDestination)) {
            throw new PermissionDeniedException();
        }
        switch (messageDestination) {
            case SYSTEM: {
                sendMessageDTO.setToUsers(null);
                sendMessageDTO.setToGroups(null);
                break;
            }
            case GROUP: {
                this.checkIds(Group.class, EntityVO.ids((Iterable)sendMessageDTO.getToGroups()));
                sendMessageDTO.setToUsers(null);
                break;
            }
            case USER: {
                sendMessageDTO.setToGroups(null);
                if (sendMessageDTO.getReplyToId() != null) break;
                this.checkVOs(User.class, sendMessageDTO.getToUsers());
                break;
            }
            case BROKERED: {
                sendMessageDTO.setToUsers(null);
                sendMessageDTO.setToGroups(null);
            }
        }
        if (!this.canSend(messageDestination, messageCategoryVO, (Collection<UserVO>)sendMessageDTO.getToUsers())) {
            throw new PermissionDeniedException();
        }
        if (sendMessageDTO.getReplyToId() != null) {
            sendMessageDTO.setCategory(null);
        }
        return this.messageService.send(sendMessageDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<Message>(Message.class){

            public boolean isVisible(SessionData sessionData, Message message) {
                return MessageServiceSecurity.this.isAccessible(message);
            }
        };
    }

    private boolean canSend(MessageDestination messageDestination, List<MessageCategoryVO> list, Collection<UserVO> collection) {
        ProductsAccessor productsAccessor = this.getSessionData().getProducts();
        switch (messageDestination) {
            case SYSTEM: {
                return this.canSendToSystem(list);
            }
            case USER: {
                SessionData sessionData = this.getSessionData();
                return productsAccessor.admin().hasPermission(Permission.SYSTEM_MESSAGES_SEND_TO_USER) || productsAccessor.member().hasPermission(Permission.MY_MESSAGES_SEND_TO_USER) || productsAccessor.broker().hasPermission(Permission.MY_MESSAGES_SEND_TO_BROKERED_USERS) && !CollectionHelper.orEmpty(collection).stream().anyMatch(userVO -> !sessionData.isBrokerOf((BasicUser)this.conversionHandler.convert(User.class, userVO)));
            }
            case GROUP: {
                return productsAccessor.admin().hasPermission(Permission.SYSTEM_MESSAGES_SEND_TO_GROUPS);
            }
            case BROKERED: {
                return productsAccessor.broker().hasPermission(Permission.MY_MESSAGES_SEND_TO_BROKERED_USERS);
            }
        }
        return false;
    }

    private boolean canSend(MessageDestination messageDestination, MessageCategoryVO messageCategoryVO, Collection<UserVO> collection) {
        return this.canSend(messageDestination, Arrays.asList(messageCategoryVO), collection);
    }

    private boolean canSendToSystem(List<MessageCategoryVO> list) {
        List list2 = this.conversionHandler.convertList(MessageCategory.class, list);
        List list3 = this.getSessionData().getProducts().member().getSendMessagesToAdmin();
        return CollectionHelper.containsAny((Collection)list3, (Collection)list2);
    }

    private boolean canSendToSystem(MessageCategoryVO messageCategoryVO) {
        return this.canSendToSystem(Arrays.asList(messageCategoryVO));
    }

    private void checkAccess(boolean bl, Collection<Long> collection) {
        for (Long l : collection) {
            this.checkAccess(bl, l);
        }
    }

    private void checkAccess(boolean bl, Long l) {
        if (!this.hasAccess(bl, l)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkCanViewMessages() {
        if (!this.canViewMessages()) {
            throw new PermissionDeniedException();
        }
    }

    private void checkSend(User user) {
        boolean bl = this.canSendMessage(user == null ? null : MessageDestination.USER);
        if (!bl) {
            throw new PermissionDeniedException();
        }
    }

    private boolean hasAccess(boolean bl, Long l) {
        Message message = this.find(Message.class, l);
        User user = message.getOwner();
        boolean bl2 = user == null ? this.permission(bl ? Permission.SYSTEM_MESSAGES_MANAGE : Permission.SYSTEM_MESSAGES_VIEW).value((Object)message.getCategory()).granted() : this.permission((BasicUser)user).my(new Permission[]{Permission.MY_MESSAGES_VIEW}).granted();
        return bl2;
    }

    private boolean isAccessible(Message message) {
        User user = message.getOwner();
        if (user == null) {
            return this.permission(Permission.SYSTEM_MESSAGES_VIEW).value((Object)message.getCategory()).granted();
        }
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_MESSAGES_VIEW}).granted();
    }
}

