/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.messaging;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.messaging.Notification;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.messaging.NotificationServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.messaging.notifications.NotificationQuery;
import org.cyclos.model.messaging.notifications.NotificationVO;
import org.cyclos.model.messaging.notifications.NotificationsStatusVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.messaging.NotificationService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class NotificationServiceSecurity
extends BaseServiceSecurity
implements NotificationService {
    @Autowired
    private NotificationServiceLocal notificationService;

    public NotificationsStatusVO getNotificationsStatus() {
        this.checkPermission(Permission.MY_NOTIFICATIONS_ENABLE);
        return this.notificationService.getNotificationsStatus();
    }

    public NotificationVO load(@NotNull Long l) throws FrameworkException {
        this.checkPermission(Permission.MY_NOTIFICATIONS_ENABLE);
        return this.notificationService.load(l);
    }

    public void markAllRead() {
        this.checkPermission(Permission.MY_NOTIFICATIONS_ENABLE);
        this.notificationService.markAllRead();
    }

    public void markAsRead(List<Long> list) {
        this.findAll(list);
        this.notificationService.markAsRead(list);
    }

    public void remove(Long l) {
        this.find(l);
        this.notificationService.remove(l);
    }

    public void removeAll(Collection<Long> collection) {
        this.findAll(collection);
        this.notificationService.removeAll(collection);
    }

    public Page<NotificationVO> search(NotificationQuery notificationQuery) throws FrameworkException {
        this.checkPermission(Permission.MY_NOTIFICATIONS_ENABLE);
        return this.notificationService.search(notificationQuery);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<Notification>(Notification.class){

            public boolean isVisible(SessionData sessionData, Notification notification) {
                return sessionData.hasPermission(Permission.MY_NOTIFICATIONS_ENABLE) && notification.getUser().equals((Object)sessionData.getLoggedBasicUser());
            }
        };
    }

    private Notification find(Long l) {
        return this.find(Notification.class, l);
    }

    private List<Notification> findAll(Collection<Long> collection) {
        return CollectionHelper.orEmpty(collection).stream().map(this::find).collect(Collectors.toList());
    }
}

