/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldPossibleValue;
import org.cyclos.entities.system.CustomFieldPossibleValueCategory;
import org.cyclos.impl.system.BaseCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.system.fields.CustomFieldPossibleValueCategoryDTO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueCategoryData;
import org.cyclos.model.system.fields.CustomFieldPossibleValueCategoryVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.system.BaseCustomFieldServiceSecurity;
import org.cyclos.services.system.BaseCustomFieldPossibleValueCategoryService;
import org.cyclos.utils.CollectionHelper;

public abstract class BaseCustomFieldPossibleValueCategoryServiceSecurity<CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>>
extends ConfigurationEntityCRUDServiceSecurity<CustomFieldPossibleValueCategoryDTO, C, CustomFieldPossibleValueCategoryData, CustomFieldVO>
implements BaseCustomFieldPossibleValueCategoryService {
    public BaseCustomFieldPossibleValueCategoryServiceSecurity(Class<C> clazz) {
        super(clazz);
    }

    @Override
    public boolean doHasManageAccess(C c) {
        return this.getFieldSecurity().hasManageAccess(c.getField());
    }

    @Override
    public boolean doHasViewAccess(C c) {
        return this.getFieldSecurity().hasViewAccess(c.getField());
    }

    public final List<CustomFieldPossibleValueCategoryVO> list(CustomFieldVO customFieldVO) throws FrameworkException {
        CustomField customField = (CustomField)this.conversionHandler.convert(this.getImplementation().getCustomFieldClass(), (Object)customFieldVO);
        this.getFieldSecurity().checkViewAccess(customField);
        return this.getImplementation().list(customFieldVO);
    }

    public void move(Long l, boolean bl) throws EntityNotFoundException {
        CustomFieldPossibleValueCategory customFieldPossibleValueCategory = (CustomFieldPossibleValueCategory)this.find(l);
        this.checkManageAccess(customFieldPossibleValueCategory);
        this.getImplementation().move(l, bl);
    }

    public void saveCategories(List<CustomFieldPossibleValueCategoryDTO> list) throws FrameworkException {
        if (CollectionHelper.isNotEmpty(list)) {
            for (CustomFieldPossibleValueCategoryDTO customFieldPossibleValueCategoryDTO : list) {
                this.checkCreateNew(customFieldPossibleValueCategoryDTO.getField());
            }
        }
        this.getImplementation().saveCategories(list);
    }

    public final void saveOrder(List<Long> list) throws FrameworkException {
        for (Long l : list) {
            CustomFieldPossibleValueCategory customFieldPossibleValueCategory = (CustomFieldPossibleValueCategory)this.find(l);
            this.checkManageAccess(customFieldPossibleValueCategory);
        }
        this.getImplementation().saveOrder(list);
    }

    @Override
    protected final void checkCreateNew(CustomFieldVO customFieldVO) {
        CustomField customField = (CustomField)this.conversionHandler.convert(this.getCustomFieldServiceSecurity().getEntityClass(), (Object)customFieldVO);
        this.getFieldSecurity().checkManageAccess(customField);
    }

    protected abstract BaseCustomFieldServiceSecurity<?, CF, C, PV, ?, ?> getCustomFieldServiceSecurity();

    protected abstract BaseCustomFieldPossibleValueCategoryServiceLocal<CF, C, PV> getImplementation();

    private BaseCustomFieldServiceSecurity<?, CF, C, PV, ?, ?> getFieldSecurity() {
        return this.getCustomFieldServiceSecurity();
    }
}

