/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldPossibleValue;
import org.cyclos.entities.system.CustomFieldPossibleValueCategory;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.BaseCustomFieldPossibleValueServiceLocal;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.system.fields.CustomFieldPossibleValueCategoryVO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueDTO;
import org.cyclos.model.system.fields.CustomFieldPossibleValueData;
import org.cyclos.model.system.fields.CustomFieldPossibleValueDataParams;
import org.cyclos.model.system.fields.CustomFieldPossibleValueQuery;
import org.cyclos.model.system.fields.CustomFieldPossibleValueVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.system.BaseCustomFieldServiceSecurity;
import org.cyclos.services.system.BaseCustomFieldPossibleValueService;
import org.cyclos.utils.Page;

public abstract class BaseCustomFieldPossibleValueServiceSecurity<CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>>
extends CRUDServiceSecurity<CustomFieldPossibleValueDTO, PV, CustomFieldPossibleValueData, CustomFieldPossibleValueDataParams>
implements BaseCustomFieldPossibleValueService {
    public BaseCustomFieldPossibleValueServiceSecurity(Class<PV> clazz) {
        super(clazz);
    }

    @Override
    public boolean doHasManageAccess(PV PV) {
        return this.getFieldSecurity().hasManageAccess(PV.getField());
    }

    @Override
    public boolean doHasViewAccess(PV PV) {
        return this.getFieldSecurity().hasViewAccess(PV.getField());
    }

    public final void insert(CustomFieldVO customFieldVO, CustomFieldPossibleValueCategoryVO customFieldPossibleValueCategoryVO, List<String> list) throws FrameworkException {
        CustomFieldPossibleValueDataParams customFieldPossibleValueDataParams = new CustomFieldPossibleValueDataParams();
        customFieldPossibleValueDataParams.setCustomField(customFieldVO);
        customFieldPossibleValueDataParams.setCategory(customFieldPossibleValueCategoryVO);
        this.checkCreateNew(customFieldPossibleValueDataParams);
        this.getImplementation().insert(customFieldVO, customFieldPossibleValueCategoryVO, list);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, PV PV) {
        return this.getFieldSecurity().isAccessible(sessionData, PV.getField());
    }

    public void move(Long l, boolean bl) throws EntityNotFoundException {
        CustomFieldPossibleValue customFieldPossibleValue = (CustomFieldPossibleValue)this.find(l);
        this.checkManageAccess(customFieldPossibleValue);
        this.getImplementation().move(l, bl);
    }

    public final Page<CustomFieldPossibleValueVO> search(CustomFieldPossibleValueQuery customFieldPossibleValueQuery) throws FrameworkException {
        CustomField customField = (CustomField)this.conversionHandler.convert(this.getImplementation().getCustomFieldClass(), (Object)customFieldPossibleValueQuery.getField());
        this.getFieldSecurity().checkViewAccess(customField);
        return this.getImplementation().search(customFieldPossibleValueQuery);
    }

    @Override
    protected void checkCreateNew(CustomFieldPossibleValueDataParams customFieldPossibleValueDataParams) {
        CustomField customField = (CustomField)this.conversionHandler.convert(this.getImplementation().getCustomFieldClass(), (Object)customFieldPossibleValueDataParams.getCustomField());
        this.conversionHandler.convert(this.getImplementation().getPossibleValueCategoryClass(), (Object)customFieldPossibleValueDataParams.getCategory());
        this.getFieldSecurity().checkManageAccess(customField);
    }

    protected abstract BaseCustomFieldServiceSecurity<?, CF, C, PV, ?, ?> getCustomFieldServiceSecurity();

    protected abstract BaseCustomFieldPossibleValueServiceLocal<CF, C, PV> getImplementation();

    private BaseCustomFieldServiceSecurity<?, CF, C, PV, ?, ?> getFieldSecurity() {
        return this.getCustomFieldServiceSecurity();
    }
}

