/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.Configuration;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ChannelConfigurationServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.system.channelconfigurations.ChannelConfigurationDTO;
import org.cyclos.model.system.channelconfigurations.ChannelConfigurationData;
import org.cyclos.model.system.channelconfigurations.ChannelConfigurationDataParams;
import org.cyclos.model.system.channelconfigurations.ChannelConfigurationVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.system.ConfigurationServiceSecurity;
import org.cyclos.services.system.ChannelConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ChannelConfigurationServiceSecurity
extends CRUDServiceSecurity<ChannelConfigurationDTO, ChannelConfiguration, ChannelConfigurationData, ChannelConfigurationDataParams>
implements ChannelConfigurationService {
    @Autowired
    private ConfigurationServiceSecurity configurationServiceSecurity;
    @Autowired
    private ChannelConfigurationServiceLocal channelConfigurationService;

    public ChannelConfigurationServiceSecurity() {
        super(ChannelConfiguration.class);
    }

    @Override
    public boolean doHasViewAccess(ChannelConfiguration channelConfiguration) {
        return this.configurationServiceSecurity.doHasViewAccess(channelConfiguration.getConfiguration());
    }

    @Override
    public boolean isAccessible(SessionData sessionData, ChannelConfiguration channelConfiguration) {
        return this.configurationServiceSecurity.isAccessible(sessionData, channelConfiguration.getConfiguration());
    }

    public List<ChannelConfigurationVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkViewAccess(configuration);
        return this.channelConfigurationService.list(configurationVO);
    }

    @Override
    protected void checkCreateNew(ChannelConfigurationDataParams channelConfigurationDataParams) {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)channelConfigurationDataParams.getConfiguration());
        Channel channel = (Channel)this.conversionHandler.convert(Channel.class, (Object)channelConfigurationDataParams.getChannel());
        if (channel.getNetwork() != null && !channel.getNetwork().equals((Object)configuration.getNetwork())) {
            throw new EntityNotFoundException(Channel.class, channelConfigurationDataParams.getChannel().getId());
        }
    }

    @Override
    protected void customizeData(ChannelConfigurationData channelConfigurationData) {
        ChannelConfigurationDTO channelConfigurationDTO = (ChannelConfigurationDTO)channelConfigurationData.getDto();
        if (channelConfigurationDTO.getConfiguration() == null || channelConfigurationDTO.getChannel() == null) {
            channelConfigurationData.setEditable(false);
        } else {
            Configuration configuration = this.find(Configuration.class, channelConfigurationDTO.getConfiguration().getId());
            Channel channel = this.find(Channel.class, channelConfigurationDTO.getChannel().getId());
            channelConfigurationData.setEditable(this.doHasManageAccess(configuration, channel));
        }
    }

    @Override
    protected boolean doHasManageAccess(ChannelConfiguration channelConfiguration) {
        return this.doHasManageAccess(channelConfiguration.getConfiguration(), channelConfiguration.getChannel());
    }

    protected ChannelConfigurationServiceLocal getImplementation() {
        return this.channelConfigurationService;
    }

    private boolean doHasManageAccess(Configuration configuration, Channel channel) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(configuration.getParent());
        boolean bl = configuration.getParent() != null && configurationAccessor.getChannelConfiguration(channel) != null && configurationAccessor.getChannelConfiguration(channel).isLocked();
        return !bl && this.configurationServiceSecurity.doHasManageAccess(configuration);
    }
}

