/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.ConfigurationImage;
import org.cyclos.impl.system.ConfigurationImageServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.configurations.ConfigurationImageVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.images.ConfigurationImagesListData;
import org.cyclos.model.system.images.NewConfigurationImageParams;
import org.cyclos.security.Security;
import org.cyclos.security.system.BaseImageServiceSecurity;
import org.cyclos.security.system.ConfigurationServiceSecurity;
import org.cyclos.services.system.ConfigurationImageService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ConfigurationImageServiceSecurity
extends BaseImageServiceSecurity<ConfigurationImage, NewConfigurationImageParams>
implements ConfigurationImageService {
    @Autowired
    private ConfigurationServiceSecurity configurationServiceSecurity;
    @Autowired
    private ConfigurationImageServiceLocal configurationImageService;

    public ConfigurationImageServiceSecurity() {
        super(ConfigurationImage.class);
    }

    public ConfigurationImageVO getImageVO(ConfigurationVO configurationVO, @NotNull ConfigurationImageType configurationImageType) {
        return this.configurationImageService.getImageVO(configurationVO, configurationImageType);
    }

    public ConfigurationImageServiceLocal getImplementation() {
        return this.configurationImageService;
    }

    public ConfigurationImagesListData getListData(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkViewAccess(configuration);
        ConfigurationImagesListData configurationImagesListData = this.configurationImageService.getListData(configurationVO);
        configurationImagesListData.setEditable(this.configurationServiceSecurity.hasManageContent(configuration));
        return configurationImagesListData;
    }

    @Override
    public boolean hasManageAccess(ConfigurationImage configurationImage) {
        try {
            this.configurationServiceSecurity.checkManageContent(configurationImage.getConfiguration());
            return true;
        }
        catch (PermissionDeniedException permissionDeniedException) {
            return false;
        }
    }

    public List<ConfigurationImageVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        if (configuration != null) {
            this.configurationServiceSecurity.checkViewAccess(configuration);
        }
        return this.configurationImageService.list(configurationVO);
    }

    public ConfigurationImageVO load(@NotNull Long l) throws FrameworkException {
        return this.configurationImageService.load(l);
    }

    public void removeByConfigurationAndType(ConfigurationVO configurationVO, ConfigurationImageType configurationImageType) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        this.configurationServiceSecurity.checkManageContent(configuration);
        this.configurationImageService.removeByConfigurationAndType(configurationVO, configurationImageType);
    }

    @Override
    protected void checkCreateNew(NewConfigurationImageParams newConfigurationImageParams) {
        Configuration configuration = this.find(Configuration.class, newConfigurationImageParams.getConfigurationId());
        this.configurationServiceSecurity.checkManageContent(configuration);
    }
}

