/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import com.querydsl.core.types.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.users.Contact;
import org.cyclos.entities.users.ContactInfo;
import org.cyclos.entities.users.QMemberProductCustomOperation;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.operations.CustomOperationDTO;
import org.cyclos.model.system.operations.CustomOperationData;
import org.cyclos.model.system.operations.CustomOperationResultVO;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.system.operations.RunAdCustomOperationDTO;
import org.cyclos.model.system.operations.RunContactCustomOperationDTO;
import org.cyclos.model.system.operations.RunContactInfoCustomOperationDTO;
import org.cyclos.model.system.operations.RunCustomOperationDTO;
import org.cyclos.model.system.operations.RunCustomOperationData;
import org.cyclos.model.system.operations.RunCustomOperationDataParams;
import org.cyclos.model.system.operations.RunCustomOperationResult;
import org.cyclos.model.system.operations.RunExternalRedirectCallbackParams;
import org.cyclos.model.system.operations.RunMenuItemCustomOperationDTO;
import org.cyclos.model.system.operations.RunRecordCustomOperationDTO;
import org.cyclos.model.system.operations.RunTransferCustomOperationDTO;
import org.cyclos.model.system.operations.RunnableCustomOperationVO;
import org.cyclos.model.users.contactinfos.ContactInfoVO;
import org.cyclos.model.users.contacts.ContactVO;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.CustomOperationService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class CustomOperationServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<CustomOperationDTO, CustomOperation, CustomOperationData, Void>
implements CustomOperationService {
    @Autowired
    private CustomOperationServiceLocal customOperationService;

    public CustomOperationServiceSecurity() {
        super(CustomOperation.class);
    }

    public boolean canManage() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_MANAGE) && sessionData.getNetwork() != null;
    }

    public boolean canView() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) && sessionData.getNetwork() != null;
    }

    @Override
    public void checkCreateNew(Void void_) {
        if (!this.canManage()) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    public boolean doHasViewAccess(CustomOperation customOperation) {
        return this.canView();
    }

    public CredentialInputDTO getConfirmationPasswordInputForRun(RunCustomOperationDataParams runCustomOperationDataParams) {
        SimpleEntity simpleEntity = this.customOperationService.getRelatedEntity(runCustomOperationDataParams);
        this.checkRun(runCustomOperationDataParams.getCustomOperation(), simpleEntity);
        return this.customOperationService.getConfirmationPasswordInputForRun(runCustomOperationDataParams);
    }

    public RunCustomOperationData getRunData(RunCustomOperationDataParams runCustomOperationDataParams) throws FrameworkException {
        SimpleEntity simpleEntity = this.customOperationService.getRelatedEntity(runCustomOperationDataParams);
        this.checkRun(runCustomOperationDataParams.getCustomOperation(), simpleEntity);
        return this.customOperationService.getRunData(runCustomOperationDataParams);
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForAd(BasicAdVO basicAdVO) throws FrameworkException {
        return this.customOperationService.getRunnableOperationsForAd(basicAdVO);
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForContact(ContactVO contactVO) throws FrameworkException {
        this.checkLoggedIn();
        return this.customOperationService.getRunnableOperationsForContact(contactVO);
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForContactInfo(ContactInfoVO contactInfoVO) throws FrameworkException {
        this.checkLoggedIn();
        return this.customOperationService.getRunnableOperationsForContactInfo(contactInfoVO);
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForRecord(RecordVO recordVO) throws FrameworkException {
        this.checkLoggedIn();
        return this.customOperationService.getRunnableOperationsForRecord(recordVO);
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForSystem() throws FrameworkException {
        this.checkLoggedIn();
        return this.customOperationService.getRunnableOperationsForSystem();
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForTransfer(TransferVO transferVO) throws FrameworkException {
        this.checkLoggedIn();
        return this.customOperationService.getRunnableOperationsForTransfer(transferVO);
    }

    public List<RunnableCustomOperationVO> getRunnableOperationsForUser(UserLocatorVO userLocatorVO) throws FrameworkException {
        this.checkLoggedIn();
        return this.customOperationService.getRunnableOperationsForUser(userLocatorVO);
    }

    public List<CustomOperationResultVO> list() throws FrameworkException {
        if (!this.canView()) {
            throw new PermissionDeniedException();
        }
        return this.customOperationService.list();
    }

    public RunCustomOperationResult run(RunCustomOperationDTO runCustomOperationDTO) throws FrameworkException {
        this.checkRun(runCustomOperationDTO);
        return this.customOperationService.run(runCustomOperationDTO);
    }

    public RunCustomOperationResult runExternalRedirectCallback(RunExternalRedirectCallbackParams runExternalRedirectCallbackParams) throws FrameworkException {
        return this.customOperationService.runExternalRedirectCallback(runExternalRedirectCallbackParams);
    }

    public void saveOrder(List<Long> list) {
        this.checkCreateNew(null);
        this.customOperationService.saveOrder(list);
    }

    protected CustomOperation checkRun(CustomOperationVO customOperationVO, SimpleEntity simpleEntity) {
        CustomOperation customOperation2 = this.customOperationService.resolveCustomOperation(simpleEntity, customOperationVO);
        switch (customOperation2.getScope()) {
            case SYSTEM: {
                PermissionHelper.checkContains((Collection)this.customOperationService.getRunnableCustomOperationsForSystem(), (Object)customOperation2);
                break;
            }
            case MENU: {
                PermissionHelper.checkContains((Collection)this.customOperationService.getRunnableOperationsForMenu(), (Object)customOperation2);
                break;
            }
            case BULK_ACTION: {
                PermissionHelper.checkContains((Collection)this.customOperationService.getRunnableOperationsForBulkActions(), (Object)customOperation2);
                break;
            }
            case INTERNAL: {
                Set<CustomOperation> set = this.getAllowedOperations();
                Collection collection = this.customOperationService.listOperationsRedirectingTo(customOperation2);
                boolean bl = false;
                while (!bl && !collection.isEmpty()) {
                    if (CollectionUtils.containsAny(set, (Collection)collection)) {
                        bl = true;
                        continue;
                    }
                    collection.removeIf(customOperation -> customOperation.getScope() != CustomOperationScope.INTERNAL);
                    HashSet hashSet = new HashSet();
                    collection.forEach(customOperation -> hashSet.addAll(this.customOperationService.listOperationsRedirectingTo(customOperation)));
                    collection = hashSet;
                }
                if (bl) break;
                throw new PermissionDeniedException();
            }
            case USER: {
                PermissionHelper.checkContains((Collection)this.customOperationService.getRunnableOperationsForUser((User)simpleEntity), (Object)customOperation2);
                break;
            }
            case ADVERTISEMENT: {
                BasicAd basicAd = (BasicAd)simpleEntity;
                if (basicAd == null) {
                    String string = this.message(GeneralKeys.Errors.REQUIRED, RunAdCustomOperationDTO.AD.getName());
                    throw new ValidationException(string);
                }
                PermissionHelper.checkContains((Collection)this.customOperationService.getRunnableOperationsForAd(basicAd), (Object)customOperation2);
                break;
            }
            case RECORD: {
                Record record = (Record)simpleEntity;
                if (record == null) {
                    String string = this.message(GeneralKeys.Errors.REQUIRED, RunRecordCustomOperationDTO.RECORD.getName());
                    throw new ValidationException(string);
                }
                PermissionHelper.checkContains((Collection)this.customOperationService.getRunnableOperationsForRecord(record), (Object)customOperation2);
                break;
            }
            case TRANSFER: {
                Transfer transfer = (Transfer)simpleEntity;
                if (transfer == null) {
                    String string = this.message(GeneralKeys.Errors.REQUIRED, RunTransferCustomOperationDTO.TRANSFER.getName());
                    throw new ValidationException(string);
                }
                PermissionHelper.checkContains((Collection)this.customOperationService.getRunnableOperationsForTransfer(transfer), (Object)customOperation2);
                break;
            }
            case CONTACT: {
                Contact contact = (Contact)simpleEntity;
                if (contact == null) {
                    String string = this.message(GeneralKeys.Errors.REQUIRED, RunContactCustomOperationDTO.CONTACT.getName());
                    throw new ValidationException(string);
                }
                PermissionHelper.checkContains((Collection)this.customOperationService.getRunnableOperationsForContact(contact), (Object)customOperation2);
                break;
            }
            case CONTACT_INFO: {
                ContactInfo contactInfo = (ContactInfo)simpleEntity;
                if (contactInfo == null) {
                    String string = this.message(GeneralKeys.Errors.REQUIRED, RunContactInfoCustomOperationDTO.CONTACT_INFO.getName());
                    throw new ValidationException(string);
                }
                PermissionHelper.checkContains((Collection)this.customOperationService.getRunnableOperationsForContactInfo(contactInfo), (Object)customOperation2);
            }
        }
        return customOperation2;
    }

    @Override
    protected boolean doHasManageAccess(CustomOperation customOperation) {
        return this.canManage();
    }

    @Override
    protected CRUDServiceLocal<CustomOperation, CustomOperationDTO, CustomOperationData, Void> getImplementation() {
        return this.customOperationService;
    }

    private CustomOperation checkRun(RunCustomOperationDTO runCustomOperationDTO) {
        SimpleEntity simpleEntity;
        CustomOperation customOperation = (CustomOperation)this.conversionHandler.convert(CustomOperation.class, (Object)runCustomOperationDTO.getCustomOperation());
        if (customOperation == null) {
            if (runCustomOperationDTO instanceof RunMenuItemCustomOperationDTO) {
                simpleEntity = (RunMenuItemCustomOperationDTO)runCustomOperationDTO;
                if (simpleEntity.getMenuItem() == null) {
                    throw new ValidationException(RunMenuItemCustomOperationDTO.MENU_ITEM.getName(), this.message(GeneralKeys.Errors.REQUIRED, SystemKeys.Operations.SCOPE_MENU));
                }
            } else {
                throw new ValidationException(RunCustomOperationDTO.CUSTOM_OPERATION.getName(), this.message(GeneralKeys.Errors.REQUIRED, SystemKeys.Operations.ACTIONS_NAME));
            }
        }
        simpleEntity = this.customOperationService.getRelatedEntity(runCustomOperationDTO);
        return this.checkRun(runCustomOperationDTO.getCustomOperation(), simpleEntity);
    }

    private Set<CustomOperation> getAllowedOperations() {
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        HashSet<CustomOperation> hashSet = new HashSet<CustomOperation>(productsAccessor.admin().getSystemCustomOperationsRun());
        BooleanPropertiesHolder booleanPropertiesHolder = productsAccessor.member().getCustomOperations();
        hashSet.addAll(booleanPropertiesHolder.keysSet((Path)QMemberProductCustomOperation.memberProductCustomOperation.run));
        hashSet.addAll(booleanPropertiesHolder.keysSet((Path)QMemberProductCustomOperation.memberProductCustomOperation.runOnOthers));
        hashSet.addAll(productsAccessor.userManagement().getUserCustomOperationsRun());
        hashSet.addAll(this.customOperationService.getRunnableOperationsForMenu());
        hashSet.removeIf(customOperation -> !customOperation.getChannels().contains(sessionData.getChannel()));
        return hashSet;
    }
}

