/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.scripts.CustomScriptDTO;
import org.cyclos.model.system.scripts.CustomScriptData;
import org.cyclos.model.system.scripts.CustomScriptQuery;
import org.cyclos.model.system.scripts.CustomScriptUsedInVO;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.RunScriptData;
import org.cyclos.model.system.scripts.RunScriptParams;
import org.cyclos.model.system.scripts.ScriptResult;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.CustomScriptService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class CustomScriptServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<CustomScriptDTO, CustomScript, CustomScriptData, ScriptType>
implements CustomScriptService {
    @Autowired
    private CustomScriptServiceLocal customScriptService;

    public CustomScriptServiceSecurity() {
        super(CustomScript.class);
    }

    @Override
    public boolean doHasViewAccess(CustomScript customScript) {
        return this.hasPermission();
    }

    public SerializableInputStream getCodeForDebug(CustomScriptVO customScriptVO) throws FrameworkException {
        this.checkPermission();
        return this.customScriptService.getCodeForDebug(customScriptVO);
    }

    public RunScriptData getRunData() throws FrameworkException {
        this.checkPermission();
        return this.customScriptService.getRunData();
    }

    public List<CustomScriptUsedInVO> listUsages(CustomScriptVO customScriptVO) throws FrameworkException {
        this.checkPermission();
        return this.customScriptService.listUsages(customScriptVO);
    }

    public ScriptResult run(RunScriptParams runScriptParams) throws FrameworkException {
        this.checkPermission();
        return this.customScriptService.run(runScriptParams);
    }

    public Page<CustomScriptVO> search(CustomScriptQuery customScriptQuery) throws FrameworkException {
        this.checkPermission();
        return this.customScriptService.search(customScriptQuery);
    }

    @Override
    protected void checkCreateNew(ScriptType scriptType) {
        this.checkPermission();
    }

    @Override
    protected boolean doHasManageAccess(CustomScript customScript) {
        return this.hasPermission();
    }

    @Override
    protected CRUDServiceLocal<CustomScript, CustomScriptDTO, CustomScriptData, ScriptType> getImplementation() {
        return this.customScriptService;
    }

    private void checkPermission() {
        if (!this.hasPermission()) {
            throw new PermissionDeniedException();
        }
    }

    private boolean hasPermission() {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return true;
        }
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        return basicUser != null && (basicUser.isGlobalAdmin() || sessionData.getNetwork() != null && basicUser.isGlobal() && ((AdminGroup)basicUser.getUser().getGroup()).isManageScripts());
    }
}

