/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.CustomWebService;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.CustomWebServiceServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.webservices.CustomWebServiceDTO;
import org.cyclos.model.system.webservices.CustomWebServiceData;
import org.cyclos.model.system.webservices.CustomWebServiceVO;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.CustomWebServiceService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class CustomWebServiceServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<CustomWebServiceDTO, CustomWebService, CustomWebServiceData, Void>
implements CustomWebServiceService {
    @Autowired
    private CustomWebServiceServiceLocal customWebServiceService;

    public CustomWebServiceServiceSecurity() {
        super(CustomWebService.class);
    }

    @Override
    public boolean doHasViewAccess(CustomWebService customWebService) {
        return this.canView();
    }

    public List<CustomWebServiceVO> list() throws FrameworkException {
        if (!this.canView()) {
            throw new PermissionDeniedException();
        }
        return this.customWebServiceService.list();
    }

    @Override
    protected void checkCreateNew(Void void_) {
        if (!this.canManage()) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected boolean doHasManageAccess(CustomWebService customWebService) {
        return this.canManage();
    }

    protected CustomWebServiceServiceLocal getImplementation() {
        return this.customWebServiceService;
    }

    private boolean canManage() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_MANAGE) && sessionData.getNetwork() != null;
    }

    private boolean canView() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) && sessionData.getNetwork() != null;
    }
}

