/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import com.querydsl.core.types.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.contentmanagement.MenuItem;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.system.CustomWizardExecution;
import org.cyclos.entities.system.MenuItemWizard;
import org.cyclos.entities.system.RegistrationWizard;
import org.cyclos.entities.system.SystemWizard;
import org.cyclos.entities.system.UserWizard;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QMemberProductCustomWizard;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.MenuEntryServiceLocal;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.contentmanagement.contentitems.ContentItemVisibility;
import org.cyclos.model.contentmanagement.contentitems.MenuItemType;
import org.cyclos.model.system.wizards.CustomWizardBackParams;
import org.cyclos.model.system.wizards.CustomWizardDTO;
import org.cyclos.model.system.wizards.CustomWizardData;
import org.cyclos.model.system.wizards.CustomWizardExecutionData;
import org.cyclos.model.system.wizards.CustomWizardNature;
import org.cyclos.model.system.wizards.CustomWizardResultVO;
import org.cyclos.model.system.wizards.CustomWizardTransitionParams;
import org.cyclos.model.system.wizards.CustomWizardVerificationCodeParams;
import org.cyclos.model.system.wizards.RunExternalRedirectCallbackParams;
import org.cyclos.model.system.wizards.StartCustomWizardParams;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.CustomWizardService;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class CustomWizardServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<CustomWizardDTO, CustomWizard, CustomWizardData, CustomWizardNature>
implements CustomWizardService {
    @Autowired
    private CustomWizardServiceLocal customWizardService;
    @Autowired
    private MenuEntryServiceLocal menuEntryService;

    public CustomWizardServiceSecurity() {
        super(CustomWizard.class);
    }

    public CustomWizardExecutionData back(@NotNull CustomWizardBackParams customWizardBackParams) throws FrameworkException {
        this.checkOwnership(customWizardBackParams.getKey());
        return this.customWizardService.back(customWizardBackParams);
    }

    public void cancel(String string) throws FrameworkException {
        this.checkOwnership(string);
        this.customWizardService.cancel(string);
    }

    public boolean canManage() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_MANAGE) && sessionData.getNetwork() != null;
    }

    public boolean canView() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) && sessionData.getNetwork() != null;
    }

    @Override
    public void checkCreateNew(CustomWizardNature customWizardNature) {
        if (!this.canManage()) {
            throw new PermissionDeniedException();
        }
    }

    public CustomWizardExecutionData current(@NotNull String string) throws FrameworkException {
        this.checkOwnership(string);
        return this.customWizardService.current(string);
    }

    @Override
    public boolean doHasViewAccess(CustomWizard customWizard) {
        return this.canView();
    }

    public String externalRedirect(@NotNull CustomWizardTransitionParams customWizardTransitionParams) throws FrameworkException {
        this.checkOwnership(customWizardTransitionParams.getKey());
        return this.customWizardService.externalRedirect(customWizardTransitionParams);
    }

    public List<CustomWizardResultVO> list() throws FrameworkException {
        if (!this.canView()) {
            throw new PermissionDeniedException();
        }
        return this.customWizardService.list();
    }

    public CustomWizardExecutionData runExternalRedirectCallback(@NotNull RunExternalRedirectCallbackParams runExternalRedirectCallbackParams) throws FrameworkException {
        return this.customWizardService.runExternalRedirectCallback(runExternalRedirectCallbackParams);
    }

    public void saveOrder(List<Long> list) {
        this.checkCreateNew(null);
        this.customWizardService.saveOrder(list);
    }

    public void sendVerificationCode(@NotNull CustomWizardVerificationCodeParams customWizardVerificationCodeParams) throws FrameworkException {
        this.checkOwnership(customWizardVerificationCodeParams.getKey());
        this.customWizardService.sendVerificationCode(customWizardVerificationCodeParams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CustomWizardExecutionData start(StartCustomWizardParams startCustomWizardParams) throws FrameworkException {
        CustomWizard customWizard;
        List list;
        ProductsAccessor productsAccessor;
        Configuration configuration;
        SessionData sessionData = this.getSessionData();
        MenuItem menuItem = (MenuItem)this.conversionHandler.convert(MenuItem.class, (Object)startCustomWizardParams.getMenuItem());
        if (menuItem != null) {
            configuration = sessionData.getConfiguration().getConfiguration();
            productsAccessor = EnumSet.of(ContentItemVisibility.ALL, sessionData.isGuest() ? ContentItemVisibility.GUESTS : ContentItemVisibility.USERS);
            list = this.menuEntryService.list(null, configuration, false, productsAccessor, false);
            PermissionHelper.checkContains((Collection)list, (Object)menuItem);
            if (menuItem.getType() != MenuItemType.WIZARD) {
                throw new IllegalActionException("Menu item is not of type wizard");
            }
            customWizard = menuItem.getWizard();
        } else {
            customWizard = (CustomWizard)this.conversionHandler.convert(CustomWizard.class, (Object)startCustomWizardParams.getWizard());
            if (customWizard == null) {
                throw new ValidationException("Missing required parameter: wizard");
            }
        }
        if (customWizard instanceof RegistrationWizard) {
            configuration = sessionData.getConfiguration();
            if (sessionData.isGuest() && ObjectHelper.isOneOf((Object)customWizard, (Object[])new Object[]{configuration.getLargeScreenRegistrationWizard(), configuration.getMediumScreenRegistrationWizard(), configuration.getSmallScreenRegistrationWizard()})) return this.customWizardService.start(startCustomWizardParams);
            throw new PermissionDeniedException();
        }
        if (customWizard instanceof SystemWizard) {
            configuration = (SystemWizard)customWizard;
            productsAccessor = sessionData.getProducts();
            PermissionHelper.checkContains((Collection)productsAccessor.admin().getSystemWizardsRun(), (Object)configuration);
            return this.customWizardService.start(startCustomWizardParams);
        } else {
            if (customWizard instanceof UserWizard) {
                configuration = (UserWizard)customWizard;
                productsAccessor = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)startCustomWizardParams.getUser());
                list = sessionData.getProducts();
                if (productsAccessor != null && productsAccessor.equals((Object)sessionData.getLoggedUser())) {
                    if (list.member().getWizards().isSet((Object)configuration, (Path)QMemberProductCustomWizard.memberProductCustomWizard.run)) return this.customWizardService.start(startCustomWizardParams);
                    throw new PermissionDeniedException();
                }
                if (!sessionData.isManagerOf((BasicUser)productsAccessor)) throw new PermissionDeniedException();
                if (list.userManagement().getUserWizards().contains(customWizard)) return this.customWizardService.start(startCustomWizardParams);
                throw new PermissionDeniedException();
            }
            if (customWizard instanceof MenuItemWizard) return this.customWizardService.start(startCustomWizardParams);
            throw new IllegalStateException("Unhandled wizard type: " + String.valueOf(customWizard));
        }
    }

    public CustomWizardExecutionData transition(CustomWizardTransitionParams customWizardTransitionParams) throws FrameworkException {
        this.checkOwnership(customWizardTransitionParams.getKey());
        return this.customWizardService.transition(customWizardTransitionParams);
    }

    @Override
    protected boolean doHasManageAccess(CustomWizard customWizard) {
        return this.canManage();
    }

    @Override
    protected CRUDServiceLocal<CustomWizard, CustomWizardDTO, CustomWizardData, CustomWizardNature> getImplementation() {
        return this.customWizardService;
    }

    private void checkOwnership(String string) {
        CustomWizardExecution customWizardExecution = this.customWizardService.findExecution(string);
        SessionData sessionData = this.getSessionData();
        if (sessionData.isGuest() && customWizardExecution.getLoggedUser() != null || sessionData.isLoggedIn() && !sessionData.getLoggedBasicUser().equals((Object)customWizardExecution.getLoggedUser())) {
            throw new PermissionDeniedException();
        }
    }
}

