/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.CustomWizardStep;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.CustomWizardStepServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.system.wizardsteps.CustomWizardStepDTO;
import org.cyclos.model.system.wizardsteps.CustomWizardStepData;
import org.cyclos.model.system.wizardsteps.CustomWizardStepDataParams;
import org.cyclos.model.system.wizardsteps.CustomWizardStepVO;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.CustomWizardStepService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class CustomWizardStepServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<CustomWizardStepDTO, CustomWizardStep, CustomWizardStepData, CustomWizardStepDataParams>
implements CustomWizardStepService {
    @Autowired
    private CustomWizardStepServiceLocal customWizardStepService;

    public CustomWizardStepServiceSecurity() {
        super(CustomWizardStep.class);
    }

    public boolean canManage() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_MANAGE) && sessionData.getNetwork() != null;
    }

    public boolean canView() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) && sessionData.getNetwork() != null;
    }

    @Override
    public void checkCreateNew(CustomWizardStepDataParams customWizardStepDataParams) {
        if (!this.canManage()) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    public boolean doHasViewAccess(CustomWizardStep customWizardStep) {
        return this.canView();
    }

    public List<CustomWizardStepVO> list(CustomWizardVO customWizardVO) throws FrameworkException {
        if (!this.canView()) {
            throw new PermissionDeniedException();
        }
        return this.customWizardStepService.list(customWizardVO);
    }

    public void saveOrder(List<Long> list) {
        this.checkCreateNew(null);
        this.customWizardStepService.saveOrder(list);
    }

    @Override
    protected boolean doHasManageAccess(CustomWizardStep customWizardStep) {
        return this.canManage();
    }

    protected CustomWizardStepServiceLocal getImplementation() {
        return this.customWizardStepService;
    }
}

