/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import javax.validation.constraints.NotNull;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.DefaultUserImage;
import org.cyclos.impl.system.DefaultUserImageServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.configurations.DefaultUserImageVO;
import org.cyclos.security.Security;
import org.cyclos.security.system.BaseImageServiceSecurity;
import org.cyclos.security.system.ConfigurationServiceSecurity;
import org.cyclos.services.system.DefaultUserImageService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class DefaultUserImageServiceSecurity
extends BaseImageServiceSecurity<DefaultUserImage, Long>
implements DefaultUserImageService {
    @Autowired
    private ConfigurationServiceSecurity configurationServiceSecurity;
    @Autowired
    private DefaultUserImageServiceLocal defaultUserImageService;

    public DefaultUserImageServiceSecurity() {
        super(DefaultUserImage.class);
    }

    public DefaultUserImageVO getImageVO(ConfigurationVO configurationVO) {
        return this.defaultUserImageService.getImageVO(configurationVO);
    }

    public DefaultUserImageServiceLocal getImplementation() {
        return this.defaultUserImageService;
    }

    @Override
    public boolean hasManageAccess(DefaultUserImage defaultUserImage) {
        try {
            this.configurationServiceSecurity.checkManageAccess(defaultUserImage.getConfiguration());
            return true;
        }
        catch (PermissionDeniedException permissionDeniedException) {
            return false;
        }
    }

    public DefaultUserImageVO load(@NotNull Long l) throws FrameworkException {
        return this.defaultUserImageService.load(l);
    }

    @Override
    protected void checkCreateNew(Long l) {
        Configuration configuration = this.find(Configuration.class, l);
        this.configurationServiceSecurity.checkManageAccess(configuration);
    }
}

