/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.Collection;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.EntityLog;
import org.cyclos.entities.system.EntityPropertyLog;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.EntityLogRegistry;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.entitylogs.EntityLogSearchData;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.entitylogs.EntityLogTypeFilter;
import org.cyclos.model.system.entitylogs.EntityPropertyLogQuery;
import org.cyclos.model.system.entitylogs.EntityPropertyLogVO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.recordtypes.SystemRecordTypeVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.EntityLogService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class EntityLogServiceSecurity
extends BaseServiceSecurity
implements EntityLogService {
    @Autowired
    private EntityLogServiceLocal entityLogService;
    @Autowired
    private EntityLogRegistry entityLogRegistry;
    @Autowired
    private RecordTypeServiceLocal recordTypeServiceLocal;

    public boolean canViewEntityLog(SimpleEntity simpleEntity) {
        if (!this.entityLogRegistry.isLogEnabled(simpleEntity)) {
            return false;
        }
        return this.entityLogRegistry.getHandler(simpleEntity.getClass()).canViewEntityLog(simpleEntity.getId().longValue());
    }

    public FileInfo exportEntityPropertyLogs(@NotNull ExportFormatVO exportFormatVO, @NotNull EntityPropertyLogQuery entityPropertyLogQuery) {
        this.checkLoggedIn();
        this.checkQuery(entityPropertyLogQuery);
        return this.entityLogService.exportEntityPropertyLogs(exportFormatVO, entityPropertyLogQuery);
    }

    public EntityLogSearchData getGeneralSearchData(boolean bl) throws FrameworkException {
        this.checkPermission(bl ? Permission.ENTITY_LOG_VIEW_CONFIGURATION : Permission.ENTITY_LOG_VIEW_USER);
        return this.entityLogService.getGeneralSearchData(bl);
    }

    public EntityLogSearchData getSearchData(Long l, EntityLogType entityLogType) throws FrameworkException {
        if (l == null || entityLogType == null) {
            throw new ValidationException();
        }
        return this.entityLogService.getSearchData(l, entityLogType);
    }

    public EntityLogSearchData getSystemRecordsLogsSearchData(SystemRecordTypeVO systemRecordTypeVO) {
        if (!this.recordTypeServiceLocal.listVisibleSystemTypes().contains(this.conversionHandler.convert(SystemRecordType.class, (Object)systemRecordTypeVO))) {
            throw new PermissionDeniedException();
        }
        return this.entityLogService.getSystemRecordsLogsSearchData(systemRecordTypeVO);
    }

    public EntityPropertyLogVO load(Long l) {
        return this.entityLogService.load(l);
    }

    public Page<EntityPropertyLogVO> search(EntityPropertyLogQuery entityPropertyLogQuery) {
        this.checkLoggedIn();
        this.checkQuery(entityPropertyLogQuery);
        return this.entityLogService.search(entityPropertyLogQuery);
    }

    protected boolean canViewEntityLog(EntityLog entityLog) {
        return this.entityLogRegistry.getHandler(entityLog.getType()).canViewPropertiesLog(entityLog);
    }

    protected void checkViewEntityLog(BaseEntity baseEntity) {
        if (!this.canViewEntityLog((SimpleEntity)baseEntity)) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<EntityPropertyLog>(EntityPropertyLog.class){

            public boolean isVisible(SessionData sessionData, EntityPropertyLog entityPropertyLog) {
                Network network = entityPropertyLog.getNetwork();
                if (network == null && !sessionData.isGlobalAdmin()) {
                    return false;
                }
                if (sessionData.isMultiNetworkAdminInGlobalMode() && !((AdminGroup)sessionData.getGroup()).getManagedNetworks().contains(network)) {
                    return false;
                }
                EntityLog entityLog = entityPropertyLog.getEntityLog();
                EntityLogType entityLogType = entityLog.getType();
                if (entityLogType.isConfiguration() && EntityLogServiceSecurity.this.hasPermission(new Permission[]{Permission.ENTITY_LOG_VIEW_CONFIGURATION}) || entityLogType.isUser() && EntityLogServiceSecurity.this.hasPermission(new Permission[]{Permission.ENTITY_LOG_VIEW_USER})) {
                    return true;
                }
                return EntityLogServiceSecurity.this.canViewEntityLog(entityLog);
            }
        };
    }

    private void checkQuery(EntityPropertyLogQuery entityPropertyLogQuery) {
        Long l = entityPropertyLogQuery.getEntityId();
        if (entityPropertyLogQuery.getEntityId() == null ? CollectionHelper.isEmpty((Iterable)entityPropertyLogQuery.getTypeFilters()) : entityPropertyLogQuery.getType() == null) {
            throw new ValidationException();
        }
        if (l == null) {
            if (entityPropertyLogQuery.getRecordType() != null) {
                RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)entityPropertyLogQuery.getRecordType());
                boolean bl = recordType instanceof SystemRecordType;
                if (!bl && !entityPropertyLogQuery.getTypeFilters().contains(EntityLogTypeFilter.USER_RECORD) || bl && !entityPropertyLogQuery.getTypeFilters().contains(EntityLogTypeFilter.SYSTEM_RECORD)) {
                    throw new IllegalArgumentException();
                }
                if (bl && !this.recordTypeServiceLocal.listVisibleSystemTypes().contains(recordType)) {
                    throw new PermissionDeniedException();
                }
            }
            if (CollectionHelper.containsAny((Collection)entityPropertyLogQuery.getTypeFilters(), (Collection)EntityLogTypeFilter.filtersByTypes((Set)EntityLogType.getEntityLogTypes((boolean)true)))) {
                this.checkPermission(Permission.ENTITY_LOG_VIEW_CONFIGURATION);
            }
            if (CollectionHelper.containsAny((Collection)entityPropertyLogQuery.getTypeFilters(), (Collection)EntityLogTypeFilter.filtersByTypes((Set)EntityLogType.getEntityLogTypes((boolean)false)))) {
                this.checkPermission(Permission.ENTITY_LOG_VIEW_USER);
            }
        } else if (!this.entityLogRegistry.getHandler(entityPropertyLogQuery.getType()).canViewEntityLog(l.longValue())) {
            throw new PermissionDeniedException();
        }
    }
}

