/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.ExtensionPoint;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.extensionpoints.ExtensionPointDTO;
import org.cyclos.model.system.extensionpoints.ExtensionPointData;
import org.cyclos.model.system.extensionpoints.ExtensionPointNature;
import org.cyclos.model.system.extensionpoints.ExtensionPointVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.ExtensionPointService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ExtensionPointServiceSecurity
extends CRUDServiceSecurity<ExtensionPointDTO, ExtensionPoint, ExtensionPointData, ExtensionPointNature>
implements ExtensionPointService {
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;

    public ExtensionPointServiceSecurity() {
        super(ExtensionPoint.class);
    }

    @Override
    public boolean doHasViewAccess(ExtensionPoint extensionPoint) {
        return this.canView();
    }

    @Override
    public boolean isAccessible(SessionData sessionData, ExtensionPoint extensionPoint) {
        return true;
    }

    public List<ExtensionPointVO> list() throws FrameworkException {
        if (!this.canView()) {
            throw new PermissionDeniedException();
        }
        return this.extensionPointService.list();
    }

    @Override
    protected void checkCreateNew(ExtensionPointNature extensionPointNature) {
        if (!this.canManage()) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected boolean doHasManageAccess(ExtensionPoint extensionPoint) {
        return this.canManage();
    }

    @Override
    protected CRUDServiceLocal<ExtensionPoint, ExtensionPointDTO, ExtensionPointData, ExtensionPointNature> getImplementation() {
        return this.extensionPointService;
    }

    private boolean canManage() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_MANAGE) && sessionData.getNetwork() != null;
    }

    private boolean canView() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) && sessionData.getNetwork() != null;
    }
}

