/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.HashMap;
import java.util.Map;
import org.cyclos.entities.system.Image;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.system.InternalImageServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.contentmanagement.themes.ThemeImageType;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.images.ImageNature;
import org.cyclos.model.system.images.ImageSize;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.system.BaseImageServiceSecurity;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.InternalImageService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class InternalImageServiceSecurity
extends BaseServiceSecurity
implements InternalImageService {
    @Autowired
    private InternalImageServiceLocal internalImageService;
    private Map<ImageNature, BaseImageServiceSecurity<?, ?>> securitiesByNature;

    public ImageVO load(Long l) throws FrameworkException {
        return this.internalImageService.load(l);
    }

    public ImageVO loadByKey(String string) throws FrameworkException {
        return this.internalImageService.loadByKey(string);
    }

    public SerializableInputStream qrCode(String string, ImageSize imageSize) throws FrameworkException {
        return this.internalImageService.qrCode(string, imageSize);
    }

    public SerializableInputStream readConfigurationImage(Long l, ConfigurationImageType configurationImageType) throws FrameworkException {
        return this.internalImageService.readConfigurationImage(l, configurationImageType);
    }

    public SerializableInputStream readContent(Long l) throws FrameworkException {
        return this.internalImageService.readContent(l);
    }

    public SerializableInputStream readContentByKey(String string) throws FrameworkException {
        return this.internalImageService.readContentByKey(string);
    }

    public SerializableInputStream readThemeImage(Long l, ThemeImageType themeImageType, String string) throws FrameworkException {
        return this.internalImageService.readThemeImage(l, themeImageType, string);
    }

    public SerializableInputStream readVoucherTemplateImage(Long l, String string) throws FrameworkException {
        return this.internalImageService.readVoucherTemplateImage(l, string);
    }

    public void remove(Long l) throws FrameworkException {
        Image image = this.find(Image.class, l);
        BaseImageServiceSecurity<?, ?> baseImageServiceSecurity = this.securitiesByNature.get(image.getNature());
        boolean bl = baseImageServiceSecurity.hasManageAccess(image);
        if (!bl) {
            throw new PermissionDeniedException();
        }
        this.internalImageService.remove(l);
    }

    public void removeByKey(String string) throws FrameworkException {
        Image image = this.internalImageService.findByKey(string);
        BaseImageServiceSecurity<?, ?> baseImageServiceSecurity = this.securitiesByNature.get(image.getNature());
        boolean bl = baseImageServiceSecurity.hasManageAccess(image);
        if (!bl) {
            throw new PermissionDeniedException();
        }
        this.internalImageService.removeByKey(string);
    }

    @Override
    protected void doInitialize() {
        this.securitiesByNature = new HashMap();
        Map map = this.applicationContext.getBeansOfType(BaseImageServiceSecurity.class);
        for (BaseImageServiceSecurity baseImageServiceSecurity : map.values()) {
            ImageNature imageNature = baseImageServiceSecurity.getImageNature();
            this.securitiesByNature.put(imageNature, baseImageServiceSecurity);
        }
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

