/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import org.cyclos.entities.system.IpAddress;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.IpAddressServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.ipaddresses.IpAddressDTO;
import org.cyclos.model.system.ipaddresses.IpAddressData;
import org.cyclos.model.system.ipaddresses.IpAddressLogQuery;
import org.cyclos.model.system.ipaddresses.IpAddressLogVO;
import org.cyclos.model.system.ipaddresses.IpAddressQuery;
import org.cyclos.model.system.ipaddresses.IpAddressVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.IpAddressService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class IpAddressServiceSecurity
extends CRUDServiceSecurity<IpAddressDTO, IpAddress, IpAddressData, Void>
implements IpAddressService {
    @Autowired
    private IpAddressServiceLocal ipAddressService;

    public IpAddressServiceSecurity() {
        super(IpAddress.class);
    }

    @Override
    public boolean doHasViewAccess(IpAddress ipAddress) {
        return this.hasPermission();
    }

    @Override
    public boolean isAccessible(SessionData sessionData, IpAddress ipAddress) {
        return true;
    }

    public Page<IpAddressVO> search(IpAddressQuery ipAddressQuery) {
        this.check();
        return this.ipAddressService.search(ipAddressQuery);
    }

    public Page<IpAddressLogVO> searchLogs(IpAddressLogQuery ipAddressLogQuery) throws FrameworkException {
        this.check();
        return this.ipAddressService.searchLogs(ipAddressLogQuery);
    }

    @Override
    protected void checkCreateNew(Void void_) {
        this.check();
    }

    @Override
    protected boolean doHasManageAccess(IpAddress ipAddress) {
        return this.hasPermission();
    }

    protected IpAddressServiceLocal getImplementation() {
        return this.ipAddressService;
    }

    private void check() {
        if (!this.hasPermission()) {
            throw new PermissionDeniedException();
        }
    }

    private boolean hasPermission() {
        SessionData sessionData = this.getSessionData();
        return sessionData.isSystem() || sessionData.isGlobalAdmin() || sessionData.isGlobalAdminInNetwork();
    }
}

