/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.system.ReportServiceLocal;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.reports.SystemReportData;
import org.cyclos.model.system.reports.SystemReportQuery;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.ReportService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ReportServiceSecurity
extends BaseServiceSecurity
implements ReportService {
    @Autowired
    private ReportServiceLocal reportService;

    public SystemReportData getSystemReportData() {
        this.checkPermission(Permission.SYSTEM_REPORTS_VIEW);
        return this.reportService.getSystemReportData();
    }

    public SerializableInputStream readSystemReport(SystemReportQuery systemReportQuery) throws EntityNotFoundException, ValidationException {
        this.checkPermission(Permission.SYSTEM_REPORTS_VIEW);
        return this.reportService.readSystemReport(systemReportQuery);
    }

    public void validate(SystemReportQuery systemReportQuery) throws ValidationException, FrameworkException {
        this.reportService.validate(systemReportQuery);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

