/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.SmsChannelConfiguration;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.impl.system.SmsOperationConfigurationServiceLocal;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationConfigurationDTO;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationConfigurationData;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationConfigurationDataParams;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationConfigurationNature;
import org.cyclos.model.system.smsoperationconfigurations.SmsOperationConfigurationVO;
import org.cyclos.model.system.smsoperationconfigurations.SmsTextsListData;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.system.ChannelConfigurationServiceSecurity;
import org.cyclos.security.system.ConfigurationServiceSecurity;
import org.cyclos.services.system.SmsOperationConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class SmsOperationConfigurationServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<SmsOperationConfigurationDTO, SmsOperationConfiguration, SmsOperationConfigurationData, SmsOperationConfigurationDataParams>
implements SmsOperationConfigurationService {
    @Autowired
    private ConfigurationServiceSecurity configurationServiceSecurity;
    @Autowired
    private ChannelConfigurationServiceSecurity channelConfigurationServiceSecurity;
    @Autowired
    private SmsOperationConfigurationServiceLocal smsOperationConfigurationService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    public SmsOperationConfigurationServiceSecurity() {
        super(SmsOperationConfiguration.class);
    }

    @Override
    public boolean doHasViewAccess(SmsOperationConfiguration smsOperationConfiguration) {
        return this.hasManageContent(smsOperationConfiguration) || this.channelConfigurationServiceSecurity.doHasViewAccess((ChannelConfiguration)smsOperationConfiguration.getChannelConfiguration());
    }

    public SmsTextsListData getSmsTextsListData(Long l) throws FrameworkException {
        ChannelConfiguration channelConfiguration = this.checkConfigurationViewAccessForSms(l);
        SmsTextsListData smsTextsListData = this.smsOperationConfigurationService.getSmsTextsListData(l);
        smsTextsListData.setEditable(this.configurationServiceSecurity.hasManageContent(channelConfiguration.getConfiguration()));
        return smsTextsListData;
    }

    public boolean hasManageContent(SmsOperationConfiguration smsOperationConfiguration) {
        if (smsOperationConfiguration.getNature() != SmsOperationConfigurationNature.TEXT) {
            return false;
        }
        return this.configurationServiceSecurity.hasManageContent(smsOperationConfiguration.getChannelConfiguration().getConfiguration());
    }

    public List<SmsOperationConfigurationVO> listSmsTexts(Long l) throws FrameworkException {
        this.checkConfigurationViewAccessForSms(l);
        return this.smsOperationConfigurationService.listSmsTexts(l);
    }

    @Override
    protected void checkCreateNew(SmsOperationConfigurationDataParams smsOperationConfigurationDataParams) {
        SmsChannelConfiguration smsChannelConfiguration = this.find(SmsChannelConfiguration.class, smsOperationConfigurationDataParams.getChannelConfigurationId());
        SmsOperationConfigurationNature smsOperationConfigurationNature = smsOperationConfigurationDataParams.getNature();
        if (smsOperationConfigurationNature == SmsOperationConfigurationNature.TEXT && this.configurationServiceSecurity.hasManageContent(smsChannelConfiguration.getConfiguration())) {
            return;
        }
        this.channelConfigurationServiceSecurity.checkManageAccess(smsChannelConfiguration);
    }

    @Override
    protected void customizeData(SmsOperationConfigurationData smsOperationConfigurationData) {
        ChannelConfiguration channelConfiguration;
        if (smsOperationConfigurationData.isEditable() && !(channelConfiguration = this.find(ChannelConfiguration.class, ((SmsOperationConfigurationDTO)smsOperationConfigurationData.getDto()).getChannelConfiguration().getId())).isDefined()) {
            smsOperationConfigurationData.setEditable(false);
        }
    }

    @Override
    protected boolean doHasManageAccess(SmsOperationConfiguration smsOperationConfiguration) {
        return this.hasManageContent(smsOperationConfiguration) || this.channelConfigurationServiceSecurity.doHasManageAccess((ChannelConfiguration)smsOperationConfiguration.getChannelConfiguration());
    }

    protected SmsOperationConfigurationServiceLocal getImplementation() {
        return this.smsOperationConfigurationService;
    }

    private ChannelConfiguration checkConfigurationViewAccessForSms(Long l) {
        ChannelConfiguration channelConfiguration = (ChannelConfiguration)this.rawEntityManagerHandler.find(ChannelConfiguration.class, l);
        if (channelConfiguration.isGlobal()) {
            throw new ValidationException(this.message(GeneralKeys.Errors.SMS_CHANNEL_CONFIGURATION_NOT_DEFINED, new Object[0]));
        }
        if (!channelConfiguration.getNetwork().equals((Object)this.getSessionData().getNetwork())) {
            throw new EntityNotFoundException(ChannelConfiguration.class, l);
        }
        this.channelConfigurationServiceSecurity.checkViewAccess(channelConfiguration);
        return channelConfiguration;
    }
}

