/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.Collection;
import java.util.Set;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.users.ConnectedUserServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.BaseEntityManagerHandler;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.users.users.ConnectedUserQuery;
import org.cyclos.model.users.users.ConnectedUserSearchData;
import org.cyclos.model.users.users.ConnectedUserVO;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.ConnectedUserService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ConnectedUserServiceSecurity
extends BaseServiceSecurity
implements ConnectedUserService {
    @Autowired
    private ConnectedUserServiceLocal connectedUserService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private SessionHandler sessionHandler;

    public int disconnect(UserLocatorVO userLocatorVO) throws FrameworkException {
        this.checkPermission(Permission.CONNECTED_USERS_MANAGE, Permission.MY_OPERATORS_ENABLE);
        this.checkManagesUser((IUser)this.userService.locate(userLocatorVO));
        return this.connectedUserService.disconnect(userLocatorVO);
    }

    public int disconnectBySessionTokens(Set<String> set) throws FrameworkException {
        this.checkPermission(Permission.CONNECTED_USERS_MANAGE, Permission.MY_OPERATORS_ENABLE);
        QueryHelper.processBatch((BaseEntityManagerHandler)this.entityManagerHandler, set.iterator(), string -> {
            Session session = this.sessionHandler.getIfValid(null, string);
            if (session != null) {
                this.checkManagesUser(session.getUser());
            }
        });
        return this.connectedUserService.disconnectBySessionTokens(set);
    }

    public ConnectedUserSearchData getSearchData() throws FrameworkException {
        this.checkPermission(Permission.CONNECTED_USERS_VIEW, Permission.MY_OPERATORS_ENABLE);
        return this.connectedUserService.getSearchData();
    }

    public Page<ConnectedUserVO> search(ConnectedUserQuery connectedUserQuery) throws FrameworkException {
        this.checkPermission(Permission.CONNECTED_USERS_VIEW, Permission.MY_OPERATORS_ENABLE);
        this.checkQuery(connectedUserQuery);
        return this.connectedUserService.search(connectedUserQuery);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private void checkQuery(ConnectedUserQuery connectedUserQuery) {
        ConnectedUserSearchData connectedUserSearchData = this.connectedUserService.getSearchData();
        PermissionHelper.applyAllowed((Collection)connectedUserQuery.getRoles(), (Collection)connectedUserSearchData.getRoles());
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isAdmin()) {
            User user;
            User user2 = (User)this.conversionHandler.convert(User.class, (Object)connectedUserQuery.getBroker());
            if (user2 != null) {
                this.checkManagesUser((BasicUser)user2);
            }
            if ((user = (User)this.conversionHandler.convert(User.class, (Object)connectedUserQuery.getOperatorsOf())) != null) {
                this.checkManagesUser((BasicUser)user);
            }
            if (user2 == null && user == null) {
                if (sessionData.isBroker()) {
                    connectedUserQuery.setBroker(new UserVO(sessionData.getLoggedUser().getId()));
                } else if (sessionData.isMember()) {
                    connectedUserQuery.setOperatorsOf(new UserVO(sessionData.getLoggedUser().getId()));
                }
            }
        }
    }
}

