/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.OperatorGroupServiceLocal;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.users.operatorgroups.ChangeOperatorGroupDTO;
import org.cyclos.model.users.operatorgroups.ChangeOperatorGroupData;
import org.cyclos.model.users.operatorgroups.OperatorGroupDTO;
import org.cyclos.model.users.operatorgroups.OperatorGroupData;
import org.cyclos.model.users.operatorgroups.OperatorGroupListData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.users.OperatorServiceSecurity;
import org.cyclos.services.users.OperatorGroupService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class OperatorGroupServiceSecurity
extends CRUDServiceSecurity<OperatorGroupDTO, OperatorGroup, OperatorGroupData, UserLocatorVO>
implements OperatorGroupService {
    @Autowired
    private OperatorServiceSecurity operatorServiceSecurity;
    @Autowired
    private OperatorGroupServiceLocal operatorGroupService;

    public OperatorGroupServiceSecurity() {
        super(OperatorGroup.class);
    }

    public boolean canManageGroups(User user) {
        return !user.isRemoved() && this.permission((BasicUser)user).my(new Permission[]{Permission.MY_OPERATORS_MANAGE_GROUPS}).user(new Permission[]{Permission.USER_OPERATORS_MANAGE}).granted();
    }

    public Long changeGroup(ChangeOperatorGroupDTO changeOperatorGroupDTO) throws FrameworkException {
        Operator operator = (Operator)this.conversionHandler.convert(Operator.class, (Object)changeOperatorGroupDTO.getOperator());
        if (!this.operatorServiceSecurity.canManageOperators(operator.getUser())) {
            throw new PermissionDeniedException();
        }
        return this.operatorGroupService.changeGroup(changeOperatorGroupDTO);
    }

    @Override
    public boolean doHasViewAccess(OperatorGroup operatorGroup) {
        return this.operatorServiceSecurity.canViewOperators(operatorGroup.getUser());
    }

    public ChangeOperatorGroupData getChangeGroupData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        if (!this.operatorServiceSecurity.canViewOperators(basicUser.getUser())) {
            throw new PermissionDeniedException();
        }
        if (!(basicUser instanceof Operator)) {
            throw new EntityNotFoundException();
        }
        return this.operatorGroupService.getChangeGroupData(userLocatorVO);
    }

    public OperatorGroupListData getListData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        if (!this.operatorServiceSecurity.canViewOperators(user)) {
            throw new PermissionDeniedException();
        }
        OperatorGroupListData operatorGroupListData = this.operatorGroupService.getListData(userLocatorVO);
        operatorGroupListData.setCanManage(this.canManageGroups(user));
        return operatorGroupListData;
    }

    @Override
    public boolean isAccessible(SessionData sessionData, OperatorGroup operatorGroup) {
        return false;
    }

    @Override
    protected void checkCreateNew(UserLocatorVO userLocatorVO) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        if (!this.canManageGroups(user)) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected boolean doHasManageAccess(OperatorGroup operatorGroup) {
        return this.canManageGroups(operatorGroup.getUser());
    }

    @Override
    protected CRUDServiceLocal<OperatorGroup, OperatorGroupDTO, OperatorGroupData, UserLocatorVO> getImplementation() {
        return this.operatorGroupService;
    }
}

