/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import com.querydsl.core.types.Path;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.QProductManagement;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.model.CyclosException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.UnexpectedDataAccessException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.users.products.ProductDTO;
import org.cyclos.model.users.products.ProductData;
import org.cyclos.model.users.products.ProductNature;
import org.cyclos.model.users.products.ProductQuery;
import org.cyclos.model.users.products.ProductSearchData;
import org.cyclos.model.users.products.ProductWithUserAccountVO;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.ProductService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ProductServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<ProductDTO, Product, ProductData, ProductNature>
implements ProductService {
    private static final String GET_DATA_METHOD = "getData";
    private static final String GET_DATA_FOR_NEW_METHOD = "getDataForNew";
    private static final String SAVE_METHOD = "save";
    @Autowired
    private ProductServiceLocal productService;
    private ProductServiceLocal productServiceProxy = (ProductServiceLocal)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ProductServiceLocal.class}, (InvocationHandler)new ProductServiceInvocationHandler());
    @Autowired
    protected InvokerHandler invokerHandler;

    public ProductServiceSecurity() {
        super(Product.class);
    }

    @Override
    public boolean doHasViewAccess(Product product) {
        QProductManagement qProductManagement = QProductManagement.productManagement;
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.USER_CONFIGURATION_VIEW) || sessionData.getProducts().admin().getManagedProducts().isSet((Object)product, (Path)qProductManagement.view);
    }

    public ProductSearchData getSearchData() {
        this.checkViewPermission();
        return this.productService.getSearchData();
    }

    public Page<ProductWithUserAccountVO> search(ProductQuery productQuery) throws FrameworkException {
        this.checkViewPermission();
        this.groupsHandler.visibles().accessibles().basic().check((Collection)productQuery.getGroups());
        return this.productService.search(productQuery);
    }

    @Override
    protected void checkCreateNew(ProductNature productNature) {
        this.checkPermission(Permission.USER_CONFIGURATION_MANAGE);
    }

    @Override
    protected boolean doHasManageAccess(Product product) {
        QProductManagement qProductManagement = QProductManagement.productManagement;
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.USER_CONFIGURATION_MANAGE) || sessionData.getProducts().admin().getManagedProducts().isSet((Object)product, (Path)qProductManagement.manage);
    }

    protected ProductServiceLocal getImplementation() {
        return this.productServiceProxy;
    }

    private void checkViewPermission() {
        QProductManagement qProductManagement = QProductManagement.productManagement;
        boolean bl = this.getSessionData().getProducts().admin().getManagedProducts().isAnyKeySet((Path)qProductManagement.view);
        if (!this.hasPermission(Permission.USER_CONFIGURATION_VIEW) && !bl) {
            throw new PermissionDeniedException();
        }
    }

    private class ProductServiceInvocationHandler
    implements InvocationHandler {
        private ProductServiceInvocationHandler() {
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            try {
                if (ProductServiceSecurity.GET_DATA_METHOD.equals(method.getName()) || ProductServiceSecurity.GET_DATA_FOR_NEW_METHOD.equals(method.getName()) || ProductServiceSecurity.SAVE_METHOD.equals(method.getName())) {
                    return ProductServiceSecurity.this.invokerHandler.runAs(SessionDataFactory.script((boolean)true), () -> method.invoke((Object)ProductServiceSecurity.this.productService, objectArray));
                }
                return method.invoke((Object)ProductServiceSecurity.this.productService, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof CyclosException) {
                    throw throwable;
                }
                throw new UnexpectedDataAccessException(throwable.getMessage(), throwable);
            }
        }
    }
}

