/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.List;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordCustomFieldPossibleValue;
import org.cyclos.entities.users.RecordCustomFieldPossibleValueCategory;
import org.cyclos.impl.users.RecordCustomFieldServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.recordfields.RecordCustomFieldDTO;
import org.cyclos.model.users.recordfields.RecordCustomFieldData;
import org.cyclos.model.users.recordfields.RecordCustomFieldVO;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.security.Security;
import org.cyclos.security.system.BaseSimpleCustomFieldServiceSecurity;
import org.cyclos.services.users.RecordCustomFieldService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class RecordCustomFieldServiceSecurity
extends BaseSimpleCustomFieldServiceSecurity<RecordCustomFieldDTO, RecordCustomField, RecordCustomFieldPossibleValueCategory, RecordCustomFieldPossibleValue, RecordCustomFieldData, RecordTypeVO>
implements RecordCustomFieldService {
    @Autowired
    private RecordCustomFieldServiceLocal recordCustomFieldService;

    public RecordCustomFieldServiceSecurity() {
        super(RecordCustomField.class, Permission.SYSTEM_CONFIGURATION_VIEW, Permission.SYSTEM_CONFIGURATION_MANAGE);
    }

    public void linkShared(RecordTypeVO recordTypeVO, CustomFieldVO customFieldVO) throws FrameworkException {
        this.checkManagePermission();
        this.recordCustomFieldService.linkShared(recordTypeVO, customFieldVO);
    }

    public List<RecordCustomFieldVO> list(RecordTypeVO recordTypeVO) {
        this.checkViewPermission();
        return this.recordCustomFieldService.list(recordTypeVO);
    }

    public List<CustomFieldVO> listShared() {
        this.checkViewPermission();
        return this.recordCustomFieldService.listShared();
    }

    public void saveOrderOnType(RecordTypeVO recordTypeVO, List<CustomFieldVO> list) throws FrameworkException {
        this.checkManagePermission();
        this.recordCustomFieldService.saveOrderOnType(recordTypeVO, list);
    }

    public void unlinkShared(RecordTypeVO recordTypeVO, CustomFieldVO customFieldVO) throws FrameworkException {
        this.checkManagePermission();
        this.recordCustomFieldService.unlinkShared(recordTypeVO, customFieldVO);
    }

    protected RecordCustomFieldServiceLocal getImplementation() {
        return this.recordCustomFieldService;
    }
}

