/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.List;
import org.cyclos.entities.users.RecordSection;
import org.cyclos.impl.users.RecordSectionServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.users.recordsections.RecordSectionDTO;
import org.cyclos.model.users.recordsections.RecordSectionData;
import org.cyclos.model.users.recordsections.RecordSectionVO;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.security.Security;
import org.cyclos.security.SimpleConfigurationEntityCRUDServiceSecurity;
import org.cyclos.services.users.RecordSectionService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class RecordSectionServiceSecurity
extends SimpleConfigurationEntityCRUDServiceSecurity<RecordSectionDTO, RecordSection, RecordSectionData, RecordTypeVO>
implements RecordSectionService {
    @Autowired
    private RecordSectionServiceLocal recordSectionService;

    public RecordSectionServiceSecurity() {
        super(RecordSection.class, Permission.SYSTEM_CONFIGURATION_VIEW, Permission.SYSTEM_CONFIGURATION_MANAGE);
    }

    public List<RecordSectionVO> list(RecordTypeVO recordTypeVO) throws FrameworkException {
        this.checkViewPermission();
        return this.recordSectionService.list(recordTypeVO);
    }

    public void move(Long l, boolean bl) throws FrameworkException {
        this.checkManagePermission();
        this.recordSectionService.move(l, bl);
    }

    protected RecordSectionServiceLocal getImplementation() {
        return this.recordSectionService;
    }
}

