/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import com.querydsl.core.types.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QProductMyRecordType;
import org.cyclos.entities.users.QProductRecordType;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.SystemRecord;
import org.cyclos.entities.users.SystemRecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserRecord;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.RecordCustomFieldServiceLocal;
import org.cyclos.impl.users.RecordServiceLocal;
import org.cyclos.impl.users.RecordTypeServiceLocal;
import org.cyclos.impl.users.UserStatusServiceLocal;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.records.RecordDTO;
import org.cyclos.model.users.records.RecordData;
import org.cyclos.model.users.records.RecordDataParams;
import org.cyclos.model.users.records.RecordQuery;
import org.cyclos.model.users.records.RecordSearchData;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.records.SharedRecordFieldsSearchData;
import org.cyclos.model.users.records.SystemRecordQuery;
import org.cyclos.model.users.records.TiledRecordsData;
import org.cyclos.model.users.records.UserRecordQuery;
import org.cyclos.model.users.recordtypes.RecordTypeCountVO;
import org.cyclos.model.users.recordtypes.RecordTypeResultsLayout;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.RecordService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class RecordServiceSecurity
extends CRUDServiceSecurity<RecordDTO, Record, RecordData, RecordDataParams>
implements RecordService {
    @Autowired
    private RecordServiceLocal recordService;
    @Autowired
    private RecordTypeServiceLocal recordTypeService;
    @Autowired
    private RecordCustomFieldServiceLocal recordCustomFieldService;
    @Autowired
    private UserStatusServiceLocal userStatusService;

    public RecordServiceSecurity() {
        super(Record.class);
    }

    @Override
    public boolean canPerformOperation(Record record, CRUDOperation cRUDOperation) {
        User user = null;
        if (record instanceof UserRecord) {
            user = ((UserRecord)record).getUser();
        }
        return this.canPerformOperation(record.getType(), user, cRUDOperation);
    }

    public <T extends RecordType> boolean canPerformOperation(T t, User user, CRUDOperation cRUDOperation) {
        boolean bl;
        boolean bl2;
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return true;
        }
        if (cRUDOperation == CRUDOperation.CREATE && t.getResultsLayout() == RecordTypeResultsLayout.SINGLE_FORM) {
            SystemRecord systemRecord = null;
            if (t instanceof SystemRecordType) {
                systemRecord = this.recordService.getSingleFormRecord((SystemRecordType)t);
            } else if (t instanceof UserRecordType) {
                systemRecord = this.recordService.getSingleFormRecord((UserRecordType)t, user);
            }
            if (systemRecord != null) {
                cRUDOperation = CRUDOperation.READ;
            }
        }
        if (bl2 = t instanceof SystemRecordType) {
            BooleanPropertiesHolder booleanPropertiesHolder = sessionData.getProducts().admin().getSystemRecordTypes();
            return this.hasRecordTypePermission(t, cRUDOperation, booleanPropertiesHolder);
        }
        if (user == null && !sessionData.isUserManager()) {
            return false;
        }
        boolean bl3 = bl = sessionData.isLoggedIn() ? sessionData.getLoggedUser().equals((Object)user) : false;
        if (user != null && (user.isRemoved() && cRUDOperation != CRUDOperation.READ || !sessionData.manages((BasicUser)user))) {
            return false;
        }
        BooleanPropertiesHolder booleanPropertiesHolder = this.productsHandler.getAccessor((BasicUser)(user == null ? sessionData.getLoggedUser() : user)).product().getMyRecordTypes();
        if (bl) {
            return this.hasRecordTypePermission(t, cRUDOperation, booleanPropertiesHolder);
        }
        BooleanPropertiesHolder booleanPropertiesHolder2 = sessionData.getProducts().userManagement().getUserRecordTypes();
        boolean bl4 = this.hasRecordTypePermission(t, cRUDOperation, booleanPropertiesHolder2);
        if (user == null || cRUDOperation == CRUDOperation.READ) {
            return bl4;
        }
        return bl4 && booleanPropertiesHolder.isSet(t, (Path)QProductMyRecordType.productMyRecordType.enabled);
    }

    @Override
    public boolean doHasManageAccess(Record record) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doHasViewAccess(Record record) {
        return this.canPerformOperation(record, CRUDOperation.READ);
    }

    public FileInfo exportRecords(@NotNull ExportFormatVO exportFormatVO, @NotNull RecordQuery recordQuery) {
        this.checkQuery(recordQuery);
        return this.recordService.exportRecords(exportFormatVO, recordQuery);
    }

    public List<RecordTypeCountVO> getRecordTypeCount(InternalAccountOwner internalAccountOwner) throws FrameworkException {
        this.checkLoggedIn();
        return this.recordService.getRecordTypeCount(internalAccountOwner);
    }

    public RecordSearchData getSearchData(RecordTypeVO recordTypeVO, UserLocatorVO userLocatorVO) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordTypeVO);
        this.checkView(recordTypeVO, (UserVO)userLocatorVO);
        RecordSearchData recordSearchData = this.recordService.getSearchData(recordTypeVO, userLocatorVO);
        recordSearchData.setCanCreateNew(this.canPerformOperation(recordType, user, CRUDOperation.CREATE));
        recordSearchData.setCanEdit(this.canPerformOperation(recordType, user, CRUDOperation.UPDATE));
        recordSearchData.setCanRemove(this.canPerformOperation(recordType, user, CRUDOperation.DELETE));
        return recordSearchData;
    }

    public SharedRecordFieldsSearchData getSharedFieldsSearchData() {
        this.checkSharedFieldsSearchPermissions();
        return this.recordService.getSharedFieldsSearchData();
    }

    public TiledRecordsData getTiledRecordsData(RecordTypeVO recordTypeVO, UserLocatorVO userLocatorVO) {
        User user = userLocatorVO == null ? null : this.userLocatorHandler.locate(userLocatorVO).getUser();
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordTypeVO);
        this.checkView(recordTypeVO, (UserVO)userLocatorVO);
        TiledRecordsData tiledRecordsData = this.recordService.getTiledRecordsData(recordTypeVO, userLocatorVO);
        tiledRecordsData.setCanCreateNew(this.canPerformOperation(recordType, user, CRUDOperation.CREATE));
        tiledRecordsData.setRemovable(this.canPerformOperation(recordType, user, CRUDOperation.DELETE));
        tiledRecordsData.setEditable(this.canPerformOperation(recordType, user, CRUDOperation.UPDATE));
        return tiledRecordsData;
    }

    @Override
    public boolean isAccessible(SessionData sessionData, Record record) {
        return true;
    }

    public RecordVO loadVO(Long l) throws FrameworkException {
        Record record = (Record)this.find(l);
        this.checkViewAccess(record);
        return this.recordService.loadVO(l);
    }

    public Page<RecordVO> search(RecordQuery recordQuery) throws QueryParseException {
        this.checkQuery(recordQuery);
        return this.recordService.search(recordQuery);
    }

    @Override
    protected void checkCreateNew(RecordDataParams recordDataParams) {
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordDataParams.getRecordType());
        User user = null;
        if (recordType instanceof UserRecordType) {
            user = (User)this.conversionHandler.convert(User.class, (Object)recordDataParams.getUser());
        }
        if (!this.canPerformOperation(recordType, user, CRUDOperation.CREATE)) {
            throw new PermissionDeniedException();
        }
    }

    protected void checkSharedFieldsSearchPermissions() {
        if (!this.isUserManager() || this.recordTypeService.listVisibleUserTypes().isEmpty() || this.recordCustomFieldService.listShared().isEmpty()) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected void customizeData(RecordData recordData) {
        Record record;
        RecordDTO recordDTO = (RecordDTO)recordData.getDto();
        if (recordDTO.isPersistent() && (record = (Record)this.find(recordDTO.getId())).getType().getResultsLayout() == RecordTypeResultsLayout.SINGLE_FORM) {
            recordData.setEditable(this.canPerformOperation(record, CRUDOperation.UPDATE));
        }
    }

    protected RecordServiceLocal getImplementation() {
        return this.recordService;
    }

    @Override
    protected void onBeforeSave(RecordDTO recordDTO, Record record) {
        if (recordDTO.isTransient()) {
            recordDTO.setCreatedBy(null);
            recordDTO.setCreationDate(null);
            recordDTO.setLastModifiedDate(null);
            recordDTO.setModifiedBy(null);
        }
    }

    private void checkQuery(RecordQuery recordQuery) {
        UserRecordQuery userRecordQuery;
        boolean bl;
        boolean bl2 = bl = recordQuery instanceof UserRecordQuery && ((UserRecordQuery)recordQuery).isSharedRecordFieldSearch();
        if (bl) {
            this.checkSharedFieldsSearchPermissions();
            userRecordQuery = (UserRecordQuery)recordQuery;
            userRecordQuery.setUserProfileFields(null);
        }
        if (recordQuery instanceof SystemRecordQuery) {
            userRecordQuery = (RecordType)this.checkView(recordQuery.getType(), null).getFirst();
            if (!(userRecordQuery instanceof SystemRecordType)) {
                throw new ValidationException();
            }
        } else if (recordQuery instanceof UserRecordQuery) {
            userRecordQuery = this.getSessionData();
            UserRecordQuery userRecordQuery2 = (UserRecordQuery)recordQuery;
            RecordType recordType = null;
            User user = null;
            if (!bl) {
                Pair<RecordType, User> pair = this.checkView(recordQuery.getType(), userRecordQuery2.getUser());
                recordType = (RecordType)pair.getFirst();
                user = (User)pair.getSecond();
            }
            if (recordType != null && !(recordType instanceof UserRecordType)) {
                throw new ValidationException();
            }
            if (user == null) {
                if (userRecordQuery.isUserManager()) {
                    boolean bl3 = userRecordQuery.isBroker();
                    if (bl3) {
                        userRecordQuery2.setBrokers(CollectionHelper.asSet((Object[])new UserVO[]{new UserVO(userRecordQuery.getLoggedUser().getId())}));
                    }
                    List list = this.userStatusService.getStatusesForUserSearch(bl3);
                    if (CollectionHelper.isNotEmpty((Iterable)userRecordQuery2.getUserStatuses())) {
                        Set set = PermissionHelper.applyAllowed((Collection)userRecordQuery2.getUserStatuses(), (Collection)list);
                        userRecordQuery2.setUserStatuses(new HashSet(set));
                    }
                    this.groupsHandler.visibles().accessibles().basic().check((Collection)userRecordQuery2.getGroups());
                } else {
                    user = userRecordQuery.getLoggedUser();
                    userRecordQuery2.setUser(new UserVO(userRecordQuery.getLoggedUser().getId()));
                    userRecordQuery2.setGroups(null);
                }
            } else {
                this.checkManagesUser((BasicUser)user);
                userRecordQuery2.setGroups(null);
            }
            if (CollectionHelper.isNotEmpty((Iterable)userRecordQuery2.getBrokers())) {
                for (List list : userRecordQuery2.getBrokers()) {
                    this.checkRelatesToUser((IUser)list);
                }
            }
        } else {
            throw new PermissionDeniedException();
        }
    }

    private Pair<RecordType, User> checkView(RecordTypeVO recordTypeVO, UserVO userVO) {
        User user;
        RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordTypeVO);
        if (!this.canPerformOperation(recordType, user = (User)this.conversionHandler.convert(User.class, (Object)userVO), CRUDOperation.READ)) {
            throw new PermissionDeniedException();
        }
        return Pair.create((Object)recordType, (Object)user);
    }

    private <T extends RecordType> boolean hasRecordTypePermission(T t, CRUDOperation cRUDOperation, BooleanPropertiesHolder<T> booleanPropertiesHolder) {
        if (cRUDOperation == CRUDOperation.READ) {
            return booleanPropertiesHolder.isSet(t, (Path)QProductRecordType.productRecordType.view);
        }
        if (cRUDOperation == CRUDOperation.UPDATE) {
            return booleanPropertiesHolder.isSet(t, (Path)QProductRecordType.productRecordType.edit);
        }
        if (cRUDOperation == CRUDOperation.CREATE) {
            return booleanPropertiesHolder.isSet(t, (Path)QProductRecordType.productRecordType.create);
        }
        if (cRUDOperation == CRUDOperation.DELETE) {
            return booleanPropertiesHolder.isSet(t, (Path)QProductRecordType.productRecordType.remove);
        }
        throw new IllegalArgumentException("Unsupported Operation: " + String.valueOf(cRUDOperation));
    }
}

