/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.NFCTokenPrincipalType;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.GroupList;
import org.cyclos.impl.users.GroupListViewFactory;
import org.cyclos.impl.users.GroupListViewFactoryAccessor;
import org.cyclos.impl.users.InternalBasicUserServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.model.access.tokens.NFCTagWithChallengeDTO;
import org.cyclos.model.system.configurations.ActiveConfigurationData;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.groups.InitialGroupVO;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.users.AbstractSimpleUserRegistrationDTO;
import org.cyclos.model.users.users.AbstractUserQuery;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserDTO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ProfileActionsData;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.PublicRegistrationDTO;
import org.cyclos.model.users.users.PublicRegistrationData;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserData;
import org.cyclos.model.users.users.UserDataParams;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.users.users.UserRegistrationByMemberDTO;
import org.cyclos.model.users.users.UserRegistrationDTO;
import org.cyclos.model.users.users.UserRegistrationResult;
import org.cyclos.model.users.users.UserSearchContext;
import org.cyclos.model.users.users.UserSearchData;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.users.users.UserWithFieldsVO;
import org.cyclos.model.users.users.UserWithRolesVO;
import org.cyclos.model.users.users.ValidateRegistrationFieldParams;
import org.cyclos.model.users.users.ViewProfileData;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.access.TokenServiceSecurity;
import org.cyclos.security.system.EntityLogServiceSecurity;
import org.cyclos.services.users.UserService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class UserServiceSecurity
extends CRUDServiceSecurity<UserDTO, User, UserData, UserDataParams>
implements UserService {
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private InternalBasicUserServiceLocal internalBasicUserService;
    @Autowired
    private TokenServiceSecurity tokenServiceSecurity;
    @Autowired
    private EntityLogServiceSecurity entityLogServiceSecurity;

    public UserServiceSecurity() {
        super(User.class);
    }

    public boolean canEditProfile(User user) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return true;
        }
        if (sessionData.isManagerOf((BasicUser)user)) {
            return sessionData.getProducts().userManagement().isEditUserProfile();
        }
        if (user.equals((Object)sessionData.getLoggedBasicUser())) {
            return sessionData.getProducts().product().isEditMyProfile();
        }
        return false;
    }

    @Override
    public boolean canPerformOperation(User user, CRUDOperation cRUDOperation) {
        switch (cRUDOperation) {
            case CREATE: {
                return false;
            }
            case DELETE: {
                return user.isPendingValidation() && this.hasPermission(Permission.PENDING_USERS_MANAGE);
            }
            case UPDATE: {
                return this.canEditProfile(user) && !user.isRemoved();
            }
        }
        return super.canPerformOperation(user, cRUDOperation);
    }

    public boolean canViewActiveConfiguration(User user) {
        if (user == null) {
            return false;
        }
        SessionData sessionData = this.getSessionData();
        return sessionData.manages((BasicUser)user) && (sessionData.hasPermission(Permission.USERS_ACTIVE_CONFIGURATION_AND_PRODUCTS) || sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW));
    }

    @Override
    public boolean canViewData(User user) {
        return this.doHasManageAccess(user);
    }

    public boolean canViewProfile(User user) {
        if (user == null) {
            return false;
        }
        SessionData sessionData = this.getSessionData();
        OidcAccessToken oidcAccessToken = sessionData.getAccessToken();
        if (oidcAccessToken != null) {
            OidcAuthorization oidcAuthorization = oidcAccessToken.getAuthorization();
            if (user.equals((Object)oidcAuthorization.getBasicUser())) {
                return oidcAuthorization.getScopes().contains(Scope.PROFILE_READ);
            }
            return false;
        }
        if (sessionData.manages((BasicUser)user)) {
            return true;
        }
        Set set = this.groupsHandler.getViewProfileOnGroups();
        Group group = user.getGroup();
        GroupSet groupSet = group instanceof UserGroup ? ((UserGroup)group).getGroupSet() : null;
        return set.contains(group) || set.contains(groupSet);
    }

    public boolean checkQuery(AbstractUserQuery abstractUserQuery) {
        boolean bl;
        Object object;
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        UserQuery userQuery = (UserQuery)ObjectHelper.ifType((Object)abstractUserQuery, UserQuery.class);
        boolean bl2 = sessionData.isBroker();
        User user = sessionData.getLoggedUser();
        Set set = this.conversionHandler.convertSet(User.class, (Iterable)abstractUserQuery.getBrokers());
        SearchMode searchMode = this.getSearchMode(userQuery);
        boolean bl3 = false;
        GroupList groupList = GroupList.USERS;
        switch (searchMode.ordinal()) {
            case 4: {
                bl3 = true;
                groupList = GroupList.MENU;
                break;
            }
            case 0: {
                bl3 = true;
                break;
            }
            case 2: {
                if (sessionData.isGuest()) break;
                if (userQuery.getContactsOwner() == null) {
                    userQuery.setContactsOwner(new UserLocatorVO(sessionData.getLoggedUser().getId()));
                }
                if (!userQuery.isExcludeContacts()) {
                    userQuery.setOnlyContacts(true);
                }
                if ((object = (User)this.conversionHandler.convert(User.class, (Object)userQuery.getContactsOwner())).isGlobal() && sessionData.getNetwork() != null) {
                    bl3 = false;
                    break;
                }
                if (!this.permission((BasicUser)object).my(new Permission[]{Permission.MY_CONTACTS_ENABLE}).user(new Permission[]{Permission.USER_CONTACTS_VIEW}).granted()) break;
                groupList = userQuery.isExcludeContacts() ? GroupList.USERS : GroupList.ACCESSIBLE;
                bl3 = true;
                break;
            }
            case 3: {
                groupList = GroupList.DIRECTORY;
                bl3 = configurationAccessor.isUseMap();
                break;
            }
            case 1: {
                groupList = GroupList.ACCESSIBLE;
                bl3 = sessionData.isBroker();
            }
        }
        if (!bl3 && bl2 && searchMode != SearchMode.CONTACTS) {
            searchMode = SearchMode.BROKERED;
            groupList = GroupList.ACCESSIBLE;
            abstractUserQuery.setBrokers(CollectionHelper.asSet((Object[])new UserVO[]{new UserVO(user.getId())}));
            bl3 = true;
        }
        if (!bl3) {
            throw new PermissionDeniedException();
        }
        if (CollectionHelper.isNotEmpty((Iterable)set)) {
            boolean bl4;
            boolean bl5 = bl4 = sessionData.isAdmin() || sessionData.isSystem();
            if (sessionData.isBroker()) {
                boolean bl6 = bl4 = set.size() == 1 && ((User)CollectionHelper.first((Iterable)set)).equals((Object)user);
            }
            if (!bl4) {
                throw new PermissionDeniedException();
            }
        }
        if (userQuery != null && (sessionData.isGuest() || !user.isGlobal())) {
            userQuery.setIncludeGlobal(false);
        }
        this.checkSelectedGroups(groupList, searchMode, abstractUserQuery.getGroups());
        this.checkIds(Product.class, EntityVO.ids((Iterable)abstractUserQuery.getProducts()));
        this.checkIds(User.class, EntityVO.ids((Iterable)abstractUserQuery.getUsersToExclude()));
        this.checkIds(User.class, EntityVO.ids((Iterable)abstractUserQuery.getUsersToInclude()));
        object = abstractUserQuery.getUserStatus();
        if (CollectionHelper.isNotEmpty((Iterable)object)) {
            if (!sessionData.hasPermission(Permission.PENDING_USERS_VIEW)) {
                object.remove(UserStatus.PENDING);
            }
            if (!sessionData.hasPermission(Permission.DISABLED_USERS_VIEW)) {
                object.remove(UserStatus.DISABLED);
            }
            if (!sessionData.hasPermission(Permission.REMOVED_USERS_VIEW)) {
                object.remove(UserStatus.REMOVED);
            }
            if (!sessionData.hasPermission(Permission.PURGED_USERS_VIEW)) {
                object.remove(UserStatus.PURGED);
            }
        }
        if (CollectionHelper.isEmpty((Iterable)object)) {
            abstractUserQuery.setUserStatus(EnumSet.of(UserStatus.ACTIVE, UserStatus.BLOCKED));
        }
        if (!configurationAccessor.isUseMap()) {
            abstractUserQuery.setDistance(null);
        }
        if (!(!CollectionHelper.isNotEmpty((Iterable)abstractUserQuery.getAcceptedAgreements()) && !CollectionHelper.isNotEmpty((Iterable)abstractUserQuery.getNotAcceptedAgreements()) || sessionData.hasPermission(Permission.USER_AGREEMENT_LOG_VIEW) && sessionData.isAdmin() && (sessionData.isBroker() || searchMode != SearchMode.BROKERED))) {
            abstractUserQuery.setAcceptedAgreements(null);
            abstractUserQuery.setNotAcceptedAgreements(null);
        }
        boolean bl7 = bl = (searchMode == SearchMode.GENERAL || searchMode == SearchMode.MENU) && sessionData.isAdmin() || searchMode == SearchMode.BROKERED;
        if (!bl) {
            abstractUserQuery.setActivated(null);
            abstractUserQuery.setCreated(null);
            abstractUserQuery.setBrokers(null);
            abstractUserQuery.setProducts(null);
            abstractUserQuery.setLastLogin(null);
            abstractUserQuery.setRoles(null);
            User user2 = (User)this.conversionHandler.convert(User.class, (Object)abstractUserQuery.getInvitedBy());
            if (user2 != null && !user2.equals((Object)sessionData.getLoggedUser())) {
                abstractUserQuery.setInvitedBy(null);
            }
        }
        return true;
    }

    @Override
    public boolean doHasManageAccess(User user) {
        return !user.isRemoved() && this.canManage((BasicUser)user);
    }

    @Override
    public boolean doHasViewAccess(User user) {
        return this.isRelatedToUser((BasicUser)user);
    }

    public FileInfo exportUsers(ExportFormatVO exportFormatVO, UserQuery userQuery) throws FrameworkException {
        this.checkQuery((AbstractUserQuery)userQuery);
        SearchMode searchMode = this.getSearchMode(userQuery);
        SessionData sessionData = this.getSessionData();
        if (searchMode != SearchMode.BROKERED && !sessionData.isAdmin() && !sessionData.isSystem()) {
            throw new PermissionDeniedException();
        }
        return this.userService.exportUsers(exportFormatVO, userQuery);
    }

    public ActiveConfigurationData getActiveConfiguration(UserLocatorVO userLocatorVO) throws EntityNotFoundException {
        this.checkViewActiveConfiguration(userLocatorVO);
        return this.userService.getActiveConfiguration(userLocatorVO);
    }

    public UserWithRolesVO getCurrentUser() throws FrameworkException {
        return this.userService.getCurrentUser();
    }

    public PublicRegistrationData getPublicRegistrationData(InitialGroupVO initialGroupVO, String string, String string2) throws FrameworkException {
        this.checkGuest();
        this.checkBuiltInRegistrationEnabled();
        GroupVO groupVO = new GroupVO();
        groupVO.setId(initialGroupVO.getId());
        groupVO.setInternalName(initialGroupVO.getInternalName());
        this.validateRegistrationGroup((Group)this.conversionHandler.convert(Group.class, (Object)groupVO), false);
        return this.userService.getPublicRegistrationData(initialGroupVO, string, string2);
    }

    public List<InitialGroupVO> getPublicRegistrationGroups() throws FrameworkException {
        this.checkGuest();
        this.checkBuiltInRegistrationEnabled();
        return this.userService.getPublicRegistrationGroups();
    }

    public UserSearchData getSearchData(UserSearchContext userSearchContext, UserLocatorVO userLocatorVO) throws FrameworkException {
        boolean bl;
        if (userSearchContext == UserSearchContext.PENDING) {
            this.checkPermission(Permission.PENDING_USERS_VIEW);
        } else if (userSearchContext == UserSearchContext.BROKERED) {
            SessionData sessionData = this.getSessionData();
            User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
            if (!sessionData.isAdmin() && !sessionData.isBroker()) {
                throw new PermissionDeniedException();
            }
            this.checkManagesUser((BasicUser)user);
        } else if (userSearchContext == UserSearchContext.MAP_DIRECTORY && !(bl = this.getConfiguration().isUseMap())) {
            throw new PermissionDeniedException();
        }
        return this.userService.getSearchData(userSearchContext, userLocatorVO);
    }

    public List<InitialGroupVO> getUserRegistrationGroups(boolean bl) throws FrameworkException {
        this.checkLoggedIn();
        return this.userService.getUserRegistrationGroups(bl);
    }

    public ViewProfileData getViewProfileData(UserLocatorVO userLocatorVO) {
        User user = userLocatorVO == null ? this.getLoggedUser() : this.userLocatorHandler.locate(userLocatorVO).getUser();
        if (!this.canViewProfile(user)) {
            throw new PermissionDeniedException();
        }
        ViewProfileData viewProfileData = this.userService.getViewProfileData(userLocatorVO);
        viewProfileData.setCanEditProfile(this.canEditProfile(user));
        ProfileActionsData profileActionsData = viewProfileData.getActions();
        if (profileActionsData != null) {
            profileActionsData.setViewHistoryLog(profileActionsData.isViewHistoryLog() && this.entityLogServiceSecurity.canViewEntityLog((SimpleEntity)user));
        }
        return viewProfileData;
    }

    @Override
    public boolean isAccessible(SessionData sessionData, User user) {
        if (sessionData.getChannel().isPos() && sessionData.isLoggedIn() && this.authHandler.relatesTo((BasicUser)user, (BasicUser)sessionData.getLoggedUser())) {
            return true;
        }
        return sessionData.relatesTo((BasicUser)user);
    }

    public UserVO locate(UserLocatorVO userLocatorVO) throws FrameworkException {
        return this.userService.locate(userLocatorVO);
    }

    public UserRegistrationResult publicRegister(PublicRegistrationDTO publicRegistrationDTO) throws FrameworkException {
        this.checkBuiltInRegistrationEnabled();
        this.checkDTO((AbstractSimpleUserRegistrationDTO)publicRegistrationDTO, () -> !this.getSessionData().isLoggedIn());
        return this.userService.publicRegister(publicRegistrationDTO);
    }

    public UserRegistrationResult register(UserRegistrationDTO userRegistrationDTO) throws ValidationException, PasswordException {
        this.checkDTO((AbstractSimpleUserRegistrationDTO)userRegistrationDTO, () -> this.hasPermission(Permission.USERS_REGISTER));
        return this.userService.register(userRegistrationDTO);
    }

    public UserRegistrationResult registerByMember(UserRegistrationByMemberDTO userRegistrationByMemberDTO) throws FrameworkException {
        this.checkDTO((AbstractSimpleUserRegistrationDTO)userRegistrationByMemberDTO, () -> this.hasPermission(Permission.USERS_REGISTER));
        if (this.getSessionData().isAdmin()) {
            throw new ValidationException("You cannot register a user passing asMember=true when logged in as administrator");
        }
        return this.userService.registerByMember(userRegistrationByMemberDTO);
    }

    public Page<UserWithFieldsVO> search(UserQuery userQuery) throws QueryParseException {
        if (!this.checkQuery((AbstractUserQuery)userQuery)) {
            return PageImpl.empty();
        }
        return this.userService.search(userQuery);
    }

    public String validateRegistrationField(ValidateRegistrationFieldParams validateRegistrationFieldParams) throws FrameworkException {
        Group group = (Group)this.conversionHandler.convert(Group.class, (Object)validateRegistrationFieldParams.getGroup());
        this.validateRegistrationGroup(group, validateRegistrationFieldParams.isAsMember());
        return this.userService.validateRegistrationField(validateRegistrationFieldParams);
    }

    @Override
    protected void checkCreateNew(UserDataParams userDataParams) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isGuest()) {
            this.checkBuiltInRegistrationEnabled();
        }
        Group group = (Group)this.conversionHandler.convert(Group.class, (Object)userDataParams.getGroup());
        this.validateRegistrationGroup(group, userDataParams.isAsMember());
        User user = (User)this.conversionHandler.convert(User.class, (Object)userDataParams.getBroker());
        if (!(user == null || sessionData.isAdminOf((BasicUser)user) && sessionData.hasPermission(Permission.USER_BROKER_MANAGE))) {
            throw new PermissionDeniedException();
        }
    }

    protected UserServiceLocal getImplementation() {
        return this.userService;
    }

    @Override
    protected void onBeforeSave(UserDTO userDTO, User user) {
        this.internalBasicUserService.applyPermissionsToBasicFields((BasicUserDTO)userDTO, (BasicUser)user);
    }

    private void checkBuiltInRegistrationEnabled() {
        if (!this.userService.isBuiltinRegistrationEnabled()) {
            throw new IllegalActionException("The built-in registration form is disabled. Use a registration wizard instead.");
        }
    }

    private void checkDTO(AbstractSimpleUserRegistrationDTO abstractSimpleUserRegistrationDTO, Supplier<Boolean> supplier) {
        if (!supplier.get().booleanValue()) {
            throw new PermissionDeniedException();
        }
        this.checkRegistration(abstractSimpleUserRegistrationDTO);
    }

    private void checkNfcPersonalizationAtRegistration(AbstractSimpleUserRegistrationDTO abstractSimpleUserRegistrationDTO, boolean bl, Group group) {
        NFCTagWithChallengeDTO nFCTagWithChallengeDTO = abstractSimpleUserRegistrationDTO.getNfcToken();
        if (nFCTagWithChallengeDTO == null) {
            return;
        }
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)nFCTagWithChallengeDTO.getTokenType());
        if (group instanceof UserGroup && !this.tokenServiceSecurity.hasPermissionToPersonalizeAtRegistration((UserGroup)group, nFCTokenPrincipalType, bl)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkRegistration(AbstractSimpleUserRegistrationDTO abstractSimpleUserRegistrationDTO) {
        UserRegistrationDTO userRegistrationDTO;
        Group group = (Group)this.conversionHandler.convert(Group.class, (Object)abstractSimpleUserRegistrationDTO.getGroup());
        if (group != null) {
            boolean bl = abstractSimpleUserRegistrationDTO instanceof UserRegistrationByMemberDTO;
            this.validateRegistrationGroup(group, bl);
            userRegistrationDTO = new User(group);
            this.internalBasicUserService.applyPermissionsToBasicFields((BasicUserDTO)abstractSimpleUserRegistrationDTO, (BasicUser)userRegistrationDTO);
            this.checkRegistrationFields(abstractSimpleUserRegistrationDTO, (User)userRegistrationDTO);
            if (abstractSimpleUserRegistrationDTO instanceof PublicRegistrationDTO && abstractSimpleUserRegistrationDTO.getMobilePhones() != null) {
                for (MobilePhoneDTO mobilePhoneDTO : abstractSimpleUserRegistrationDTO.getMobilePhones()) {
                    mobilePhoneDTO.setEnabledForSms(false);
                    mobilePhoneDTO.setVerified(false);
                    mobilePhoneDTO.setVerificationCodeSendDate(null);
                }
            }
            this.checkNfcPersonalizationAtRegistration(abstractSimpleUserRegistrationDTO, bl, group);
        }
        if (abstractSimpleUserRegistrationDTO instanceof UserRegistrationDTO) {
            SessionData sessionData = this.getSessionData();
            userRegistrationDTO = (UserRegistrationDTO)abstractSimpleUserRegistrationDTO;
            User user = (User)this.conversionHandler.convert(User.class, (Object)userRegistrationDTO.getBroker());
            if (user != null && (sessionData.isAdmin() ? !sessionData.isAdminOf((BasicUser)user) || !sessionData.hasPermission(Permission.USER_BROKER_MANAGE) : !sessionData.isBroker() || !user.equals((Object)sessionData.getLoggedUser()))) {
                throw new PermissionDeniedException();
            }
        }
    }

    private void checkRegistrationFields(AbstractSimpleUserRegistrationDTO abstractSimpleUserRegistrationDTO, User user) {
        if (!this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.PHONE, ProfileFieldAction.EDIT)) {
            abstractSimpleUserRegistrationDTO.setMobilePhones(null);
            abstractSimpleUserRegistrationDTO.setLandLinePhones(null);
        }
        if (!this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.ADDRESS, ProfileFieldAction.EDIT)) {
            abstractSimpleUserRegistrationDTO.setAddresses(null);
        }
        if (!this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.IMAGE, ProfileFieldAction.EDIT)) {
            abstractSimpleUserRegistrationDTO.setUploadedImages(null);
        }
    }

    private void checkSelectedGroups(GroupList groupList, SearchMode searchMode, Set<BasicGroupVO> set) {
        GroupListViewFactoryAccessor groupListViewFactoryAccessor = this.groupsHandler.visibles();
        GroupListViewFactory groupListViewFactory = null;
        switch (groupList) {
            case ACCESSIBLE: {
                groupListViewFactory = groupListViewFactoryAccessor.accessibles();
                break;
            }
            case ADS: {
                break;
            }
            case DIRECTORY: {
                groupListViewFactory = groupListViewFactoryAccessor.directory();
                break;
            }
            case USERS: {
                groupListViewFactory = groupListViewFactoryAccessor.users();
                break;
            }
            case MENU: {
                groupListViewFactory = groupListViewFactoryAccessor.menu();
            }
        }
        if (groupListViewFactory == null) {
            throw new IllegalArgumentException("Unknown group list: " + String.valueOf(groupList));
        }
        groupListViewFactory.basic().check(set);
    }

    private void checkViewActiveConfiguration(UserLocatorVO userLocatorVO) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        if (!this.canViewActiveConfiguration(user)) {
            throw new PermissionDeniedException();
        }
    }

    private SearchMode getSearchMode(UserQuery userQuery) {
        SearchMode searchMode;
        if (userQuery != null && userQuery.isMapDirectory()) {
            searchMode = SearchMode.DIRECTORY;
        } else if (userQuery != null && userQuery.isFromMenu()) {
            searchMode = SearchMode.MENU;
        } else if (userQuery != null && (userQuery.isOnlyContacts() || userQuery.isExcludeContacts() || userQuery.getContactsOwner() != null)) {
            searchMode = SearchMode.CONTACTS;
        } else {
            Set set = userQuery == null ? null : this.conversionHandler.convertSet(User.class, (Iterable)userQuery.getBrokers());
            searchMode = CollectionHelper.size(set) == 1 && set.contains(this.getLoggedUser()) ? SearchMode.BROKERED : SearchMode.GENERAL;
        }
        return searchMode;
    }

    private boolean isGroupAllowedForRegistration(Group group, boolean bl) {
        Collection collection = this.isGuest() ? this.getConfiguration().getPossibleInitialGroups() : this.groupsHandler.getPossibleRegistrationGroups(false, bl);
        return collection.contains(group);
    }

    private void validateRegistrationGroup(Group group, boolean bl) {
        if (!this.isGroupAllowedForRegistration(group, bl)) {
            throw new EntityNotFoundException(Group.class);
        }
    }

    private static enum SearchMode {
        GENERAL,
        BROKERED,
        CONTACTS,
        DIRECTORY,
        MENU;

    }
}

