/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import com.mysema.commons.lang.CloseableIterator;
import java.util.IdentityHashMap;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.utils.persistence.CacheFlusher;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.utils.HasPartialData;

class CacheFlusherImpl
implements CacheFlusher {
    public static final int FLUSH_EVERY = 20;
    private final InvocationContext invocationContext;
    private final EntityManager entityManager;
    private final Consumer<CacheFlusher> onClose;
    private final IdentityHashMap<SimpleEntity, SimpleEntity> loadedEntities = new IdentityHashMap();
    private int counter;

    CacheFlusherImpl(InvocationContext invocationContext, Consumer<CacheFlusher> consumer) {
        this.invocationContext = invocationContext;
        this.onClose = consumer;
        this.entityManager = invocationContext.getEntityManager();
    }

    @Override
    public void addLoaded(SimpleEntity simpleEntity) {
        this.loadedEntities.put(simpleEntity, simpleEntity);
    }

    @Override
    public void close() {
        this.doFlush();
        this.onClose.accept(this);
    }

    @Override
    public boolean flush() {
        boolean bl;
        boolean bl2 = bl = ++this.counter == 20;
        if (bl) {
            this.doFlush();
            this.counter = 0;
        }
        return bl;
    }

    @Override
    public <T> DataIterator<T> wrap(final CloseableIterator<T> closeableIterator) {
        return new DataIterator<T>(){

            public void close() {
                CacheFlusherImpl.this.close();
                closeableIterator.close();
            }

            public boolean hasNext() {
                return closeableIterator.hasNext();
            }

            public boolean isPartialData() {
                if (closeableIterator instanceof HasPartialData) {
                    return ((HasPartialData)closeableIterator).isPartialData();
                }
                return false;
            }

            public T next() {
                CacheFlusherImpl.this.flush();
                return closeableIterator.next();
            }
        };
    }

    private void doFlush() {
        if (this.invocationContext.getTransactionLevel() == TransactionLevel.READ_WRITE) {
            this.entityManager.flush();
        }
        this.loadedEntities.keySet().stream().filter(arg_0 -> ((EntityManager)this.entityManager).contains(arg_0)).forEach(arg_0 -> ((EntityManager)this.entityManager).detach(arg_0));
        this.loadedEntities.clear();
    }
}

