/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.CacheFlusherImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.locks.LockKey;
import org.cyclos.impl.storage.StoredFileContentAction;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheOperation;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.CacheFlusher;
import org.cyclos.impl.utils.tasks.RecurringTask;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.TransactionStatus;

public final class InvocationContext {
    private static final Comparator<CacheType<?, ?>> CACHE_TYPE_COMPARATOR = new CacheTypeComparator();
    private static final ThreadLocal<InvocationContext> CURRENT = new ThreadLocal();
    private static final Logger LOG = LogManager.getLogger(InvocationContext.class);
    private final SessionData sessionData;
    private final ApplicationContext applicationContext;
    private ConversionContext conversionContext;
    private EntityManager entityManager;
    private TransactionStatus transactionStatus;
    private TransactionLevel transactionLevel;
    private boolean write;
    private Set<LockKey> acquiredLocks;
    private TreeMap<CacheType<?, ?>, CacheOperation> cacheOperations;
    private Set<RecurringTask> recurringTasksToAwake;
    private List<Runnable> beforeEndListeners;
    private List<TransactionEndListener> endListeners;
    private Map<Object, Object> attributes;
    private Stack<CacheFlusher> cacheFlushers;
    private StoredFileContentAction lastContentAction;

    public static <T> T bean(Class<T> clazz) {
        return (T)InvocationContext.getApplicationContext().getBean(clazz);
    }

    public static InvocationContext ensure() {
        InvocationContext invocationContext = InvocationContext.get();
        if (invocationContext == null) {
            throw new IllegalStateException("No context set for current invocation");
        }
        return invocationContext;
    }

    public static InvocationContext get() {
        return CURRENT.get();
    }

    public static ApplicationContext getApplicationContext() {
        return InvocationContext.ensure().applicationContext;
    }

    public static ConversionContext getConversionContext() {
        return InvocationContext.getConversionContext(true);
    }

    public static CacheFlusher getCurrentCacheFlusher() {
        InvocationContext invocationContext = InvocationContext.get();
        Stack<CacheFlusher> stack = invocationContext == null ? null : invocationContext.cacheFlushers;
        return CollectionHelper.isEmpty(stack) ? null : stack.peek();
    }

    public static FormatterImpl getFormatter(ConfigurationAccessor configurationAccessor) {
        return InvocationContext.ensure().formatter(configurationAccessor);
    }

    public static SessionData getSessionData() {
        return InvocationContext.ensure().sessionData;
    }

    public static InvocationContext init(SessionData sessionData, ApplicationContext applicationContext) {
        InvocationContext invocationContext = new InvocationContext(sessionData, applicationContext);
        InvocationContext.set(invocationContext);
        return invocationContext;
    }

    public static void markWrite() {
        InvocationContext.ensure().write = true;
    }

    public static InvocationContext nested(SessionData sessionData, InvocationContext invocationContext) {
        InvocationContext invocationContext2 = new InvocationContext(sessionData, invocationContext);
        InvocationContext.set(invocationContext2);
        return invocationContext2;
    }

    public static CacheFlusher newCacheFlusher() {
        InvocationContext invocationContext = InvocationContext.ensure();
        if (invocationContext.cacheFlushers == null) {
            invocationContext.cacheFlushers = new Stack();
        }
        CacheFlusherImpl cacheFlusherImpl = new CacheFlusherImpl(invocationContext, cacheFlusher -> invocationContext.cacheFlushers.remove(cacheFlusher));
        invocationContext.cacheFlushers.push(cacheFlusherImpl);
        return cacheFlusherImpl;
    }

    public static void remove() {
        CURRENT.remove();
    }

    public static void set(InvocationContext invocationContext) {
        if (invocationContext == null) {
            CURRENT.remove();
        } else {
            CURRENT.set(invocationContext);
        }
    }

    public static BeanWrapper wrap(Object object) {
        ConversionContext conversionContext = InvocationContext.getConversionContext(false);
        return conversionContext.wrap(object);
    }

    private static ConversionContext getConversionContext(boolean bl) {
        InvocationContext invocationContext = InvocationContext.ensure();
        if (invocationContext.conversionContext == null) {
            invocationContext.conversionContext = new ConversionContext(invocationContext);
        } else if (bl) {
            invocationContext.conversionContext.processedObjects = null;
        }
        return invocationContext.conversionContext;
    }

    private InvocationContext(SessionData sessionData, ApplicationContext applicationContext) {
        this.sessionData = sessionData;
        this.applicationContext = applicationContext;
    }

    private InvocationContext(SessionData sessionData, InvocationContext invocationContext) {
        this.sessionData = sessionData;
        this.applicationContext = invocationContext.applicationContext;
        this.entityManager = invocationContext.entityManager;
        this.transactionLevel = invocationContext.transactionLevel;
        this.transactionStatus = invocationContext.transactionStatus;
    }

    public void addBeforeEndListener(Runnable runnable) {
        if (this.beforeEndListeners == null) {
            this.beforeEndListeners = new ArrayList<Runnable>();
        }
        this.beforeEndListeners.add(runnable);
    }

    public void addCommitListener(boolean bl2, boolean bl3, Runnable runnable) {
        this.addEndListener(TransactionEndType.COMMIT, bl2, bl3, bl -> runnable.run());
    }

    public void addCommitListener(boolean bl, Runnable runnable) {
        this.addCommitListener(bl, false, runnable);
    }

    public void addRollbackListener(boolean bl2, boolean bl3, Runnable runnable) {
        this.addEndListener(TransactionEndType.ROLLBACK, bl2, bl3, bl -> runnable.run());
    }

    public void addRollbackListener(boolean bl, Runnable runnable) {
        this.addRollbackListener(bl, false, runnable);
    }

    public void addTransactionEndListener(boolean bl, boolean bl2, Consumer<Boolean> consumer) {
        this.addEndListener(TransactionEndType.END, bl, bl2, consumer);
    }

    public void addTransactionEndListener(boolean bl, Consumer<Boolean> consumer) {
        this.addTransactionEndListener(bl, false, consumer);
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void awakeRecurringTask(RecurringTask recurringTask) {
        if (this.recurringTasksToAwake == null) {
            this.recurringTasksToAwake = new HashSet<RecurringTask>();
        }
        this.recurringTasksToAwake.add(recurringTask);
    }

    public void clearCache(CacheType<?, ?> cacheType) {
        this.addCacheOperation(cacheType, new CacheOperation());
    }

    public void delegateAcquiredResources(InvocationContext invocationContext) {
        if (this.acquiredLocks != null) {
            if (invocationContext.acquiredLocks == null) {
                invocationContext.acquiredLocks = this.acquiredLocks;
            } else {
                invocationContext.acquiredLocks.addAll(this.acquiredLocks);
            }
            this.acquiredLocks = null;
        }
        if (this.cacheOperations != null) {
            if (invocationContext.cacheOperations == null) {
                invocationContext.cacheOperations = this.cacheOperations;
            } else {
                for (Map.Entry<CacheType<?, ?>, CacheOperation> entry : this.cacheOperations.entrySet()) {
                    this.addCacheOperation(invocationContext.cacheOperations, entry.getKey(), entry.getValue());
                }
            }
            this.cacheOperations = null;
        }
        if (this.recurringTasksToAwake != null) {
            if (invocationContext.recurringTasksToAwake == null) {
                invocationContext.recurringTasksToAwake = this.recurringTasksToAwake;
            } else {
                invocationContext.recurringTasksToAwake.addAll(this.recurringTasksToAwake);
            }
            this.recurringTasksToAwake = null;
        }
        if (this.beforeEndListeners != null) {
            if (invocationContext.beforeEndListeners == null) {
                invocationContext.beforeEndListeners = this.beforeEndListeners;
            } else {
                invocationContext.beforeEndListeners.addAll(this.beforeEndListeners);
            }
            this.beforeEndListeners = null;
        }
        if (this.endListeners != null) {
            if (invocationContext.endListeners == null) {
                invocationContext.endListeners = this.endListeners;
            } else {
                invocationContext.endListeners.addAll(this.endListeners);
            }
            this.endListeners = null;
        }
        if (this.write) {
            invocationContext.write = true;
            this.write = false;
        }
        if (this.transactionLevel != null) {
            invocationContext.transactionLevel = this.transactionLevel;
            this.transactionLevel = null;
        }
        if (this.transactionStatus != null) {
            invocationContext.transactionStatus = this.transactionStatus;
            this.transactionStatus = null;
        }
        if (this.attributes != null) {
            if (invocationContext.attributes == null) {
                invocationContext.attributes = this.attributes;
            } else {
                invocationContext.attributes.putAll(this.attributes);
            }
            this.attributes = null;
        }
        invocationContext.lastContentAction = this.lastContentAction;
        this.lastContentAction = null;
    }

    public <K extends Serializable> void evictCacheKeyPredicate(CacheType<K, ?> cacheType, SerializablePredicate<K> serializablePredicate) {
        this.addCacheOperation(cacheType, new CacheOperation(serializablePredicate));
    }

    public void evictCacheKeys(CacheType<?, ?> cacheType, Set<? extends Serializable> set) {
        this.addCacheOperation(cacheType, new CacheOperation(set));
    }

    public FormatterImpl formatter(ConfigurationAccessor configurationAccessor) {
        ConfigurationAccessor configurationAccessor2 = (ConfigurationAccessor)ObjectHelper.defaultValue((Object)configurationAccessor, (Object)this.sessionData.getConfiguration());
        FormatterKey formatterKey = new FormatterKey(configurationAccessor2);
        return this.getAttribute(formatterKey, () -> {
            BeanHandler beanHandler = (BeanHandler)this.applicationContext.getBean(BeanHandler.class);
            FormatterImpl formatterImpl = new FormatterImpl(configurationAccessor2);
            return (FormatterImpl)((Object)((Object)beanHandler.autowire((Object)formatterImpl)));
        });
    }

    public <T> T getAttribute(Object object) {
        if (this.attributes == null) {
            return null;
        }
        Object object2 = this.attributes.get(object);
        if (object2 instanceof SimpleEntity && ((SimpleEntity)object2).isPersistent() && this.entityManager != null && !this.entityManager.contains(object2)) {
            object2 = this.entityManager.find(object2.getClass(), (Object)((SimpleEntity)object2).getId());
        }
        return (T)object2;
    }

    public <T> T getAttribute(Object object, Supplier<T> supplier) {
        T t = this.getAttribute(object);
        if (t == null) {
            t = supplier.get();
            this.setAttribute(object, t);
        }
        return t;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public StoredFileContentAction getLastStoredFileContentAction() {
        return this.lastContentAction;
    }

    public TransactionLevel getTransactionLevel() {
        return this.transactionLevel;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public boolean hasLock(LockKey lockKey) {
        return this.acquiredLocks != null && this.acquiredLocks.contains(lockKey);
    }

    public boolean hasWrite() {
        return this.write;
    }

    public boolean isEvicted(CacheType<?, ?> cacheType, Serializable serializable) {
        if (this.cacheOperations != null) {
            CacheOperation cacheOperation = this.cacheOperations.get(cacheType);
            return cacheOperation != null && cacheOperation.isForKey(serializable);
        }
        return false;
    }

    public void registerLock(LockKey lockKey) {
        if (this.acquiredLocks == null) {
            this.acquiredLocks = new HashSet<LockKey>();
        }
        this.acquiredLocks.add(lockKey);
        LOG.debug("Lock acquired: {}", (Object)lockKey);
    }

    public void releaseAfterTransaction(Boolean bl) {
        this.conversionContext = null;
        if (Boolean.TRUE.equals(bl) && this.cacheOperations != null) {
            CacheHandler cacheHandler = (CacheHandler)this.applicationContext.getBean(CacheHandler.class);
            try {
                cacheHandler.apply(this.cacheOperations);
            }
            catch (Exception exception) {
                LOG.warn("Error while executing cache operation", (Throwable)exception);
            }
        }
        this.cacheOperations = null;
        this.notifyEndListeners(bl, false);
        this.awakeRegisteredRecurringTasks();
        this.notifyEndListeners(bl, true);
        this.endListeners = null;
        this.attributes = null;
        this.lastContentAction = null;
    }

    public void releaseWithinTransaction() {
        while (this.beforeEndListeners != null) {
            List<Runnable> list = this.beforeEndListeners;
            this.beforeEndListeners = null;
            list.forEach(Runnable::run);
        }
    }

    public void releaseWithoutTransaction() {
        this.awakeRegisteredRecurringTasks();
    }

    public void runCommitListeners() {
        if (((CyclosProperties)this.applicationContext.getBean(CyclosProperties.class)).isTestingEnv()) {
            this.notifyEndListeners(true, false);
            this.notifyEndListeners(true, true);
            this.endListeners = null;
        }
    }

    public SessionData sessionData() {
        return this.sessionData;
    }

    public void setAttribute(Object object, Object object2) {
        if (object2 == null) {
            if (this.attributes != null) {
                this.attributes.remove(object);
            }
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>();
        }
        this.attributes.put(object, object2);
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setLastStoredFileContentAction(StoredFileContentAction storedFileContentAction) {
        this.lastContentAction = storedFileContentAction;
    }

    public void setTransactionLevel(TransactionLevel transactionLevel) {
        this.transactionLevel = transactionLevel;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    private void addCacheOperation(CacheType<?, ?> cacheType, CacheOperation cacheOperation) {
        if (this.transactionLevel != TransactionLevel.READ_WRITE) {
            throw new IllegalActionException("Cache operations are only supported in read-write transactions");
        }
        if (this.cacheOperations == null) {
            this.cacheOperations = new TreeMap(CACHE_TYPE_COMPARATOR);
        }
        this.addCacheOperation(this.cacheOperations, cacheType, cacheOperation);
    }

    private void addCacheOperation(Map<CacheType<?, ?>, CacheOperation> map, CacheType<?, ?> cacheType, CacheOperation cacheOperation) {
        CacheOperation cacheOperation2 = map.get(cacheType);
        if (cacheOperation2 == null) {
            map.put(cacheType, cacheOperation);
        } else {
            cacheOperation2.merge(cacheOperation);
        }
    }

    private void addEndListener(TransactionEndType transactionEndType, boolean bl, boolean bl2, Consumer<Boolean> consumer) {
        if (transactionEndType != TransactionEndType.END && this.transactionLevel != TransactionLevel.READ_WRITE && !((CyclosProperties)this.applicationContext.getBean(CyclosProperties.class)).isTestingEnv()) {
            throw new IllegalActionException("Transaction listeners of type " + String.valueOf((Object)transactionEndType) + " are only supported in read-write transactions");
        }
        if (this.endListeners == null) {
            this.endListeners = new ArrayList<TransactionEndListener>();
        }
        this.endListeners.add(new TransactionEndListener(transactionEndType, bl, bl2, consumer, this.sessionData));
    }

    private void awakeRegisteredRecurringTasks() {
        if (CollectionHelper.isNotEmpty(this.recurringTasksToAwake)) {
            ClusterHandler clusterHandler = (ClusterHandler)this.applicationContext.getBean(ClusterHandler.class);
            clusterHandler.awakeRecurringTasks(this.recurringTasksToAwake);
        }
        this.recurringTasksToAwake = null;
    }

    private void notifyEndListeners(Boolean bl, boolean bl2) {
        List list;
        List list2 = list = this.endListeners == null ? null : this.endListeners.stream().filter(transactionEndListener -> transactionEndListener.type == TransactionEndType.END || Boolean.TRUE.equals(bl) && transactionEndListener.type == TransactionEndType.COMMIT || Boolean.FALSE.equals(bl) && transactionEndListener.type == TransactionEndType.ROLLBACK).collect(Collectors.toList());
        if (CollectionHelper.isEmpty(list)) {
            return;
        }
        Consumer<TransactionEndListener> consumer = transactionEndListener -> {
            try {
                Consumer<Boolean> consumer = transactionEndListener.callback;
                InvokerHandler invokerHandler = (InvokerHandler)this.applicationContext.getBean(InvokerHandler.class);
                if (transactionEndListener.requiresTransaction) {
                    invokerHandler.runAsInTransaction(transactionEndListener.sessionData, TransactionLevel.READ_WRITE, transactionStatus -> {
                        consumer.accept(bl);
                        return null;
                    });
                } else {
                    invokerHandler.runAs(transactionEndListener.sessionData, () -> {
                        consumer.accept(bl);
                        return null;
                    });
                }
            }
            catch (Exception exception) {
                String string = bl == null ? "end" : (bl != false ? "commit" : "rollback");
                LOG.warn("Error while running " + string + " listener", (Throwable)exception);
            }
        };
        list.stream().filter(transactionEndListener -> transactionEndListener.afterAwakingRecurringTasks == bl2).forEach(consumer);
    }

    public static class ConversionContext {
        private final InvocationContext invocationContext;
        private IdentityHashMap<Object, BeanWrapper> beanWrappers;
        private IdentityHashMap<Object, Map<Class<?>, Pair<Object, Set<String>>>> processedObjects;

        public ConversionContext(InvocationContext invocationContext) {
            this.invocationContext = invocationContext;
        }

        public InvocationContext getInvocationContext() {
            return this.invocationContext;
        }

        public Object getProcessed(Object object, Class<?> clazz, Object[] objectArray) {
            if (this.processedObjects == null) {
                return null;
            }
            Map<Class<?>, Pair<Object, Set<String>>> map = this.processedObjects.get(object);
            if (map == null) {
                return null;
            }
            Pair<Object, Set<String>> pair = map.get(clazz);
            if (pair == null || !Objects.equals(this.toSetOfNames(objectArray), pair.getSecond())) {
                return null;
            }
            return pair.getFirst();
        }

        public SessionData getSessionData() {
            return this.invocationContext.sessionData;
        }

        public void registerProcessed(Object object, Object object2, Object[] objectArray) {
            Map<Class<?>, Pair<Object, Set<String>>> map;
            if (this.processedObjects == null) {
                this.processedObjects = new IdentityHashMap();
            }
            if ((map = this.processedObjects.get(object)) == null) {
                map = new HashMap();
                this.processedObjects.put(object, map);
            }
            map.put(object2.getClass(), (Pair<Object, Set<String>>)Pair.create((Object)object2, this.toSetOfNames(objectArray)));
        }

        public BeanWrapper wrap(Object object) {
            BeanWrapper beanWrapper;
            if (this.beanWrappers == null) {
                this.beanWrappers = new IdentityHashMap();
            }
            if ((beanWrapper = this.beanWrappers.get(object)) == null) {
                beanWrapper = new BeanWrapperImpl(object);
                this.beanWrappers.put(object, beanWrapper);
            }
            return beanWrapper;
        }

        private Set<String> toSetOfNames(Object[] objectArray) {
            if (CollectionHelper.isEmpty((Object[])objectArray)) {
                return Collections.emptySet();
            }
            return Stream.of(objectArray).map(PropertyHelper::getPropertyName).collect(Collectors.toSet());
        }
    }

    private static enum TransactionEndType {
        COMMIT,
        ROLLBACK,
        END;

    }

    private static class FormatterKey {
        private Long configurationId;
        private Long languageId;

        public FormatterKey(ConfigurationAccessor configurationAccessor) {
            this.configurationId = configurationAccessor.getConfiguration().getId();
            this.languageId = configurationAccessor.getLanguage().getId();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FormatterKey formatterKey = (FormatterKey)object;
            if (this.configurationId == null ? formatterKey.configurationId != null : !this.configurationId.equals(formatterKey.configurationId)) {
                return false;
            }
            return !(this.languageId == null ? formatterKey.languageId != null : !this.languageId.equals(formatterKey.languageId));
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.configurationId == null ? 0 : this.configurationId.hashCode());
            n = 31 * n + (this.languageId == null ? 0 : this.languageId.hashCode());
            return n;
        }

        public String toString() {
            return "Formatter for configuration " + this.configurationId + " and language " + this.languageId;
        }
    }

    private static class TransactionEndListener {
        private TransactionEndType type;
        private boolean requiresTransaction;
        private Consumer<Boolean> callback;
        private boolean afterAwakingRecurringTasks;
        private SessionData sessionData;

        public TransactionEndListener(TransactionEndType transactionEndType, boolean bl, boolean bl2, Consumer<Boolean> consumer, SessionData sessionData) {
            this.type = transactionEndType;
            this.requiresTransaction = bl;
            this.afterAwakingRecurringTasks = bl2;
            this.callback = consumer;
            this.sessionData = sessionData;
        }
    }

    private static class CacheTypeComparator
    implements Comparator<CacheType<?, ?>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private CacheTypeComparator() {
        }

        @Override
        public int compare(CacheType<?, ?> cacheType, CacheType<?, ?> cacheType2) {
            return cacheType.compareTo(cacheType2);
        }
    }
}

