/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.EnumSet;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.UserPrincipals;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.AccessClientSessionData;
import org.cyclos.impl.access.DirectUserSessionData;
import org.cyclos.impl.access.GuestSessionData;
import org.cyclos.impl.access.OidcSessionData;
import org.cyclos.impl.access.ScriptSessionData;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.StatefulUserSessionData;
import org.cyclos.impl.access.StatelessUserSessionData;
import org.cyclos.impl.access.SystemSessionData;
import org.cyclos.impl.access.UrgentSituation;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.utils.StringHelper;

public class SessionDataFactory {
    public static SessionData accessClient(boolean bl, String string, String string2, RequestData requestData) {
        return new AccessClientSessionData(bl, string, string2, requestData);
    }

    public static DirectSessionDataBuilder direct(BasicUser basicUser) {
        return SessionDataFactory.direct(UserPrincipals.username((BasicUser)basicUser));
    }

    public static DirectSessionDataBuilder direct(UserPrincipal userPrincipal) {
        return new DirectSessionDataBuilder(userPrincipal);
    }

    public static SessionData guest(RequestData requestData, String string) {
        return new GuestSessionData(requestData, string, string);
    }

    public static SessionData guest(RequestData requestData, String string, String string2) {
        return new GuestSessionData(requestData, string, string2);
    }

    public static SessionData inChannel(String string) {
        SessionData sessionData = InvocationContext.ensure().sessionData();
        if (StringHelper.isBlank((Object)string) || string.equals(sessionData.getChannelName())) {
            return sessionData;
        }
        RequestData requestData = sessionData.getRequestData();
        if (requestData == null) {
            requestData = new RequestData();
        }
        if (sessionData.isSystem()) {
            return SessionDataFactory.system(requestData, string, sessionData.getAccessChannelName());
        }
        if (sessionData.isGuest()) {
            return SessionDataFactory.guest(requestData, string, sessionData.getAccessChannelName());
        }
        return SessionDataFactory.direct((UserPrincipal)sessionData).channel(string).build();
    }

    public static SessionData oidc(String string, RequestData requestData) {
        return new OidcSessionData(string, requestData);
    }

    public static SessionData script(boolean bl) {
        return SessionDataFactory.script(InvocationContext.getSessionData(), bl);
    }

    public static SessionData script(SessionData sessionData, boolean bl) {
        return new ScriptSessionData(sessionData, bl);
    }

    public static SessionData stateful(Session session, RequestData requestData) {
        return new StatefulUserSessionData(session, requestData);
    }

    public static SessionData stateful(String string, String string2, RequestData requestData) {
        return new StatefulUserSessionData(string, string2, requestData);
    }

    public static SessionData stateless(boolean bl, boolean bl2, String string, String string2, String string3, String string4, RequestData requestData) {
        return new StatelessUserSessionData(bl, bl2, string, string2, string3, string4, requestData);
    }

    public static SessionData system() {
        SessionData sessionData;
        InvocationContext invocationContext = InvocationContext.get();
        RequestData requestData = null;
        String string = null;
        if (invocationContext != null && (sessionData = invocationContext.sessionData()) != null) {
            requestData = sessionData.getRequestData();
            string = sessionData.getChannelName();
        }
        if (requestData == null) {
            requestData = new RequestData();
        }
        if (string == null) {
            string = BuiltInChannel.MAIN.getInternalName();
        }
        return SessionDataFactory.system(requestData, string, string);
    }

    public static SessionData system(Network network) throws IllegalStateException {
        return SessionDataFactory.system(network, null);
    }

    public static SessionData system(Network network, String string) throws IllegalStateException {
        SessionData sessionData;
        if (network == null) {
            return SessionDataFactory.system();
        }
        InvocationContext invocationContext = InvocationContext.get();
        SessionData sessionData2 = sessionData = invocationContext == null ? SessionDataFactory.system() : invocationContext.sessionData();
        if (string == null) {
            string = sessionData.getChannelName() != null ? sessionData.getChannelName() : BuiltInChannel.MAIN.getInternalName();
        }
        Configuration configuration = network.getDefaultConfiguration();
        RequestData requestData = new RequestData(sessionData.getRequestData());
        requestData.setNetworkId(SimpleEntity.id((SimpleEntity)network));
        requestData.setConfigurationId(configuration.getId());
        requestData.setNetworkInternalName(network.getInternalName());
        requestData.setProcessedIds(true);
        return SessionDataFactory.system(requestData, string, string);
    }

    public static SessionData system(RequestData requestData) {
        return new SystemSessionData(requestData, BuiltInChannel.MAIN.getInternalName(), BuiltInChannel.MAIN.getInternalName());
    }

    public static SessionData system(RequestData requestData, String string) {
        return new SystemSessionData(requestData, string, string);
    }

    public static SessionData system(RequestData requestData, String string, String string2) {
        return new SystemSessionData(requestData, string, string2);
    }

    public static SessionData user(BasicUser basicUser) {
        return SessionDataFactory.user(UserPrincipals.username((BasicUser)basicUser));
    }

    public static SessionData user(UserPrincipal userPrincipal) {
        return SessionDataFactory.direct(userPrincipal).build();
    }

    public static class DirectSessionDataBuilder {
        private UserPrincipal principal;
        private Pin pin;
        private IdentityProvider identityProvider;
        private String channel;
        private String accessChannel;
        private RequestData requestData;
        private EnumSet<UrgentSituation> honorUrgentSituations;
        private SessionData sessionData;

        public DirectSessionDataBuilder(UserPrincipal userPrincipal) {
            this.principal = userPrincipal;
            if (userPrincipal instanceof SessionData) {
                this.sessionData = (SessionData)userPrincipal;
                this.pin = this.sessionData.getPin();
                this.identityProvider = this.sessionData.getIdentityProvider();
            }
        }

        public DirectSessionDataBuilder accessChannel(BuiltInChannel builtInChannel) {
            return this.accessChannel(builtInChannel.getInternalName());
        }

        public DirectSessionDataBuilder accessChannel(String string) {
            this.accessChannel = string;
            return this;
        }

        public DirectSessionDataBuilder basedOn(SessionData sessionData) {
            this.sessionData = sessionData;
            return this;
        }

        public DirectUserSessionData build() {
            Object object;
            BasicUser basicUser;
            BasicUser basicUser2 = basicUser = this.principal == null ? null : this.principal.getBasicUser();
            if (basicUser == null) {
                throw new IllegalStateException("No user in DirectUserSessionData");
            }
            if (this.sessionData == null) {
                this.sessionData = InvocationContext.getSessionData();
            }
            if (this.channel == null) {
                this.channel = this.sessionData.getChannelName();
            }
            if (this.requestData == null) {
                this.requestData = this.sessionData.getRequestData();
                Network network = this.sessionData.getNetwork();
                object = basicUser.getNetwork();
                if (object != null && !object.equals((Object)network)) {
                    this.requestData = new RequestData(this.requestData);
                    this.requestData.setProcessedIds(true);
                    this.requestData.setConfigurationId(basicUser.getUser().getGroup().getConfiguration().getId());
                    this.requestData.setNetworkId(object.getId());
                    this.requestData.setNetworkInternalName(object.getInternalName());
                }
            }
            boolean bl = basicUser.equals((Object)this.sessionData.getBasicUser());
            object = StringHelper.isBlank((Object)this.accessChannel) ? this.sessionData.getAccessChannelName() : this.accessChannel;
            return new DirectUserSessionData(this.channel, (String)object, this.principal, this.pin, this.identityProvider, bl ? this.sessionData.getSession() : null, this.requestData, this.honorUrgentSituations);
        }

        public DirectSessionDataBuilder channel(BuiltInChannel builtInChannel) {
            return this.channel(builtInChannel.getInternalName());
        }

        public DirectSessionDataBuilder channel(String string) {
            this.channel = string;
            return this;
        }

        public DirectSessionDataBuilder honorAllUrgentSituations() {
            this.honorUrgentSituations = EnumSet.allOf(UrgentSituation.class);
            return this;
        }

        public DirectSessionDataBuilder honorUrgentSituation(UrgentSituation urgentSituation) {
            if (this.honorUrgentSituations == null) {
                this.honorUrgentSituations = EnumSet.of(urgentSituation);
            } else {
                this.honorUrgentSituations.add(urgentSituation);
            }
            return this;
        }

        public DirectSessionDataBuilder requestData(RequestData requestData) {
            this.requestData = requestData;
            return this;
        }
    }
}

