/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.Collection;
import java.util.Set;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.SessionProperties;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.users.users.UserLocatorVO;

public interface SessionHandler {
    public static final String ATTR_USER = "user";
    public static final String ATTR_PRINCIPAL = "principal";
    public static final String ATTR_TRUSTED = "trusted";
    public static final String ATTR_SESSION_TOKEN = "sessionToken";
    public static final String ATTR_SESSION_PROPERTIES = "sessionProperties";
    public static final String ATTR_CHANNEL = "channel";
    public static final String ATTR_SESSION_TIMEOUT = "sessionTimeout";
    public static final String ATTR_REMOTE_ADDRESS = "remoteAddress";
    public static final String ATTR_QUERY = "query";

    public AccessClient checkAccessClientAccess(boolean var1, Network var2, String var3, String var4, String var5);

    public OidcAccessToken checkOidcAccessToken(Network var1, String var2, String var3);

    public UserCheckResult checkUserAccess(boolean var1, boolean var2, Network var3, String var4, String var5, UserLocatorVO var6, String var7, Set<Group> var8);

    public void clearPinCreationToken(Session var1);

    public void confirmLogin(String var1) throws FrameworkException;

    public Session create(CreateSessionParameters var1);

    public Session getIfValid(String var1, String var2);

    public String getPinCreationToken(Session var1);

    public TimeInterval getSessionTimeout(Session var1);

    public boolean invalidate(String var1, String var2);

    public Session login(String var1, String var2, TimeInterval var3, UserLocatorVO var4, String var5, Set<Group> var6) throws FrameworkException, LoginException, RemoteAddressBlockedException;

    public int purgeExpired();

    public int remove(Collection<String> var1);

    public boolean remove(Session var1);

    public String replace(Session var1);

    public void setProperties(Session var1, SessionProperties var2);

    public void updateTimeout(String var1, TimeInterval var2);

    public static class UserCheckResult {
        private final Channel channel;
        private final LocateUserResult locateUserResult;

        public UserCheckResult(Channel channel, LocateUserResult locateUserResult) {
            this.channel = channel;
            this.locateUserResult = locateUserResult;
        }

        public AccessClient getAccessClient() {
            return this.locateUserResult.getAccessClient();
        }

        public Channel getChannel() {
            return this.channel;
        }

        public LocateUserResult getLocateUserResult() {
            return this.locateUserResult;
        }

        public Pin getPin() {
            return this.locateUserResult.getPin();
        }

        public String getPrincipal() {
            return this.locateUserResult.getPrincipal();
        }

        public PrincipalType getPrincipalType() {
            return this.locateUserResult.getPrincipalType();
        }

        public Token getToken() {
            return this.locateUserResult.getToken();
        }

        public BasicUser getUser() {
            return this.locateUserResult.getBasicUser();
        }
    }

    public static class CreateSessionParameters {
        private final SessionData sessionData;
        private TimeInterval customTimeout;
        private String deviceConfirmationId;
        private Long deviceId;
        private String hmac;

        public CreateSessionParameters(SessionData sessionData) {
            this.sessionData = sessionData;
        }

        public TimeInterval getCustomTimeout() {
            return this.customTimeout;
        }

        public String getDeviceConfirmationId() {
            return this.deviceConfirmationId;
        }

        public Long getDeviceId() {
            return this.deviceId;
        }

        public String getHmac() {
            return this.hmac;
        }

        public SessionData getSessionData() {
            return this.sessionData;
        }

        public void setCustomTimeout(TimeInterval timeInterval) {
            this.customTimeout = timeInterval;
        }

        public void setTrustedParams(String string, Long l, String string2) {
            this.deviceConfirmationId = string;
            this.deviceId = l;
            this.hmac = string2;
        }
    }
}

