/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.access.UserSessionData;
import org.cyclos.model.access.LoggedOutException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.login.UserAuthVO;
import org.cyclos.server.model.access.login.SessionSource;
import org.cyclos.utils.ObjectHelper;

public class StatefulUserSessionData
extends UserSessionData {
    private String sessionToken;
    private final String remoteAddress;
    private String channelName;
    private Session session;
    private TimeInterval sessionTimeout;

    StatefulUserSessionData(Session session, RequestData requestData) {
        super(requestData);
        this.session = session;
        this.sessionToken = session.getSessionToken();
        this.remoteAddress = session.getRemoteAddress();
        SessionHandler sessionHandler = InvocationContext.bean(SessionHandler.class);
        this.sessionTimeout = sessionHandler.getSessionTimeout(session);
    }

    StatefulUserSessionData(String string, String string2, RequestData requestData) {
        super(requestData);
        this.sessionToken = string;
        this.remoteAddress = (String)ObjectHelper.defaultValue((Object)string2, (Object)requestData.getRemoteAddress());
    }

    @Override
    public String getAccessChannelName() {
        return this.getChannelName();
    }

    @Override
    public UserAuthVO getAuthenticatedUser() {
        UserAuthVO userAuthVO = super.getAuthenticatedUser();
        if (userAuthVO != null) {
            userAuthVO.setSessionToken(this.sessionToken);
        }
        return userAuthVO;
    }

    @Override
    public String getChannelName() {
        if (this.channelName == null) {
            this.channelName = this.getSession().getChannel().getInternalName();
        }
        return this.channelName;
    }

    @Override
    public IdentityProvider getIdentityProvider() {
        return this.getSession().getIdentityProvider();
    }

    @Override
    public Pin getPin() {
        return this.getSession().getPin();
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public Session getSession() {
        if (this.session == null) {
            SessionHandler sessionHandler = InvocationContext.bean(SessionHandler.class);
            this.session = this.runAsSystem(() -> sessionHandler.getIfValid(this.remoteAddress, this.sessionToken), false);
            if (this.session == null) {
                throw new LoggedOutException();
            }
            this.sessionTimeout = sessionHandler.getSessionTimeout(this.session);
        }
        return this.session;
    }

    public TimeInterval getSessionTimeout() {
        if (this.sessionTimeout == null) {
            this.getSession();
        }
        return this.sessionTimeout;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void replaceSessionToken(String string) {
        this.sessionToken = string;
    }

    public void setSessionTimeout(TimeInterval timeInterval) {
        this.sessionTimeout = timeInterval;
    }

    public String toString() {
        return "USER#" + this.getSession().getUser().getId() + ", session token: " + this.sessionToken;
    }

    @Override
    protected Long doGetLoggedBasicUserId() {
        return this.getSession().getUser().getId();
    }

    @Override
    protected UserPrincipal doGetUserPrincipal() {
        return this.getSession();
    }

    @Override
    protected boolean doHasExpiredPassword() {
        if (this.getSession().getProperties().getSource() == SessionSource.TRUSTED_DEVICE) {
            return false;
        }
        return super.doHasExpiredPassword();
    }

    @Override
    protected boolean requiresLoginConfirmation(CredentialsConfiguration credentialsConfiguration) {
        return this.getSession().isPendingLoginConfirmation() && super.requiresLoginConfirmation(credentialsConfiguration);
    }

    @Override
    protected boolean shouldCheckRemoteAddress() {
        return false;
    }
}

