/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.Password;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.AbstractSessionData;
import org.cyclos.impl.access.AgreementLogServiceLocal;
import org.cyclos.impl.access.AuthHandler;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.access.CredentialAccessor;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.SessionDataSubjectId;
import org.cyclos.impl.access.UserChannelServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.EmptyProductsAccessor;
import org.cyclos.impl.users.GroupsHandlerInternal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProductsHandler;
import org.cyclos.impl.utils.InternetAddressListHandler;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.InaccessibleChannelException;
import org.cyclos.model.access.InvalidNetworkException;
import org.cyclos.model.access.InvalidSessionDataException;
import org.cyclos.model.access.LoggedOutException;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.OperatorWithPendingAgreementsException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionUserAccess;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.UnauthorizedAddressException;
import org.cyclos.model.access.clients.AccessClientStatus;
import org.cyclos.model.access.clients.AccessClientVO;
import org.cyclos.model.access.login.UserAuthVO;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.PasswordData;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.access.passwordtypes.PasswordTypeDetailedVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.tokens.TokenStatus;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.users.BasicUserVO;

public abstract class UserSessionData
extends AbstractSessionData {
    private Long groupId;
    private Long userId;
    private Boolean hasPendingAgreements;
    private Boolean hasExpiredPassword;
    private boolean loginConfirmationComputed;
    private CredentialInputDTO loginConfirmation;
    private Set<Role> roles;
    private UserPrincipal userPrincipal;

    public UserSessionData(RequestData requestData) {
        super(requestData);
    }

    @Override
    public void checkConsistency() throws InvalidSessionDataException, LoginException {
        AdminGroup adminGroup;
        Object object;
        Object object2;
        Network network;
        Channel channel;
        super.checkConsistency();
        BasicUser basicUser = this.getLoggedBasicUser();
        if (basicUser == null || !basicUser.getUser().isActive()) {
            throw new LoginException(basicUser == null ? null : basicUser.getUser().getStatus());
        }
        try {
            channel = this.getChannel();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            throw new InaccessibleChannelException();
        }
        UserChannelServiceLocal userChannelServiceLocal = this.bean(UserChannelServiceLocal.class);
        if (!userChannelServiceLocal.isChannelAccessible(basicUser, channel)) {
            throw new InaccessibleChannelException();
        }
        boolean bl = basicUser.isGlobalAdmin();
        if (!bl) {
            network = this.getNetwork();
            if (network == null) {
                bl = basicUser.isGlobal();
            } else {
                object2 = basicUser.getNetwork();
                if (object2 == null) {
                    Object object3 = object = basicUser == null ? null : basicUser.getUser().getGroup();
                    if (object instanceof AdminGroup) {
                        adminGroup = (AdminGroup)object;
                        bl = adminGroup.getManagedNetworks().contains(network);
                    }
                } else {
                    bl = object2.equals((Object)network);
                }
            }
        }
        if (!bl) {
            throw new InvalidNetworkException();
        }
        if (basicUser instanceof Operator) {
            network = (Operator)basicUser;
            if (this.hasPendingAgreements() && network.getGroup() != null) {
                throw new OperatorWithPendingAgreementsException();
            }
            object2 = InvocationContext.bean(ProductsHandler.class);
            if (!object2.getAccessor((BasicUser)network.getUser(), channel, this.getPrincipalType()).memberOrBroker().hasPermission(Permission.MY_OPERATORS_ENABLE)) {
                throw new LoginException();
            }
        }
        if ((network = this.getAccessClient()) != null && network.getStatus() != AccessClientStatus.ACTIVE) {
            throw new LoggedOutException();
        }
        object2 = this.getToken();
        if (object2 != null && object2.getStatus() != TokenStatus.ACTIVE) {
            throw new LoggedOutException();
        }
        object = new HashSet();
        object.add(this.requestData.getRemoteAddress());
        adminGroup = this.getSession();
        if (adminGroup != null) {
            object.add(adminGroup.getRemoteAddress());
        }
        ChannelAccessAccessor channelAccessAccessor = this.getChannelAccessAccessor();
        InternetAddressListHandler internetAddressListHandler = InvocationContext.bean(InternetAddressListHandler.class);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (internetAddressListHandler.isWhitelisted(channelAccessAccessor.getWhitelist(), string)) continue;
            throw new UnauthorizedAddressException();
        }
    }

    @Override
    public final AccessClient getAccessClient() {
        return this.getUserPrincipal().getAccessClient();
    }

    @Override
    public Set<BasicGroup> getAccessibleBasicGroups() {
        return this.bean(GroupsHandlerInternal.class).getAccessibleBasicGroups(false, (BasicGroup)this.getGroup(), this.getProducts());
    }

    @Override
    public final UserAccountType getAccountType() {
        return this.getUserPrincipal().getAccountType();
    }

    @Override
    public UserAuthVO getAuthenticatedUser() {
        BasicUser basicUser = this.getLoggedBasicUser();
        ConversionHandler conversionHandler = this.bean(ConversionHandler.class);
        PrincipalType principalType = this.getPrincipalType();
        User user = basicUser.getUser();
        UserAuthVO userAuthVO = new UserAuthVO();
        userAuthVO.setGlobal(user.isGlobal());
        userAuthVO.setUser(conversionHandler.convert(BasicUserVO.class, basicUser));
        userAuthVO.setPrincipalType(conversionHandler.convert(PrincipalTypeVO.class, principalType));
        userAuthVO.setPrincipal(this.getPrincipal());
        userAuthVO.setRoles(this.getRoles());
        userAuthVO.setPermissions(this.getPermissions());
        userAuthVO.setHasPendingAgreements(this.hasPendingAgreements());
        userAuthVO.setHasExpiredPassword(this.hasExpiredPassword());
        userAuthVO.setLoginConfirmation(this.getLoginConfirmation());
        userAuthVO.setAccessClient(conversionHandler.convert(AccessClientVO.class, this.getAccessClient()));
        if (this.returnPendingPasswords()) {
            ArrayList<PasswordData> arrayList = new ArrayList<PasswordData>();
            for (Password password : user.getPasswords()) {
                if (password.getStatus() != PasswordStatus.PENDING) continue;
                PasswordData passwordData = new PasswordData();
                passwordData.setType(conversionHandler.convert(PasswordTypeDetailedVO.class, password.getType()));
                arrayList.add(passwordData);
            }
            userAuthVO.setPendingPasswords(arrayList);
        }
        return userAuthVO;
    }

    @Override
    public final BasicUser getBasicUser() {
        return this.getUserPrincipal().getBasicUser();
    }

    @Override
    public ChannelAccessAccessor getChannelAccessAccessor() {
        ConfigurationHandler configurationHandler = this.bean(ConfigurationHandler.class);
        Group group = this.getLoggedUser().getGroup();
        ConfigurationAccessor configurationAccessor = configurationHandler.getAccessor((BasicGroup)group);
        return new AbstractSessionData.SessionDataChannelAccessAccessor(this, configurationAccessor);
    }

    @Override
    public final UserCustomFieldValue getCustomFieldValue() {
        return this.getUserPrincipal().getCustomFieldValue();
    }

    @Override
    public Group getGroup() {
        if (this.groupId == null) {
            Network network;
            BasicUser basicUser = this.getLoggedBasicUser();
            if (basicUser.isGlobal() && (network = this.getNetwork()) != null) {
                return network.getAdministrators();
            }
            this.groupId = SimpleEntity.id((SimpleEntity)basicUser.getUser().getGroup());
        }
        return this.getRawEntityManagerHandler().find(Group.class, this.groupId);
    }

    @Override
    public final BasicUser getLoggedBasicUser() {
        if (this.userId == null) {
            this.userId = this.doGetLoggedBasicUserId();
        }
        return this.getRawEntityManagerHandler().find(BasicUser.class, this.userId);
    }

    public final CredentialInputDTO getLoginConfirmation() {
        if (!this.loginConfirmationComputed) {
            CredentialsConfiguration credentialsConfiguration = this.getChannelAccessAccessor().getLoginConfirmation();
            if (credentialsConfiguration != null && !credentialsConfiguration.isDefined()) {
                credentialsConfiguration = null;
            }
            if (credentialsConfiguration != null && this.requiresLoginConfirmation(credentialsConfiguration)) {
                PasswordHandler passwordHandler = this.bean(PasswordHandler.class);
                CredentialAccessor credentialAccessor = passwordHandler.accessor(CredentialUsage.LOGIN_CONFIRMATION);
                this.loginConfirmation = credentialAccessor.getCredentialInput();
            }
            this.loginConfirmationComputed = true;
        }
        return this.loginConfirmation;
    }

    @Override
    public final MobilePhone getMobilePhone() {
        return this.getUserPrincipal().getMobilePhone();
    }

    @Override
    public final String getPrincipal() {
        return this.getUserPrincipal().getPrincipal();
    }

    @Override
    public final PrincipalType getPrincipalType() {
        return this.getUserPrincipal().getPrincipalType();
    }

    @Override
    public final Token getToken() {
        return this.getUserPrincipal().getToken();
    }

    @Override
    public final TrustedDevice getTrustedDevice() {
        return this.getUserPrincipal().getTrustedDevice();
    }

    public final UserPrincipal getUserPrincipal() {
        if (this.userPrincipal == null) {
            this.userPrincipal = this.doGetUserPrincipal();
        }
        return this.userPrincipal;
    }

    public final boolean hasExpiredPassword() {
        if (this.hasExpiredPassword == null) {
            this.hasExpiredPassword = this.doHasExpiredPassword();
        }
        return this.hasExpiredPassword;
    }

    public final boolean hasPendingAgreements() {
        return this.doHasPendingAgreements(this.getProducts());
    }

    @Override
    public boolean hasRequiredValue(Permission permission, Object object) {
        AuthHandler authHandler = this.bean(AuthHandler.class);
        Collection<?> collection = authHandler.getRequiredValues(permission);
        return collection == null || collection.contains(object);
    }

    @Override
    public boolean isAdmin() {
        return this.getLoggedBasicUser().isAdmin();
    }

    @Override
    public boolean isAdminOf(BasicUser basicUser) {
        AuthHandler authHandler = this.bean(AuthHandler.class);
        return authHandler.isAdminOf(this.getLoggedUser(), basicUser);
    }

    @Override
    public boolean isAliasOperator() {
        return this.getLoggedBasicUser().isAliasOperator();
    }

    @Override
    public boolean isBroker() {
        return this.getLoggedBasicUser().isBroker();
    }

    @Override
    public boolean isBrokerOf(BasicUser basicUser) {
        AuthHandler authHandler = this.bean(AuthHandler.class);
        return authHandler.isBrokerOf(this.getLoggedBasicUser(), basicUser);
    }

    @Override
    public boolean isGlobalAdmin() {
        return this.getAdminGroupType() == AdminGroupType.GLOBAL;
    }

    @Override
    public boolean isLoggedIn() {
        return true;
    }

    @Override
    public boolean isMember() {
        return this.getLoggedBasicUser().isMember();
    }

    @Override
    public boolean isNetworkAdmin() {
        return this.getAdminGroupType() == AdminGroupType.NETWORK;
    }

    @Override
    public boolean isOperator() {
        return this.getLoggedBasicUser().isOperator();
    }

    @Override
    public boolean isOwnerOf(BasicUser basicUser) {
        if (basicUser == null || !basicUser.isOperator()) {
            return false;
        }
        BasicUser basicUser2 = this.getLoggedBasicUser();
        if (basicUser2.equals((Object)basicUser.getUser())) {
            return true;
        }
        if (basicUser2.isAliasOperator()) {
            Operator operator = (Operator)basicUser2;
            return !operator.equals((Object)basicUser) && operator.getUser().equals((Object)basicUser.getUser());
        }
        return false;
    }

    @Override
    public boolean isRestrictedOperator() {
        return this.getLoggedBasicUser().isRestrictedOperator();
    }

    @Override
    public boolean isVisible(EntityCheck<SimpleEntity> entityCheck, SimpleEntity simpleEntity) {
        return entityCheck.isVisible(this, simpleEntity);
    }

    @Override
    public boolean manages(BasicUser basicUser) {
        if (basicUser == null) {
            return false;
        }
        if (basicUser.isTransient() || this.getLoggedBasicUser().equals((Object)basicUser)) {
            return true;
        }
        AuthHandler authHandler = this.bean(AuthHandler.class);
        return authHandler.manages(this.getLoggedBasicUser(), basicUser);
    }

    @Override
    public boolean relatesTo(BasicUser basicUser) {
        if (basicUser == null) {
            return false;
        }
        if (basicUser.isTransient() || this.getLoggedBasicUser().equals((Object)basicUser)) {
            return true;
        }
        AuthHandler authHandler = this.bean(AuthHandler.class);
        return authHandler.relatesTo(this.getLoggedBasicUser(), basicUser);
    }

    @Override
    protected final Long doGetConfigurationId() {
        return SimpleEntity.id((SimpleEntity)this.getGroup().getConfiguration());
    }

    protected abstract Long doGetLoggedBasicUserId();

    @Override
    protected List<String> doGetPreferredLocales() {
        BasicUser basicUser = this.getLoggedBasicUser();
        if (basicUser.getLocale() != null) {
            return Collections.singletonList(basicUser.getLocale());
        }
        if (this.fallbackToDefaultLocales()) {
            return super.doGetPreferredLocales();
        }
        return Collections.emptyList();
    }

    @Override
    protected final ProductsAccessor doGetProducts() {
        if (!this.isTrusted() && this.getChannelAccessAccessor().isRequireTrustedDeviceForLogin()) {
            return EmptyProductsAccessor.getInstance();
        }
        ProductsHandler productsHandler = this.bean(ProductsHandler.class);
        ProductsAccessor productsAccessor = this.resolveProductsAccessor(productsHandler);
        EnumSet<EmptyProductsAccessor.Access> enumSet = EnumSet.noneOf(EmptyProductsAccessor.Access.class);
        if (this.doHasPendingAgreements(productsAccessor)) {
            enumSet.add(EmptyProductsAccessor.Access.AGREEMENTS);
        }
        if (this.hasExpiredPassword() || this.getLoginConfirmation() != null) {
            enumSet.add(EmptyProductsAccessor.Access.MANAGE_PASSWORDS);
        }
        return enumSet.isEmpty() && this.getLoginConfirmation() == null ? productsAccessor : EmptyProductsAccessor.getInstance(enumSet, productsAccessor);
    }

    @Override
    protected SessionDataSubjectId doGetSubjectId() {
        return SessionDataSubjectId.user(this.getLoggedBasicUser());
    }

    protected abstract UserPrincipal doGetUserPrincipal();

    protected boolean doHasExpiredPassword() {
        return this.getIdentityProvider() == null && this.hasExpired(CredentialUsage.ACCESS);
    }

    protected boolean doHasPendingAgreements(ProductsAccessor productsAccessor) {
        if (this.hasPendingAgreements == null) {
            User user = this.getLoggedUser();
            this.hasPendingAgreements = false;
            if (!user.isGlobalAdmin() && !user.isGlobal()) {
                AgreementLogServiceLocal agreementLogServiceLocal = InvocationContext.bean(AgreementLogServiceLocal.class);
                this.hasPendingAgreements = agreementLogServiceLocal.hasPendingAgreements(user, productsAccessor);
            }
        }
        return this.hasPendingAgreements;
    }

    @Override
    protected boolean doHasPermission(Permission permission) {
        if (permission.getUserAccess() == PermissionUserAccess.MY && this.isGlobalAdminInNetwork()) {
            return false;
        }
        return this.getProducts().product().hasPermission(permission);
    }

    protected boolean fallbackToDefaultLocales() {
        return true;
    }

    protected Set<Permission> getPermissions() {
        HashSet<Permission> hashSet = new HashSet<Permission>(this.getProducts().product().getPermissions());
        hashSet.removeIf(permission -> !this.hasPermission((Permission)permission));
        return hashSet;
    }

    protected Set<Role> getRoles() {
        if (this.roles == null) {
            this.roles = PermissionHelper.allRoles(this);
        }
        return this.roles;
    }

    protected boolean requiresLoginConfirmation(CredentialsConfiguration credentialsConfiguration) {
        return credentialsConfiguration != null;
    }

    protected ProductsAccessor resolveProductsAccessor(ProductsHandler productsHandler) {
        return productsHandler.getAccessor(this.getLoggedBasicUser(), this.getChannel(), this.getPrincipalType());
    }

    protected boolean returnPendingPasswords() {
        return true;
    }

    private AdminGroupType getAdminGroupType() {
        Group group = this.getGroup();
        return group instanceof AdminGroup ? ((AdminGroup)group).getAdminType() : null;
    }

    private boolean hasExpired(CredentialUsage credentialUsage) {
        PasswordHandler passwordHandler = this.bean(PasswordHandler.class);
        CredentialAccessor credentialAccessor = passwordHandler.accessor(credentialUsage);
        return credentialAccessor.hasExpired();
    }
}

