/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.math.BigDecimal;
import java.util.Collection;
import org.cyclos.entities.access.Channel;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PerformBasePaymentDTO;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;

public class PrepareValidationParameter {
    private PerformTransactionDTO performTransactionDTO;
    private LocateAccountOwnerResult from;
    private LocateAccountOwnerResult to;
    private SessionData receiverSessionData;
    private PaymentCreationType creationType;
    private Channel channel;
    private boolean isInternal;
    private String fromName;
    private String toName;
    private boolean validateCustomFields;
    private boolean ignoreChannelForPaymentType;
    private boolean allowSearchingTTWhenNoneIsGiven;
    private boolean validateConfirmationPassword;
    private boolean excludeHideInForm;
    private boolean validateNFCChallenge;
    private boolean validateDescription = true;
    private boolean validateAmount;
    private boolean fromRequired = true;

    private PrepareValidationParameter(PerformTransactionDTO performTransactionDTO, LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, SessionData sessionData, PaymentCreationType paymentCreationType) {
        this.performTransactionDTO = performTransactionDTO;
        this.from = locateAccountOwnerResult;
        this.to = locateAccountOwnerResult2;
        this.receiverSessionData = sessionData;
        this.creationType = paymentCreationType;
        this.ignoreChannelForPaymentType = paymentCreationType.isIgnoreChannelForPaymentType();
    }

    public BigDecimal getAmount() {
        return this.performTransactionDTO.getAmount();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public PaymentCreationType getCreationType() {
        return this.creationType;
    }

    public CurrencyVO getCurrency() {
        return this.performTransactionDTO.getCurrency();
    }

    public Collection<CustomFieldValueDTO> getCustomValues() {
        return this.performTransactionDTO.getCustomValues();
    }

    public String getDescription() {
        return this.performTransactionDTO.getDescription();
    }

    public LocateAccountOwnerResult getFrom() {
        return this.from;
    }

    public String getFromName() {
        return this.fromName;
    }

    public String getNfcChallenge() {
        if (this.performTransactionDTO instanceof PerformBasePaymentDTO) {
            return ((PerformBasePaymentDTO)this.performTransactionDTO).getNfcChallenge();
        }
        return null;
    }

    public SessionData getReceiverSessionData() {
        return this.receiverSessionData;
    }

    public LocateAccountOwnerResult getTo() {
        return this.to;
    }

    public String getToName() {
        return this.toName;
    }

    public TransferTypeVO getType() {
        return this.performTransactionDTO.getType();
    }

    public boolean isAllowSearchingTTWhenNoneIsGiven() {
        return this.allowSearchingTTWhenNoneIsGiven;
    }

    public boolean isExcludeHideInForm() {
        return this.excludeHideInForm;
    }

    public boolean isFromRequired() {
        return this.fromRequired;
    }

    public boolean isIgnoreChannelForPaymentType() {
        return this.ignoreChannelForPaymentType;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isInverse() {
        return this.creationType.isInverse();
    }

    public boolean isValidateAmount() {
        return this.validateAmount;
    }

    public boolean isValidateConfirmationPassword() {
        return this.validateConfirmationPassword;
    }

    public boolean isValidateCustomFields() {
        return this.validateCustomFields;
    }

    public boolean isValidateDescription() {
        return this.validateDescription;
    }

    public boolean isValidateNFCChallenge() {
        return this.validateNFCChallenge;
    }

    public void setTypeToDTO(TransferTypeVO transferTypeVO) {
        this.performTransactionDTO.setType(transferTypeVO);
    }

    private PrepareValidationParameter initialize() {
        this.isInternal = this.performTransactionDTO instanceof PerformInternalTransactionDTO;
        this.fromName = this.isInternal ? ((PerformInternalTransactionDTO)this.performTransactionDTO).getFromName() : null;
        this.toName = this.isInternal ? ((PerformInternalTransactionDTO)this.performTransactionDTO).getToName() : null;
        return this;
    }

    public static class Builder {
        private PrepareValidationParameter parameter;

        public Builder(PerformTransactionDTO performTransactionDTO, LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, PaymentCreationType paymentCreationType) {
            this(performTransactionDTO, locateAccountOwnerResult, locateAccountOwnerResult2, null, paymentCreationType);
        }

        public Builder(PerformTransactionDTO performTransactionDTO, LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, SessionData sessionData, PaymentCreationType paymentCreationType) {
            this.parameter = new PrepareValidationParameter(performTransactionDTO, locateAccountOwnerResult, locateAccountOwnerResult2, sessionData, paymentCreationType);
        }

        public Builder allowSearchingTTWhenNoneIsGiven(boolean bl) {
            this.parameter.allowSearchingTTWhenNoneIsGiven = bl;
            return this;
        }

        public PrepareValidationParameter build() {
            return this.parameter.initialize();
        }

        public Builder channel(Channel channel) {
            this.parameter.channel = channel;
            return this;
        }

        public Builder excludeHideInForm(boolean bl) {
            this.parameter.excludeHideInForm = bl;
            return this;
        }

        public Builder fromRequired(boolean bl) {
            this.parameter.fromRequired = bl;
            return this;
        }

        public Builder validateAmount(boolean bl) {
            this.parameter.validateAmount = bl;
            return this;
        }

        public Builder validateConfirmationPassword(boolean bl) {
            this.parameter.validateConfirmationPassword = bl;
            return this;
        }

        public Builder validateCustomFields(boolean bl) {
            this.parameter.validateCustomFields = bl;
            return this;
        }

        public Builder validateDescription(boolean bl) {
            this.parameter.validateDescription = bl;
            return this;
        }

        public Builder validateNFCChallenge(boolean bl) {
            this.parameter.validateNFCChallenge = bl;
            return this;
        }
    }
}

