/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountRates;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.utils.RatedEntity;
import org.cyclos.impl.banking.FromRatesData;
import org.cyclos.impl.banking.RatesData;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.banking.currencies.CurrencyDTO;
import org.cyclos.model.banking.rates.HasRates;
import org.cyclos.model.banking.rates.RateVisibility;

public interface RateHandler {
    public <T extends Transfer> void applyTransfer(T var1) throws FrameworkException;

    public void copy(HasRates var1, HasRates var2) throws FrameworkException;

    public void copy(RatedEntity var1, RatedEntity var2);

    public AccountRates getCurrent(Account var1);

    public FromRatesData getFromRates(Account var1, TransferType var2, BigDecimal var3, Date var4, RateVisibility var5);

    public RatesData getRates(Account var1, BigDecimal var2, Date var3, RateVisibility var4) throws FrameworkException;

    public RatesData getRates(Account var1, RateVisibility var2) throws FrameworkException;

    public boolean isAnyRateEnabled(Currency var1, Date var2) throws FrameworkException;

    public boolean isVisible(Collection<Currency> var1, Date var2);

    public void resetCurrency(Currency var1) throws FrameworkException;

    public void resolveValidator(Validator var1, CurrencyDTO var2) throws FrameworkException;

    public void setRateParametersToCurrencyDTO(CurrencyDTO var1) throws FrameworkException;

    public void toEntity(Currency var1, CurrencyDTO var2) throws FrameworkException;
}

