/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.math.BigDecimal;
import java.util.Date;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.RateParameters;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.utils.RatedEntity;
import org.cyclos.impl.banking.FromRatesData;
import org.cyclos.impl.banking.RatesData;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.banking.currencies.CurrencyDTO;
import org.cyclos.model.banking.rates.HasRates;
import org.cyclos.model.banking.rates.RateParametersDTO;
import org.cyclos.model.banking.rates.RateType;
import org.cyclos.model.banking.rates.RateVisibility;

public interface RateTypeHandler<T, R extends RateParameters, D extends RateParametersDTO> {
    public static final int RATE_SCALE = 10;

    public void applyIncomingTransfer(RatesData var1, Transfer var2);

    public void calculateFromRates(FromRatesData var1, Account var2, TransferType var3, BigDecimal var4);

    public void complete(RatesData var1);

    public T convert(BigDecimal var1, Date var2);

    public BigDecimal convert(T var1, Date var2);

    public void copy(HasRates var1, HasRates var2);

    public BigDecimal getCreationValue(Currency var1, Date var2);

    public Date getEnableDate(Currency var1, Date var2);

    public T getNullSafeRawRate(RatedEntity var1, Currency var2, Date var3);

    public R getRateParameters(Currency var1);

    public R getRateParameters(Currency var1, Date var2);

    public D getRateParametersDTO(CurrencyDTO var1);

    public RateType getRateType();

    public boolean isEnabled(Currency var1, Date var2);

    public boolean isVisible(Account var1, Date var2, RateVisibility var3);

    public boolean isVisibleToUser(Currency var1, Date var2);

    public long nullAllAccountRates(Currency var1);

    public void resolveValidator(Validator var1, CurrencyDTO var2);

    public void setRate(HasRates var1, BigDecimal var2);

    public void setRawRate(RatedEntity var1, T var2);

    public void toEntity(Currency var1, D var2);
}

