/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.io.Serializable;
import java.util.Objects;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.system.Network;

public class TransferTypeCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Long networkId;
    private final Long currencyId;

    public TransferTypeCacheKey(Currency currency) {
        this.currencyId = SimpleEntity.id((SimpleEntity)currency);
        this.networkId = null;
    }

    public TransferTypeCacheKey(Network network) {
        this.networkId = SimpleEntity.id((SimpleEntity)network);
        this.currencyId = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TransferTypeCacheKey transferTypeCacheKey = (TransferTypeCacheKey)object;
        if (this.currencyId == null ? transferTypeCacheKey.currencyId != null : !this.currencyId.equals(transferTypeCacheKey.currencyId)) {
            return false;
        }
        return !(this.networkId == null ? transferTypeCacheKey.networkId != null : !this.networkId.equals(transferTypeCacheKey.networkId));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.currencyId == null ? 0 : this.currencyId.hashCode());
        n = 31 * n + (this.networkId == null ? 0 : this.networkId.hashCode());
        return n;
    }

    public boolean matches(Long l, Long l2) {
        if (l == null) {
            return true;
        }
        return l.equals(this.networkId) || Objects.equals(l2, this.currencyId);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TransferTypeCacheKey[");
        if (this.networkId == null && this.currencyId == null) {
            stringBuilder.append("Global");
        } else if (this.networkId != null) {
            stringBuilder.append("Network#").append(this.networkId);
        } else if (this.currencyId != null) {
            stringBuilder.append("Currency#").append(this.currencyId);
        }
        return stringBuilder.append(']').toString();
    }
}

