/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.cyclos.impl.RequestContext;
import org.cyclos.impl.sql.CachingConnection;
import org.cyclos.impl.sql.CachingResultSet;
import org.cyclos.impl.sql.CachingResultSetMetaData;
import org.cyclos.impl.sql.TableCacheKey;
import org.cyclos.impl.sql.TableCacheValue;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.system.ProfilingQueryEvent;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.model.system.profiling.StartProfilingParams;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.utils.CollectionHelper;
import org.springframework.jdbc.support.JdbcUtils;

public class CachingPreparedStatement
implements PreparedStatement {
    private final CachingConnection connection;
    private final CacheType<TableCacheKey, TableCacheValue> cacheType;
    private final String sql;
    private final ProfilingEntry profilingEntry;
    private final JsonConverter jsonConverter;
    private List<Object> parameters = new ArrayList<Object>();
    private CachingResultSet resultSet;
    private PreparedStatement liveStatement;
    private boolean closed;

    public CachingPreparedStatement(CachingConnection cachingConnection, CacheType<TableCacheKey, TableCacheValue> cacheType, String string, JsonConverter jsonConverter) {
        StartProfilingParams startProfilingParams;
        this.connection = cachingConnection;
        this.cacheType = cacheType;
        this.sql = string;
        RequestContext requestContext = RequestContext.get();
        StartProfilingParams startProfilingParams2 = startProfilingParams = requestContext == null ? null : requestContext.getProfilingParams();
        this.profilingEntry = startProfilingParams != null && startProfilingParams.isIncludeCacheableQueries() ? (requestContext == null ? null : requestContext.getProfilingEntry()) : null;
        this.jsonConverter = jsonConverter;
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void addBatch(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        if (this.liveStatement != null) {
            JdbcUtils.closeStatement((Statement)this.liveStatement);
            this.liveStatement = null;
        }
        this.closed = true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean execute() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public boolean execute(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        CacheHandler cacheHandler = this.connection.getCacheHandler();
        Cache<TableCacheKey, TableCacheValue> cache = cacheHandler.getCache(this.cacheType);
        MutableBoolean mutableBoolean = new MutableBoolean();
        try {
            java.util.Date date = new java.util.Date();
            TableCacheValue tableCacheValue = cache.get(new TableCacheKey(this.sql, this.parameters), () -> {
                mutableBoolean.setTrue();
                PreparedStatement preparedStatement = this.doGetLiveStatement();
                ResultSet resultSet = preparedStatement.getResultSet();
                CachingResultSetMetaData cachingResultSetMetaData = new CachingResultSetMetaData(resultSet.getMetaData());
                int n = cachingResultSetMetaData.getColumnCount();
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                while (resultSet.next()) {
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = resultSet.getObject(i + 1);
                    }
                    arrayList.add(objectArray);
                }
                return new TableCacheValue(cachingResultSetMetaData, arrayList);
            });
            this.resultSet = new CachingResultSet(this, tableCacheValue);
            if (this.profilingEntry != null && !mutableBoolean.booleanValue()) {
                ProfilingQueryEvent profilingQueryEvent = new ProfilingQueryEvent(this.sql);
                profilingQueryEvent.setTimestamp(date);
                profilingQueryEvent.setCached(true);
                profilingQueryEvent.setParameters(CollectionHelper.orEmpty(this.parameters).stream().map(object -> this.jsonConverter.toLogNode(object, false)).collect(Collectors.toList()));
                profilingQueryEvent.end();
                this.profilingEntry.addEvent(profilingQueryEvent);
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            int n = ExceptionUtils.indexOfType((Throwable)exception, SQLException.class);
            SQLException sQLException = n >= 0 ? (SQLException)ExceptionUtils.getThrowableList((Throwable)exception).get(n) : new SQLException(exception);
            throw sQLException;
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getResultSet().getMetaData();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        return false;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.resultSet == null) {
            this.executeQuery();
        }
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setParameter(n, bigDecimal);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setParameter(n, bl);
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.setParameter(n, by);
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.setParameter(n, date);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.setParameter(n, d);
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.setParameter(n, Float.valueOf(f));
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.setParameter(n, n2);
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.setParameter(n, l);
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.setParameter(n, null);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.setParameter(n, null);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.setParameter(n, object);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setParameter(n, object);
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setParameter(n, object);
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.setParameter(n, ref);
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.setParameter(n, rowId);
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.setParameter(n, s);
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.setParameter(n, sQLXML);
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.setParameter(n, string);
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.setParameter(n, time);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setParameter(n, timestamp);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException(new UnsupportedOperationException());
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.setParameter(n, uRL);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    private PreparedStatement doGetLiveStatement() throws SQLException {
        if (this.liveStatement == null) {
            this.liveStatement = this.connection.doPrepareStatement(this.sql, true);
            for (int i = 0; i < this.parameters.size(); ++i) {
                this.liveStatement.setObject(i + 1, this.parameters.get(i));
            }
            this.liveStatement.execute();
        }
        return this.liveStatement;
    }

    private void setParameter(int n, Object object) throws SQLException {
        int n2 = n - this.parameters.size();
        for (int i = 0; i < n2; ++i) {
            this.parameters.add(null);
        }
        this.parameters.set(n - 1, object);
    }
}

